/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.AxisAngle4d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.MultiblockRegistry;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.RudderAxleMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityMultiblockPartForce;
import org.valkyrienskies.mod.common.network.VSNetwork;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public class TileEntityRudderPart
extends TileEntityMultiblockPartForce<RudderAxleMultiblockSchematic, TileEntityRudderPart> {
    private double rudderAngle = 0.0;
    private double prevRudderAngle = 0.0;
    private double nextRudderAngle = 0.0;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.prevRudderAngle = this.rudderAngle;
        if (this.func_145831_w().field_72995_K) {
            this.rudderAngle += 0.5 * (this.nextRudderAngle - this.rudderAngle);
        }
    }

    public Vector3d getForcePositionInShipSpace() {
        Vector3d facingOffset = this.getForcePosRelativeToAxleInShipSpace();
        if (facingOffset != null) {
            return new Vector3d(facingOffset.x + (double)this.field_174879_c.func_177958_n() + 0.5, facingOffset.y + (double)this.field_174879_c.func_177956_o() + 0.5, facingOffset.z + (double)this.field_174879_c.func_177952_p() + 0.5);
        }
        return null;
    }

    private Vector3d getForcePosRelativeToAxleInShipSpace() {
        if (this.getRudderAxleSchematic().isPresent()) {
            Vec3i directionFacing = this.getRudderAxleFacingDirection().get().func_176730_m();
            Vec3i directionAxle = this.getRudderAxleAxisDirection().get().func_176730_m();
            Vector3d facingOffset = new Vector3d((double)directionFacing.func_177958_n(), (double)directionFacing.func_177956_o(), (double)directionFacing.func_177952_p());
            double axleLength = this.getRudderAxleLength().get().intValue();
            facingOffset.mul(axleLength / 2.0);
            AxisAngle4d rotation = new AxisAngle4d(Math.toRadians(this.rudderAngle), (double)directionAxle.func_177958_n(), (double)directionAxle.func_177956_o(), (double)directionAxle.func_177952_p());
            rotation.transform(facingOffset);
            return facingOffset;
        }
        return null;
    }

    public Vector3d calculateForceFromVelocity(PhysicsObject physicsObject) {
        if (this.getRudderAxleSchematic().isPresent()) {
            Vector3d directionFacing = this.getForcePosRelativeToAxleInShipSpace();
            Vector3d forcePosRelativeToShipCenter = this.getForcePositionInShipSpace();
            forcePosRelativeToShipCenter.sub(physicsObject.getShipTransform().getCenterCoord());
            physicsObject.getShipTransformationManager().getCurrentPhysicsTransform().transformDirection(forcePosRelativeToShipCenter, TransformType.SUBSPACE_TO_GLOBAL);
            Vector3d velocity = physicsObject.getPhysicsCalculations().getVelocityAtPoint((Vector3dc)forcePosRelativeToShipCenter);
            physicsObject.getShipTransformationManager().getCurrentPhysicsTransform().transformDirection(velocity, TransformType.GLOBAL_TO_SUBSPACE);
            Vec3i directionAxle = this.getRudderAxleAxisDirection().get().func_176730_m();
            Vector3d directionAxleVector = new Vector3d((double)directionAxle.func_177958_n(), (double)directionAxle.func_177956_o(), (double)directionAxle.func_177952_p());
            Vector3d surfaceNormal = directionAxleVector.cross((Vector3dc)directionFacing, new Vector3d());
            surfaceNormal.normalize();
            double dragMagnitude = surfaceNormal.dot((Vector3dc)velocity) * 10000.0;
            return surfaceNormal.mul(-dragMagnitude);
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rudderAngle = compound.func_74769_h("rudderAngle");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound toReturn = super.func_189515_b(compound);
        toReturn.func_74780_a("rudderAngle", this.rudderAngle);
        return toReturn;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        double currentRudderAngle = this.rudderAngle;
        super.onDataPacket(net, pkt);
        this.nextRudderAngle = pkt.func_148857_g().func_74769_h("rudderAngle");
        this.rudderAngle = currentRudderAngle;
    }

    @Override
    public Vector3dc getForceOutputUnoriented(double secondsToApply, PhysicsObject physicsObject) {
        return null;
    }

    @Override
    public Vector3dc getForceOutputNormal(double secondsToApply, PhysicsObject object) {
        return null;
    }

    @Override
    public double getThrustMagnitude(PhysicsObject physicsObject) {
        return 0.0;
    }

    public Optional<EnumFacing> getRudderAxleAxisDirection() {
        Optional<RudderAxleMultiblockSchematic> rudderAxleSchematicOptional = this.getRudderAxleSchematic();
        if (rudderAxleSchematicOptional.isPresent()) {
            return Optional.of(rudderAxleSchematicOptional.get().getAxleAxisDirection());
        }
        return Optional.empty();
    }

    public Optional<EnumFacing> getRudderAxleFacingDirection() {
        Optional<RudderAxleMultiblockSchematic> rudderAxleSchematicOptional = this.getRudderAxleSchematic();
        if (rudderAxleSchematicOptional.isPresent()) {
            return Optional.of(rudderAxleSchematicOptional.get().getAxleFacingDirection());
        }
        return Optional.empty();
    }

    public Optional<Integer> getRudderAxleLength() {
        Optional<RudderAxleMultiblockSchematic> rudderAxleSchematicOptional = this.getRudderAxleSchematic();
        if (rudderAxleSchematicOptional.isPresent()) {
            return Optional.of(rudderAxleSchematicOptional.get().getAxleLength());
        }
        return Optional.empty();
    }

    private Optional<RudderAxleMultiblockSchematic> getRudderAxleSchematic() {
        if (this.isPartOfAssembledMultiblock()) {
            return Optional.of(this.getMultiBlockSchematic());
        }
        return Optional.empty();
    }

    public double getRudderAngle() {
        return this.rudderAngle;
    }

    public void setRudderAngle(double forcedValue) {
        this.rudderAngle = forcedValue;
        VSNetwork.sendTileToAllNearby((TileEntity)this);
    }

    public double getRenderRudderAngle(double partialTicks) {
        return this.prevRudderAngle + (this.rudderAngle - this.prevRudderAngle) * partialTicks;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isPartOfAssembledMultiblock() && this.isMaster() && this.getRudderAxleAxisDirection().isPresent()) {
            BlockPos minPos = this.field_174879_c;
            EnumFacing axleAxis = this.getRudderAxleAxisDirection().get();
            EnumFacing axleFacing = this.getRudderAxleFacingDirection().get();
            Vec3i otherAxis = axleAxis.func_176730_m().func_177955_d(axleFacing.func_176730_m());
            int nexAxisX = axleAxis.func_176730_m().func_177958_n() + axleFacing.func_176730_m().func_177958_n();
            int nexAxisY = axleAxis.func_176730_m().func_177956_o() + axleFacing.func_176730_m().func_177956_o();
            int nexAxisZ = axleAxis.func_176730_m().func_177952_p() + axleFacing.func_176730_m().func_177952_p();
            int axleLength = this.getRudderAxleLength().get();
            int offsetX = nexAxisX * axleLength;
            int offsetY = nexAxisY * axleLength;
            int offsetZ = nexAxisZ * axleLength;
            BlockPos maxPos = minPos.func_177982_a(offsetX, offsetY, offsetZ);
            int otherAxisXExpanded = otherAxis.func_177958_n() * axleLength;
            int otherAxisYExpanded = otherAxis.func_177956_o() * axleLength;
            int otherAxisZExpanded = otherAxis.func_177952_p() * axleLength;
            return new AxisAlignedBB(minPos, maxPos).func_72314_b((double)otherAxisXExpanded, (double)otherAxisYExpanded, (double)otherAxisZExpanded).func_72314_b(0.5, 0.5, 0.5);
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public boolean attemptToAssembleMultiblock(World worldIn, BlockPos pos, EnumFacing facing) {
        List<IMultiblockSchematic> schematics = MultiblockRegistry.getSchematicsWithPrefix("multiblock_rudder_axle");
        for (IMultiblockSchematic schematic : schematics) {
            RudderAxleMultiblockSchematic rudderSchem = (RudderAxleMultiblockSchematic)schematic;
            if (facing.func_176740_k() == rudderSchem.getAxleAxisDirection().func_176740_k() || rudderSchem.getAxleFacingDirection() != facing || !schematic.attemptToCreateMultiblock(worldIn, pos)) continue;
            return true;
        }
        return false;
    }
}

