/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.valkyrienskies.addon.control.MultiblockRegistry;
import org.valkyrienskies.addon.control.block.multiblocks.BlockPosBlockPair;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.ITileEntityMultiblockPart;
import org.valkyrienskies.addon.control.nodenetwork.BasicNodeTileEntity;
import org.valkyrienskies.mod.common.network.VSNetwork;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public abstract class TileEntityMultiblockPart<E extends IMultiblockSchematic, F extends TileEntityMultiblockPart>
extends BasicNodeTileEntity
implements ITileEntityMultiblockPart<E, F> {
    private boolean isAssembled = false;
    private boolean isMaster = false;
    private BlockPos offsetPos = BlockPos.field_177992_a;
    private E multiblockSchematic = null;

    @Override
    public boolean isPartOfAssembledMultiblock() {
        return this.isAssembled;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    @Override
    public F getMaster() {
        TileEntity masterTile = ValkyrienUtils.getTileEntitySafe((World)this.func_145831_w(), (BlockPos)this.getMultiblockOrigin());
        if (masterTile instanceof ITileEntityMultiblockPart) {
            return (F)((TileEntityMultiblockPart)masterTile);
        }
        return null;
    }

    @Override
    public BlockPos getMultiblockOrigin() {
        return this.func_174877_v().func_177973_b((Vec3i)this.offsetPos);
    }

    @Override
    public BlockPos getRelativePos() {
        return this.offsetPos;
    }

    @Override
    public void disassembleMultiblock() {
        if (this.multiblockSchematic != null) {
            for (BlockPosBlockPair pair : this.multiblockSchematic.getStructureRelativeToCenter()) {
                BlockPos posToBreak = pair.getPos().func_177971_a((Vec3i)this.getMultiblockOrigin());
                TileEntity tileToBreak = this.func_145831_w().func_175625_s(posToBreak);
                if (!(tileToBreak instanceof ITileEntityMultiblockPart)) continue;
                ((ITileEntityMultiblockPart)tileToBreak).disassembleMultiblockLocal();
            }
        }
    }

    @Override
    public void disassembleMultiblockLocal() {
        this.isAssembled = false;
        this.isMaster = false;
        this.multiblockSchematic = null;
        VSNetwork.sendTileToAllNearby((TileEntity)this);
        this.func_70296_d();
    }

    @Override
    public void assembleMultiblock(E schematic, BlockPos relativePos) {
        this.isAssembled = true;
        this.isMaster = relativePos.equals((Object)BlockPos.field_177992_a);
        this.offsetPos = relativePos;
        this.multiblockSchematic = schematic;
        VSNetwork.sendTileToAllNearby((TileEntity)this);
        this.func_70296_d();
    }

    @Override
    public E getMultiBlockSchematic() {
        return this.multiblockSchematic;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound toReturn = super.func_189515_b(compound);
        toReturn.func_74757_a("isAssembled", this.isAssembled);
        toReturn.func_74757_a("isMaster", this.isMaster);
        toReturn.func_74768_a("offsetPosX", this.offsetPos.func_177958_n());
        toReturn.func_74768_a("offsetPosY", this.offsetPos.func_177956_o());
        toReturn.func_74768_a("offsetPosZ", this.offsetPos.func_177952_p());
        if (this.multiblockSchematic != null) {
            toReturn.func_74778_a("multiblockSchematicID", this.multiblockSchematic.getSchematicID());
        } else {
            toReturn.func_74778_a("multiblockSchematicID", "unknown");
        }
        return toReturn;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isAssembled = compound.func_74767_n("isAssembled");
        this.isMaster = compound.func_74767_n("isMaster");
        this.offsetPos = new BlockPos(compound.func_74762_e("offsetPosX"), compound.func_74762_e("offsetPosY"), compound.func_74762_e("offsetPosZ"));
        this.multiblockSchematic = MultiblockRegistry.getSchematicByID(compound.func_74779_i("multiblockSchematicID"));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isPartOfAssembledMultiblock()) {
            return this.getMultiBlockSchematic().getSchematicRenderBB(this.getMultiblockOrigin());
        }
        return super.getRenderBoundingBox();
    }
}

