/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.block.multiblocks.BlockPosBlockPair;
import org.valkyrienskies.addon.control.block.multiblocks.IMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityRudderPart;

public class RudderAxleMultiblockSchematic
implements IMultiblockSchematic {
    public static final int MIN_AXLE_LENGTH = 2;
    public static final int MAX_AXLE_LENGTH = 6;
    private final List<BlockPosBlockPair> structureRelativeToCenter = new ArrayList<BlockPosBlockPair>();
    private String schematicID = "unknown";
    private int axleLength = -1;
    private EnumFacing axleAxis = EnumFacing.UP;
    private EnumFacing axleFacing = EnumFacing.UP;

    @Override
    public void initializeMultiblockSchematic(String schematicID) {
        this.schematicID = schematicID;
    }

    @Override
    public List<BlockPosBlockPair> getStructureRelativeToCenter() {
        return this.structureRelativeToCenter;
    }

    @Override
    public String getSchematicPrefix() {
        return "multiblock_rudder_axle";
    }

    @Override
    public String getSchematicID() {
        return this.schematicID;
    }

    @Override
    public void applyMultiblockCreation(World world, BlockPos tilePos, BlockPos relativePos) {
        TileEntity tileEntity = world.func_175625_s(tilePos);
        if (!(tileEntity instanceof TileEntityRudderPart)) {
            throw new IllegalStateException();
        }
        TileEntityRudderPart enginePart = (TileEntityRudderPart)tileEntity;
        enginePart.assembleMultiblock(this, relativePos);
    }

    @Override
    public List<IMultiblockSchematic> generateAllVariants() {
        Block rudderAxleBlock = ValkyrienSkiesControl.INSTANCE.vsControlBlocks.rudderPart;
        ArrayList<IMultiblockSchematic> variants = new ArrayList<IMultiblockSchematic>();
        for (int length = 6; length >= 2; --length) {
            for (EnumFacing possibleAxleAxisDirection : EnumFacing.field_82609_l) {
                for (EnumFacing possibleAxleFacingDirection : EnumFacing.field_82609_l) {
                    if (possibleAxleAxisDirection.func_176740_k() == possibleAxleFacingDirection.func_176740_k()) continue;
                    BlockPos originPos = new BlockPos(0, 0, 0);
                    RudderAxleMultiblockSchematic schematicVariant = new RudderAxleMultiblockSchematic();
                    schematicVariant.initializeMultiblockSchematic(this.getSchematicPrefix() + "axle_axis_direction:" + possibleAxleAxisDirection.toString() + ":axle_facing:" + possibleAxleFacingDirection.toString() + ":length:" + length);
                    schematicVariant.axleAxis = possibleAxleAxisDirection;
                    schematicVariant.axleFacing = possibleAxleFacingDirection;
                    schematicVariant.axleLength = length;
                    for (int i = 0; i < length; ++i) {
                        schematicVariant.structureRelativeToCenter.add(new BlockPosBlockPair(BlockPos.field_177992_a.func_177967_a(possibleAxleAxisDirection, i), rudderAxleBlock));
                    }
                    variants.add(schematicVariant);
                }
            }
        }
        return variants;
    }

    public int getAxleLength() {
        return this.axleLength;
    }

    public EnumFacing getAxleAxisDirection() {
        return this.axleAxis;
    }

    public EnumFacing getAxleFacingDirection() {
        return this.axleFacing;
    }
}

