/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.multiblocks;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityRudderPart;
import org.valkyrienskies.addon.control.util.BaseBlock;
import org.valkyrienskies.mod.common.block.IBlockForceProvider;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;

public class BlockRudderPart
extends BaseBlock
implements ITileEntityProvider,
IBlockForceProvider {
    public BlockRudderPart() {
        super("rudder_part", Material.field_151575_d, 0.0f, true);
        this.func_149711_c(5.0f);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> itemInformation, ITooltipFlag advanced) {
        itemInformation.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.vs_control.rudder_part", (Object[])new Object[0]));
        itemInformation.add(TextFormatting.BLUE + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.vs_control.wrench_usage", (Object[])new Object[0]));
    }

    private static Optional<Double> getRudderRotationDegrees(World world, BlockPos pos) {
        return Optional.empty();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRudderPart();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityRudderPart) {
            ((TileEntityRudderPart)tile).disassembleMultiblock();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public Vector3dc getBlockForceInShipSpace(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        if (world.func_175625_s(pos) instanceof TileEntityRudderPart) {
            TileEntityRudderPart tileEntity = (TileEntityRudderPart)world.func_175625_s(pos);
            Vector3d forceBeforeTimeScale = tileEntity.calculateForceFromVelocity(physicsObject);
            if (forceBeforeTimeScale != null && forceBeforeTimeScale.lengthSquared() > 1.0) {
                return forceBeforeTimeScale.mul(secondsToApply);
            }
            return null;
        }
        return null;
    }

    public Vector3dc getCustomBlockForcePosition(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        if (world.func_175625_s(pos) instanceof TileEntityRudderPart) {
            TileEntityRudderPart tileEntity = (TileEntityRudderPart)world.func_175625_s(pos);
            return null;
        }
        return null;
    }

    public boolean shouldLocalForceBeRotated(World world, BlockPos pos, IBlockState state, double secondsToApply) {
        return true;
    }
}

