/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.engine;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.block.engine.BlockAirshipEngine;
import org.valkyrienskies.addon.control.tileentity.TileEntityPropellerEngine;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;

public abstract class BlockAirshipEngineLore
extends BlockAirshipEngine {
    private String[] lore;

    public BlockAirshipEngineLore(String name, Material mat, double enginePower, float hardness) {
        super(name, mat, enginePower, hardness);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> itemInformation, ITooltipFlag advanced) {
        Collections.addAll(itemInformation, this.lore);
    }

    public abstract String getEnginePowerTooltip();

    @Override
    public void setEnginePower(double power) {
        super.setEnginePower(power);
        this.lore = new String[]{"" + TextFormatting.GRAY + TextFormatting.ITALIC + TextFormatting.BOLD + "Force:", "  " + this.getEnginePowerTooltip() + " Newtons"};
    }

    public boolean shouldLocalForceBeRotated(World world, BlockPos pos, IBlockState state, double secondsToApply) {
        return true;
    }

    public Vector3dc getCustomBlockForcePosition(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        TileEntityPropellerEngine engineTile = (TileEntityPropellerEngine)physicsObject.getShipTile(pos);
        if (engineTile != null) {
            Vector3dc forceOutputNormal = engineTile.getForceOutputNormal(secondsToApply, physicsObject);
            return new Vector3d((double)pos.func_177958_n() + 0.5 - forceOutputNormal.x() * 0.75, (double)pos.func_177956_o() + 0.5 - forceOutputNormal.y() * 0.75, (double)pos.func_177952_p() + 0.5 - forceOutputNormal.z() * 0.75);
        }
        return null;
    }
}

