/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block.engine;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.addon.control.tileentity.TileEntityPropellerEngine;
import org.valkyrienskies.addon.control.util.BaseBlock;
import org.valkyrienskies.mod.common.block.IBlockForceProvider;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;

public abstract class BlockAirshipEngine
extends BaseBlock
implements IBlockForceProvider,
ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected double enginePower;

    public BlockAirshipEngine(String name, Material mat, double enginePower, float hardness) {
        super(name + "_engine", mat, 0.0f, true);
        this.setEnginePower(enginePower);
        this.func_149711_c(hardness);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        return i;
    }

    public Vector3dc getBlockForceInShipSpace(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        Vector3d acting = new Vector3d(0.0, 0.0, 0.0);
        if (!world.func_175640_z(pos)) {
            return acting;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityPropellerEngine) {
            ((TileEntityPropellerEngine)tileEntity).updateTicksSinceLastRecievedSignal();
            ((TileEntityPropellerEngine)tileEntity).setThrustMultiplierGoal(1.0);
            return ((TileEntityPropellerEngine)tileEntity).getForceOutputUnoriented(secondsToApply, physicsObject);
        }
        return acting;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public double getEnginePower() {
        return this.enginePower;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        IBlockState state = this.func_176203_a(meta);
        return new TileEntityPropellerEngine((Vector3dc)JOML.convertTo3d((Vec3i)((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d().func_176730_m()), true, this.getEnginePower());
    }

    public void setEnginePower(double power) {
        this.enginePower = power;
    }
}

