/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.block;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.gui.VS_Gui_Enum;
import org.valkyrienskies.addon.control.tileentity.TileEntityPhysicsInfuser;
import org.valkyrienskies.addon.control.util.BlockVSDirectional;
import org.valkyrienskies.mod.common.ships.block_relocation.BlockFinder;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockPhysicsInfuser
extends BlockVSDirectional
implements ITileEntityProvider {
    public static final PropertyBool INFUSER_LIGHT_ON = PropertyBool.func_177716_a((String)"infuser_light_on");
    private final BlockFinder.BlockFinderType blockFinderType;

    protected BlockPhysicsInfuser(String name, BlockFinder.BlockFinderType blockFinderType) {
        super(name, Material.field_151575_d, 0.0f, true);
        this.blockFinderType = blockFinderType;
    }

    public BlockPhysicsInfuser(String name) {
        this(name, BlockFinder.BlockFinderType.FIND_ALLOWED_BLOCKS);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumFacing = EnumFacing.func_82600_a((int)(meta & 7));
        if (enumFacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumFacing = EnumFacing.NORTH;
        }
        boolean lightOn = meta >> 3 == 1;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing).func_177226_a((IProperty)INFUSER_LIGHT_ON, (Comparable)Boolean.valueOf(lightOn));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int stateMeta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)INFUSER_LIGHT_ON)).booleanValue()) {
            stateMeta |= 8;
        }
        return stateMeta;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos dummyPos = this.getDummyStatePos(state, pos);
            worldIn.func_175656_a(dummyPos, ValkyrienSkiesControl.INSTANCE.vsControlBlocks.physicsInfuserDummy.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)this.getDummyStateFacing(state)));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IItemHandler handler;
        TileEntityPhysicsInfuser tileEntity = (TileEntityPhysicsInfuser)worldIn.func_175625_s(pos);
        if (tileEntity != null && !tileEntity.func_145837_r() && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        BlockPos dummyBlockPos = this.getDummyStatePos(state, pos);
        super.func_180663_b(worldIn, pos, state);
        if (worldIn.func_180495_p(dummyBlockPos).func_177230_c() == ValkyrienSkiesControl.INSTANCE.vsControlBlocks.physicsInfuserDummy) {
            worldIn.func_175698_g(dummyBlockPos);
        }
        worldIn.func_175713_t(pos);
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tooltip.vs_control.physics_infuser", (Object[])new Object[0]));
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing facingHorizontal;
        EnumFacing playerFacing = placer.func_174811_aO();
        if (!placer.func_70093_af()) {
            playerFacing = playerFacing.func_176734_d();
        }
        if (this.canPlaceBlockAtWithFacing(worldIn, pos, playerFacing)) {
            facingHorizontal = playerFacing;
        } else if (this.canPlaceBlockAtWithFacing(worldIn, pos, playerFacing.func_176746_e())) {
            facingHorizontal = playerFacing.func_176746_e();
        } else if (this.canPlaceBlockAtWithFacing(worldIn, pos, playerFacing.func_176735_f())) {
            facingHorizontal = playerFacing.func_176735_f();
        } else if (this.canPlaceBlockAtWithFacing(worldIn, pos, playerFacing.func_176734_d())) {
            facingHorizontal = playerFacing.func_176734_d();
        } else {
            throw new IllegalStateException("Cannot find valid state for placement for Physics Infuser!");
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facingHorizontal).func_177226_a((IProperty)INFUSER_LIGHT_ON, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)ValkyrienSkiesControl.INSTANCE, VS_Gui_Enum.PHYSICS_INFUSER.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (super.func_176196_c(worldIn, pos)) {
            for (EnumFacing horizontal : EnumFacing.field_176754_o) {
                if (!this.canPlaceBlockAtWithFacing(worldIn, pos, horizontal)) continue;
                return true;
            }
        }
        return false;
    }

    private BlockPos getDummyStatePos(IBlockState state, BlockPos pos) {
        EnumFacing dummyBlockFacing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e().func_176734_d();
        return pos.func_177972_a(dummyBlockFacing);
    }

    public EnumFacing getDummyStateFacing(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPhysicsInfuser();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)INFUSER_LIGHT_ON) != false ? 7 : 0;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, INFUSER_LIGHT_ON});
    }

    private boolean canPlaceBlockAtWithFacing(World world, BlockPos pos, EnumFacing facing) {
        BlockPos dummyStatePos = this.getDummyStatePos(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing), pos);
        return world.func_180495_p(dummyStatePos).func_177230_c().func_176200_f((IBlockAccess)world, dummyStatePos);
    }

    public BlockFinder.BlockFinderType getBlockFinderType() {
        return this.blockFinderType;
    }
}

