/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.addon.control.BlocksValkyrienSkiesControl;
import org.valkyrienskies.addon.control.MultiblockRegistry;
import org.valkyrienskies.addon.control.block.multiblocks.GiantPropellerMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.RudderAxleMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityGiantPropellerPart;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityRudderPart;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityValkyriumCompressorPart;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityValkyriumEnginePart;
import org.valkyrienskies.addon.control.block.multiblocks.ValkyriumCompressorMultiblockSchematic;
import org.valkyrienskies.addon.control.block.multiblocks.ValkyriumEngineMultiblockSchematic;
import org.valkyrienskies.addon.control.block.torque.TileEntityRotationAxle;
import org.valkyrienskies.addon.control.capability.ICapabilityLastRelay;
import org.valkyrienskies.addon.control.capability.ImplCapabilityLastRelay;
import org.valkyrienskies.addon.control.capability.StorageLastRelay;
import org.valkyrienskies.addon.control.config.VSControlConfig;
import org.valkyrienskies.addon.control.item.ItemPhysicsCore;
import org.valkyrienskies.addon.control.item.ItemRelayWire;
import org.valkyrienskies.addon.control.item.ItemVSWrench;
import org.valkyrienskies.addon.control.item.ItemVanishingWire;
import org.valkyrienskies.addon.control.network.VSGuiButtonHandler;
import org.valkyrienskies.addon.control.network.VSGuiButtonMessage;
import org.valkyrienskies.addon.control.proxy.CommonProxyControl;
import org.valkyrienskies.addon.control.tileentity.TileEntityGearbox;
import org.valkyrienskies.addon.control.tileentity.TileEntityGyroscopeDampener;
import org.valkyrienskies.addon.control.tileentity.TileEntityGyroscopeStabilizer;
import org.valkyrienskies.addon.control.tileentity.TileEntityLiftLever;
import org.valkyrienskies.addon.control.tileentity.TileEntityLiftValve;
import org.valkyrienskies.addon.control.tileentity.TileEntityNetworkDisplay;
import org.valkyrienskies.addon.control.tileentity.TileEntityNetworkRelay;
import org.valkyrienskies.addon.control.tileentity.TileEntityPhysicsInfuser;
import org.valkyrienskies.addon.control.tileentity.TileEntityPropellerEngine;
import org.valkyrienskies.addon.control.tileentity.TileEntityShipHelm;
import org.valkyrienskies.addon.control.tileentity.TileEntitySpeedTelegraph;
import org.valkyrienskies.mod.common.command.config.VSConfigCommandBase;

@Mod(modid="vs_control", dependencies="required-after:valkyrienskies;required-after:vs_world;")
@Mod.EventBusSubscriber(modid="vs_control")
public class ValkyrienSkiesControl {
    public static final List<Block> BLOCKS = new ArrayList<Block>();
    public static final List<Item> ITEMS = new ArrayList<Item>();
    public static final String MOD_ID = "vs_control";
    public static SimpleNetworkWrapper controlGuiNetwork;
    @Mod.Instance(value="vs_control")
    public static ValkyrienSkiesControl INSTANCE;
    @SidedProxy(clientSide="org.valkyrienskies.addon.control.proxy.ClientProxyControl", serverSide="org.valkyrienskies.addon.control.proxy.CommonProxyControl")
    private static CommonProxyControl proxy;
    @CapabilityInject(value=ICapabilityLastRelay.class)
    public static final Capability<ICapabilityLastRelay> lastRelayCapability;
    private final Logger log = LogManager.getLogger(ValkyrienSkiesControl.class);
    public BlocksValkyrienSkiesControl vsControlBlocks;
    public Item relayWire;
    public Item vanishingWire;
    public Item vsWrench;
    public Item physicsCore;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blockArray = BLOCKS.toArray(new Block[0]);
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
    }

    public void addBlocks() {
        ValkyrienSkiesControl.INSTANCE.vsControlBlocks = new BlocksValkyrienSkiesControl();
    }

    public void registerMultiblocks() {
        MultiblockRegistry.registerAllPossibleSchematicVariants(ValkyriumEngineMultiblockSchematic.class);
        MultiblockRegistry.registerAllPossibleSchematicVariants(ValkyriumCompressorMultiblockSchematic.class);
        MultiblockRegistry.registerAllPossibleSchematicVariants(RudderAxleMultiblockSchematic.class);
        MultiblockRegistry.registerAllPossibleSchematicVariants(GiantPropellerMultiblockSchematic.class);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ITEMS.toArray(new Item[0]));
    }

    public void addItems() {
        ValkyrienSkiesControl.INSTANCE.relayWire = new ItemRelayWire();
        ValkyrienSkiesControl.INSTANCE.vanishingWire = new ItemVanishingWire();
        ValkyrienSkiesControl.INSTANCE.vsWrench = new ItemVSWrench();
        ValkyrienSkiesControl.INSTANCE.physicsCore = new ItemPhysicsCore();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.log.debug("Initializing configuration.");
        this.runConfiguration();
        this.addItems();
        this.addBlocks();
        this.registerNetworks();
        proxy.preInit((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        ServerCommandManager manager = (ServerCommandManager)event.getServer().func_71187_D();
        manager.func_71560_a((ICommand)new VSConfigCommandBase("vscontrolconfig", VSControlConfig.class, new String[0]));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerMultiblocks();
        this.registerTileEntities();
        this.registerCapabilities();
        proxy.init((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit((FMLStateEvent)event);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityNetworkRelay.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_network_relay"));
        GameRegistry.registerTileEntity(TileEntityShipHelm.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_ship_helm"));
        GameRegistry.registerTileEntity(TileEntitySpeedTelegraph.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_speed_telegraph"));
        GameRegistry.registerTileEntity(TileEntityPropellerEngine.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_propeller_engine"));
        GameRegistry.registerTileEntity(TileEntityGyroscopeStabilizer.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_gyroscope_stabilizer"));
        GameRegistry.registerTileEntity(TileEntityLiftValve.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_lift_valve"));
        GameRegistry.registerTileEntity(TileEntityNetworkDisplay.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_network_display"));
        GameRegistry.registerTileEntity(TileEntityLiftLever.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_lift_lever"));
        GameRegistry.registerTileEntity(TileEntityGyroscopeDampener.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_gyroscope_dampener"));
        GameRegistry.registerTileEntity(TileEntityValkyriumEnginePart.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_valkyrium_engine_part"));
        GameRegistry.registerTileEntity(TileEntityGearbox.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_gearbox"));
        GameRegistry.registerTileEntity(TileEntityValkyriumCompressorPart.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_valkyrium_compressor_part"));
        GameRegistry.registerTileEntity(TileEntityRudderPart.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_rudder_part"));
        GameRegistry.registerTileEntity(TileEntityGiantPropellerPart.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_giant_propeller_part"));
        GameRegistry.registerTileEntity(TileEntityRotationAxle.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_rotation_axle"));
        GameRegistry.registerTileEntity(TileEntityPhysicsInfuser.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_physics_infuser"));
    }

    private void registerCapabilities() {
        CapabilityManager.INSTANCE.register(ICapabilityLastRelay.class, (Capability.IStorage)new StorageLastRelay(), ImplCapabilityLastRelay::new);
    }

    private static ResourceLocation getNameForRecipe(ItemStack output) {
        ResourceLocation baseLoc;
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(MOD_ID, output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation(MOD_ID, baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    private void registerNetworks() {
        controlGuiNetwork = NetworkRegistry.INSTANCE.newSimpleChannel("vs-control");
        controlGuiNetwork.registerMessage(VSGuiButtonHandler.class, VSGuiButtonMessage.class, 1, Side.SERVER);
    }

    private void runConfiguration() {
        VSControlConfig.sync();
    }

    static {
        lastRelayCapability = null;
    }
}

