/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.fixes;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.INetHandlerPlayServer;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.capability.VSCapabilityRegistry;
import org.valkyrienskies.mod.common.capability.entity_backup.ICapabilityEntityBackup;
import org.valkyrienskies.mod.common.ships.ShipData;
import valkyrienwarfare.api.TransformType;

public interface ITransformablePacket {
    default public boolean isPacketOnMainThread(INetHandlerPlayServer server, boolean callingFromSponge) {
        if (!ValkyrienSkiesMod.isSpongePresent() || callingFromSponge) {
            NetHandlerPlayServer serverHandler = (NetHandlerPlayServer)server;
            EntityPlayerMP player = serverHandler.field_147369_b;
            return player.func_71121_q().func_152345_ab();
        }
        return false;
    }

    default public void doPreProcessing(INetHandlerPlayServer server, boolean callingFromSponge) {
        if (this.isPacketOnMainThread(server, callingFromSponge)) {
            NetHandlerPlayServer serverHandler = (NetHandlerPlayServer)server;
            EntityPlayerMP player = serverHandler.field_147369_b;
            ShipData physicsObject = this.getPacketParent(serverHandler);
            if (physicsObject != null) {
                ICapabilityEntityBackup entityBackup = (ICapabilityEntityBackup)player.getCapability(VSCapabilityRegistry.VS_ENTITY_BACKUP, null);
                entityBackup.backupEntityPosition((Entity)player);
                physicsObject.getShipTransform().transform((Entity)player, TransformType.GLOBAL_TO_SUBSPACE, true);
            }
        }
    }

    default public void doPostProcessing(INetHandlerPlayServer server, boolean callingFromSponge) {
        if (this.isPacketOnMainThread(server, callingFromSponge)) {
            NetHandlerPlayServer serverHandler = (NetHandlerPlayServer)server;
            EntityPlayerMP player = serverHandler.field_147369_b;
            ICapabilityEntityBackup entityBackup = (ICapabilityEntityBackup)player.getCapability(VSCapabilityRegistry.VS_ENTITY_BACKUP, null);
            if (entityBackup.hasBackupPosition()) {
                entityBackup.restoreEntityToBackup((Entity)player);
            }
        }
    }

    public ShipData getPacketParent(NetHandlerPlayServer var1);
}

