/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.names;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.valkyrienskies.mod.common.util.names.NameGenerator;

public class NounListNameGenerator
implements NameGenerator {
    private static final int NOUN_LIST_LENGTH = 6801;
    private static final int DEFAULT_NOUNS_PER_NAME = 3;
    private final List<String> nouns = new ArrayList<String>(6801);
    private static final NounListNameGenerator instance = new NounListNameGenerator();

    private NounListNameGenerator() {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("assets/valkyrienskies/nounlist.txt"))));
        while ((line = reader.readLine()) != null) {
            this.nouns.add(line);
        }
    }

    @Override
    public String generateName() {
        return this.generateName(3);
    }

    public String generateName(int numberOfNouns) {
        return ThreadLocalRandom.current().ints(numberOfNouns, 0, this.nouns.size()).mapToObj(this.nouns::get).collect(Collectors.joining("-"));
    }

    public static NounListNameGenerator getInstance() {
        return instance;
    }
}

