/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.jackson.minecraft;

import java.io.IOException;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonGenerator;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonParser;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.DeserializationContext;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.JsonNode;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.SerializerProvider;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class BlockPosSerialization {

    public static class Serializer
    extends StdSerializer<BlockPos> {
        public Serializer() {
            this((Class<BlockPos>)null);
        }

        public Serializer(Class<BlockPos> vc) {
            super(vc);
        }

        @Override
        public void serialize(BlockPos value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeNumberField("x", value.func_177958_n());
            gen.writeNumberField("y", value.func_177956_o());
            gen.writeNumberField("z", value.func_177952_p());
            gen.writeEndObject();
        }
    }

    public static class Deserializer
    extends StdDeserializer<BlockPos> {
        public Deserializer() {
            this((Class<BlockPos>)null);
        }

        public Deserializer(Class<BlockPos> vc) {
            super(vc);
        }

        @Override
        public BlockPos deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            double x = node.get("x").doubleValue();
            double y = node.get("y").doubleValue();
            double z = node.get("z").doubleValue();
            return new BlockPos(x, y, z);
        }
    }
}

