/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.datastructures;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.NotImplementedException;
import org.valkyrienskies.mod.common.util.VSIterationUtils;

public interface IBlockPosSet
extends Set<BlockPos> {
    public boolean add(int var1, int var2, int var3) throws IllegalArgumentException;

    public boolean remove(int var1, int var2, int var3);

    public boolean contains(int var1, int var2, int var3);

    public boolean canStore(int var1, int var2, int var3);

    @Override
    public void clear();

    default public void forEach(@Nonnull VSIterationUtils.IntTernaryConsumer action) {
        this.forEach((? super T blockPos) -> action.accept(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
    }

    default public void forEachUnsafe(@Nonnull VSIterationUtils.IntTernaryConsumer action) {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    default public boolean add(@Nonnull BlockPos pos) throws IllegalArgumentException {
        return this.add(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    default public boolean remove(@Nonnull BlockPos pos) {
        return this.remove(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    default public boolean contains(@Nonnull BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    default public boolean canStore(@Nonnull BlockPos pos) {
        return this.canStore(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    default public boolean containsAll(@Nonnull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean addAll(@Nonnull Collection<? extends BlockPos> c) throws IllegalArgumentException {
        boolean modified = false;
        for (BlockPos blockPos : c) {
            modified |= this.add(blockPos);
        }
        return modified;
    }

    @Override
    default public boolean removeAll(@Nonnull Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    default public boolean retainAll(@Nonnull Collection<?> c) {
        boolean modified = false;
        for (BlockPos pos : this) {
            if (c.contains(pos)) continue;
            this.remove(pos);
            modified = true;
        }
        return modified;
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public boolean remove(@Nonnull Object o) throws IllegalArgumentException {
        if (o instanceof BlockPos) {
            return this.remove((BlockPos)o);
        }
        throw new IllegalArgumentException("Object " + o + " is not a BlockPos!");
    }

    @Override
    default public boolean contains(@Nonnull Object o) {
        if (o instanceof BlockPos) {
            return this.contains((BlockPos)o);
        }
        return false;
    }

    @Override
    @Nonnull
    default public Object[] toArray() {
        Object[] arr = new BlockPos[this.size()];
        Iterator iter = this.iterator();
        for (int i = 0; i < this.size(); ++i) {
            arr[i] = (BlockPos)iter.next();
        }
        return arr;
    }

    @Override
    @Nonnull
    default public <T> T[] toArray(@Nonnull T[] a) {
        return this.toArray();
    }
}

