/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.cqengine;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.support.Factory;
import com.googlecode.cqengine.index.unique.UniqueIndex;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableIndex;

public class UpdatableUniqueIndex<A, O>
extends UniqueIndex<A, O>
implements UpdatableIndex<O> {
    ConcurrentMap<O, A> reverseMap;

    protected UpdatableUniqueIndex(Factory<ConcurrentMap<A, O>> indexMapFactory, Factory<ConcurrentMap<O, A>> reverseMapFactory, Attribute<O, A> attribute) {
        super(indexMapFactory, attribute);
        this.reverseMap = reverseMapFactory.create();
    }

    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        for (Object object : objectSet) {
            Iterable attributeValues = this.getAttribute().getValues(object, queryOptions);
            for (Object attributeValue : attributeValues) {
                this.reverseMap.put(object, attributeValue);
            }
        }
        return super.addAll(objectSet, queryOptions);
    }

    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        for (Object object : objectSet) {
            this.reverseMap.remove(object);
        }
        return super.removeAll(objectSet, queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            for (Object object : objectSet) {
                Object oldAttributeValue = this.reverseMap.get(object);
                if (oldAttributeValue == null) {
                    super.addAll(objectSet, queryOptions);
                    continue;
                }
                Iterable attributeValues = this.getAttribute().getValues(object, queryOptions);
                for (Object newAttributeValue : attributeValues) {
                    this.indexMap.remove(oldAttributeValue);
                    Object existingValue = this.indexMap.put(newAttributeValue, object);
                    if (existingValue == null || existingValue.equals(object)) continue;
                    throw new UniqueIndex.UniqueConstraintViolatedException("The application has attempted to add a duplicate object to the UniqueIndex on attribute '" + this.attribute.getAttributeName() + "', potentially causing inconsistencies between indexes. UniqueIndex should not be used with attributes which do not uniquely identify objects. Problematic attribute value: '" + newAttributeValue + "', problematic duplicate object: " + object);
                }
            }
        }
        finally {
            objectSet.close();
        }
    }

    public static <A, O> UpdatableUniqueIndex<A, O> onAttribute(Attribute<O, A> attribute) {
        return UpdatableUniqueIndex.onAttribute(new UniqueIndex.DefaultIndexMapFactory(), attribute);
    }

    public static <A, O> UpdatableUniqueIndex<A, O> onAttribute(Factory<ConcurrentMap<A, O>> indexMapFactory, Attribute<O, A> attribute) {
        return new UpdatableUniqueIndex<A, O>(indexMapFactory, new DefaultReverseMapFactory(), attribute);
    }

    public static <A, O> UpdatableUniqueIndex<A, O> onAttribute(Factory<ConcurrentMap<A, O>> indexMapFactory, Factory<ConcurrentMap<O, A>> reverseMapFactory, Attribute<O, A> attribute) {
        return new UpdatableUniqueIndex<A, O>(indexMapFactory, reverseMapFactory, attribute);
    }

    public static class DefaultReverseMapFactory<O, A>
    implements Factory<ConcurrentMap<O, A>> {
        @Override
        public ConcurrentMap<O, A> create() {
            return new ConcurrentHashMap();
        }
    }
}

