/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util.cqengine;

import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.index.support.CloseableRequestResources;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.onheap.OnHeapPersistence;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.persistence.support.ObjectStoreAsSet;
import com.googlecode.cqengine.persistence.support.PersistenceFlags;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.FlagsEnabled;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.closeable.CloseableResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableCollectionQueryEngine;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableIndex;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableQueryEngine;

public class ConcurrentUpdatableIndexedCollection<O>
implements IndexedCollection<O> {
    protected final Persistence<O, ?> persistence;
    protected final ObjectStore<O> objectStore;
    protected final UpdatableQueryEngine<O> indexEngine;
    protected final Set<Consumer<Collection<O>>> addListeners = new HashSet<Consumer<Collection<O>>>();
    protected final Set<Consumer<Collection<O>>> removeListeners = new HashSet<Consumer<Collection<O>>>();
    protected final Set<BiConsumer<Iterable<O>, Iterable<O>>> updateListeners = new HashSet<BiConsumer<Iterable<O>, Iterable<O>>>();

    public void registerAddListener(Consumer<Collection<O>> addListener) {
        this.addListeners.add(addListener);
    }

    public void registerRemoveListener(Consumer<Collection<O>> addListener) {
        this.removeListeners.add(addListener);
    }

    public void registerUpdateListener(BiConsumer<Iterable<O>, Iterable<O>> updateListener) {
        this.updateListeners.add(updateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjectIndices(Collection<? extends O> c, Attribute<O, ?> attribute) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Collection<? extends O> objects = c;
            this.objectStore.addAll(objects, queryOptions);
            this.indexEngine.updateAll(ObjectSet.fromCollection(objects), attribute, queryOptions);
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    public void updateObjectIndices(O object, Attribute<O, ?> attribute) {
        this.updateObjectIndices((O)Collections.singleton(object), attribute);
    }

    public ConcurrentUpdatableIndexedCollection() {
        this(OnHeapPersistence.withoutPrimaryKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentUpdatableIndexedCollection(Persistence<O, ? extends Comparable> persistence) {
        this.persistence = persistence;
        this.objectStore = persistence.createObjectStore();
        UpdatableCollectionQueryEngine<O> queryEngine = new UpdatableCollectionQueryEngine<O>();
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            queryEngine.init(this.objectStore, queryOptions);
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
        this.indexEngine = queryEngine;
    }

    @Override
    public Persistence<O, ?> getPersistence() {
        return this.persistence;
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query) {
        return this.retrieve(query, null);
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        final QueryOptions finalQueryOptions = this.openRequestScopeResourcesIfNecessary(queryOptions);
        ConcurrentUpdatableIndexedCollection.flagAsReadRequest(finalQueryOptions);
        ResultSet<O> results = this.indexEngine.retrieve(query, finalQueryOptions);
        return new CloseableResultSet<O>(results, query, finalQueryOptions){

            @Override
            public void close() {
                super.close();
                ConcurrentUpdatableIndexedCollection.this.closeRequestScopeResourcesIfNecessary(finalQueryOptions);
            }
        };
    }

    @Override
    public boolean update(Iterable<O> objectsToRemove, Iterable<O> objectsToAdd) {
        return this.update(objectsToRemove, objectsToAdd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Iterable<O> objectsToRemove, Iterable<O> objectsToAdd, QueryOptions queryOptions) {
        queryOptions = this.openRequestScopeResourcesIfNecessary(queryOptions);
        try {
            boolean modified = this.doRemoveAll(objectsToRemove, queryOptions);
            boolean bl = this.doAddAll(objectsToAdd, queryOptions) || modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public void addIndex(Index<O> index) {
        this.addIndex(index, null);
    }

    @Override
    public void addIndex(Index<O> index, QueryOptions queryOptions) {
        if (!(index instanceof UpdatableIndex)) {
            throw new IllegalArgumentException("Must be updatable index");
        }
        queryOptions = this.openRequestScopeResourcesIfNecessary(queryOptions);
        try {
            this.indexEngine.addIndex(index, queryOptions);
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public void removeIndex(Index<O> index) {
        this.removeIndex(index, null);
    }

    @Override
    public void removeIndex(Index<O> index, QueryOptions queryOptions) {
        queryOptions = this.openRequestScopeResourcesIfNecessary(queryOptions);
        try {
            this.indexEngine.removeIndex(index, queryOptions);
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public Iterable<Index<O>> getIndexes() {
        return this.indexEngine.getIndexes();
    }

    @Override
    public int size() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            int n = this.objectStore.size(queryOptions);
            return n;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public boolean isEmpty() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            boolean bl = this.objectStore.isEmpty(queryOptions);
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            boolean bl = this.objectStore.contains(o, queryOptions);
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public Object[] toArray() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Object[] objectArray = this.getObjectStoreAsSet(queryOptions).toArray();
            return objectArray;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            T[] TArray = this.getObjectStoreAsSet(queryOptions).toArray(a);
            return TArray;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            boolean bl = this.objectStore.containsAll(c, queryOptions);
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public CloseableIterator<O> iterator() {
        return new CloseableIterator<O>(){
            final QueryOptions queryOptions;
            private final CloseableIterator<O> collectionIterator;
            boolean autoClosed;
            private O currentObject;
            {
                this.queryOptions = ConcurrentUpdatableIndexedCollection.this.openRequestScopeResourcesIfNecessary(null);
                this.collectionIterator = ConcurrentUpdatableIndexedCollection.this.objectStore.iterator(this.queryOptions);
                this.autoClosed = false;
                this.currentObject = null;
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = this.collectionIterator.hasNext();
                if (!hasNext) {
                    this.close();
                    this.autoClosed = true;
                }
                return hasNext;
            }

            @Override
            public O next() {
                Object next = this.collectionIterator.next();
                this.currentObject = next;
                return next;
            }

            @Override
            public void remove() {
                if (this.currentObject == null) {
                    throw new IllegalStateException();
                }
                if (this.autoClosed) {
                    ConcurrentUpdatableIndexedCollection.this.remove(this.currentObject);
                } else {
                    ConcurrentUpdatableIndexedCollection.this.doRemoveAll(Collections.singleton(this.currentObject), this.queryOptions);
                }
                this.currentObject = null;
            }

            @Override
            public void close() {
                CloseableRequestResources.closeQuietly(this.collectionIterator);
                ConcurrentUpdatableIndexedCollection.this.closeRequestScopeResourcesIfNecessary(this.queryOptions);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(O o) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Set oSet = Collections.singleton(o);
            boolean modified = this.objectStore.add(o, queryOptions);
            this.indexEngine.addAll(ObjectSet.fromCollection(oSet), queryOptions);
            if (modified) {
                this.addListeners.forEach(consumer -> consumer.accept(oSet));
                this.updateListeners.forEach(consumer -> consumer.accept(Collections.emptyList(), oSet));
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Object o = object;
            Set<Object> oSet = Collections.singleton(o);
            boolean modified = this.objectStore.remove(o, queryOptions);
            this.indexEngine.removeAll(ObjectSet.fromCollection(oSet), queryOptions);
            if (modified) {
                this.removeListeners.forEach(consumer -> consumer.accept(oSet));
                this.updateListeners.forEach(consumer -> consumer.accept(oSet, Collections.emptyList()));
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public boolean addAll(Collection<? extends O> c) {
        return this.addAll(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<? extends O> c, boolean silent) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Collection objects = c;
            boolean modified = this.objectStore.addAll(objects, queryOptions);
            this.indexEngine.addAll(ObjectSet.fromCollection(objects), queryOptions);
            if (!silent && modified) {
                this.addListeners.forEach(consumer -> consumer.accept(objects));
                this.updateListeners.forEach(consumer -> consumer.accept(Collections.emptyList(), objects));
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeAll(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<?> c, boolean silent) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            Collection<?> objects = c;
            boolean modified = this.objectStore.removeAll(objects, queryOptions);
            this.indexEngine.removeAll(ObjectSet.fromCollection(objects), queryOptions);
            if (!silent && modified) {
                this.removeListeners.forEach(consumer -> consumer.accept(objects));
                this.updateListeners.forEach(consumer -> consumer.accept(objects, Collections.emptyList()));
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        CloseableIterator<O> iterator = null;
        try {
            boolean modified = false;
            iterator = this.objectStore.iterator(queryOptions);
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (c.contains(next)) continue;
                this.doRemoveAll(Collections.singleton(next), queryOptions);
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            CloseableRequestResources.closeQuietly(iterator);
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public void clear() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            this.objectStore.clear(queryOptions);
            this.indexEngine.clear(queryOptions);
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    protected boolean doAddAll(Iterable<O> objects, QueryOptions queryOptions) {
        if (objects instanceof Collection) {
            Collection c = (Collection)objects;
            boolean modified = this.objectStore.addAll(c, queryOptions);
            this.indexEngine.addAll(ObjectSet.fromCollection(c), queryOptions);
            return modified;
        }
        boolean modified = false;
        for (O object : objects) {
            boolean added = this.objectStore.add(object, queryOptions);
            this.indexEngine.addAll(ObjectSet.fromCollection(Collections.singleton(object)), queryOptions);
            modified = added || modified;
        }
        return modified;
    }

    protected boolean doRemoveAll(Iterable<O> objects, QueryOptions queryOptions) {
        if (objects instanceof Collection) {
            Collection c = (Collection)objects;
            boolean modified = this.objectStore.removeAll(c, queryOptions);
            this.indexEngine.removeAll(ObjectSet.fromCollection(c), queryOptions);
            return modified;
        }
        boolean modified = false;
        for (O object : objects) {
            boolean removed = this.objectStore.remove(object, queryOptions);
            this.indexEngine.removeAll(ObjectSet.fromCollection(Collections.singleton(object)), queryOptions);
            modified = removed || modified;
        }
        return modified;
    }

    protected QueryOptions openRequestScopeResourcesIfNecessary(QueryOptions queryOptions) {
        if (queryOptions == null) {
            queryOptions = new QueryOptions();
        }
        if (!(this.persistence instanceof OnHeapPersistence)) {
            this.persistence.openRequestScopeResources(queryOptions);
        }
        queryOptions.put(Persistence.class, this.persistence);
        return queryOptions;
    }

    protected void closeRequestScopeResourcesIfNecessary(QueryOptions queryOptions) {
        if (!(this.persistence instanceof OnHeapPersistence)) {
            this.persistence.closeRequestScopeResources(queryOptions);
        }
    }

    protected ObjectStoreAsSet<O> getObjectStoreAsSet(QueryOptions queryOptions) {
        return new ObjectStoreAsSet<O>(this.objectStore, queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            if (this == o) {
                boolean bl = true;
                return bl;
            }
            if (!(o instanceof Set)) {
                boolean bl = false;
                return bl;
            }
            Set that = (Set)o;
            if (!this.getObjectStoreAsSet(queryOptions).equals(that)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    @Override
    public int hashCode() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            int n = this.getObjectStoreAsSet(queryOptions).hashCode();
            return n;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    public String toString() {
        QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
        try {
            String string = this.getObjectStoreAsSet(queryOptions).toString();
            return string;
        }
        finally {
            this.closeRequestScopeResourcesIfNecessary(queryOptions);
        }
    }

    protected static void flagAsReadRequest(QueryOptions queryOptions) {
        FlagsEnabled.forQueryOptions(queryOptions).add(PersistenceFlags.READ_REQUEST);
    }
}

