/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.block.BlockBoatChair;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import org.valkyrienskies.mod.common.piloting.ControllerInputType;
import org.valkyrienskies.mod.common.piloting.PilotControlsMessage;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.tileentity.TileEntityPilotableImpl;
import valkyrienwarfare.api.TransformType;

public class TileEntityBoatChair
extends TileEntityPilotableImpl {
    private static final double MAX_LINEAR_VELOCITY = 12.0;
    private static final double MAX_ANGULAR_VELOCITY = 1.5707963267948966;
    private static final double LINEAR_EMA_FILTER_CONSTANT = 2.0;
    private static final double ANGULAR_EMA_FILTER_CONSTANT = 2.0;
    private static final double STABILIZATION_TORQUE_CONSTANT = 7.5;
    private Vector3dc targetLinearVelocity = new Vector3d();
    private Vector3dc targetAngularVelocity = new Vector3d();

    @Override
    public ControllerInputType getControlInputType() {
        return ControllerInputType.CaptainsChair;
    }

    @Override
    public void processControlMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        double pilotYaw = ((BlockBoatChair)state.func_177230_c()).getChairYaw(state);
        Vector3d newTargetLinearVelocity = new Vector3d();
        if (message.airshipForward_KeyDown) {
            newTargetLinearVelocity.x += 12.0;
        }
        if (message.airshipBackward_KeyDown) {
            newTargetLinearVelocity.x -= 12.0;
        }
        if (message.airshipSprinting) {
            newTargetLinearVelocity.mul(2.0);
        }
        newTargetLinearVelocity.rotateAxis(Math.toRadians(pilotYaw), 0.0, 1.0, 0.0);
        Vector3d newTargetAngularVelocity = new Vector3d();
        if (message.airshipLeft_KeyDown) {
            newTargetAngularVelocity.y += 1.5707963267948966;
        }
        if (message.airshipRight_KeyDown) {
            newTargetAngularVelocity.y -= 1.5707963267948966;
        }
        this.targetLinearVelocity = newTargetLinearVelocity;
        this.targetAngularVelocity = newTargetAngularVelocity;
    }

    @Nullable
    public Vector3dc getBlockForceInShipSpace(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        if (this.getPilotEntity() == null) {
            return null;
        }
        ShipTransform shipTransform = physicsObject.getShipTransformationManager().getCurrentPhysicsTransform();
        Vector3d idealLinearVelocity = shipTransform.transformDirectionNew(new Vector3d(this.targetLinearVelocity), TransformType.SUBSPACE_TO_GLOBAL);
        Vector3d currentLinearVelocity = physicsObject.getPhysicsCalculations().getLinearVelocity();
        Vector3d velocityDifference = idealLinearVelocity.sub(currentLinearVelocity, new Vector3d());
        Vector3d resultingBlockForce = new Vector3d(velocityDifference);
        resultingBlockForce.mul(physicsObject.getInertiaData().getGameTickMass());
        resultingBlockForce.mul(secondsToApply);
        resultingBlockForce.mul(2.0);
        resultingBlockForce.y = 0.0;
        return resultingBlockForce;
    }

    @Nullable
    public Vector3dc getTorqueInGlobal(PhysicsCalculations physicsCalculations) {
        if (this.getPilotEntity() == null) {
            return null;
        }
        PhysicsObject physicsObject = physicsCalculations.getParent();
        ShipTransform shipTransform = physicsObject.getShipTransformationManager().getCurrentPhysicsTransform();
        Vector3d idealAngularVelocity = shipTransform.transformDirectionNew(new Vector3d(this.targetAngularVelocity), TransformType.SUBSPACE_TO_GLOBAL);
        Vector3d currentAngularVelocity = physicsCalculations.getAngularVelocity();
        Vector3d velocityDifference = idealAngularVelocity.sub(currentAngularVelocity, new Vector3d());
        Vector3d resultingTorque = physicsCalculations.getPhysMOITensor().transform(velocityDifference, new Vector3d());
        resultingTorque.mul(physicsCalculations.getPhysicsTimeDeltaPerPhysTick());
        resultingTorque.mul(2.0);
        resultingTorque.x = 0.0;
        resultingTorque.z = 0.0;
        Vector3d shipUp = shipTransform.transformDirectionNew(new Vector3d(0.0, 1.0, 0.0), TransformType.SUBSPACE_TO_GLOBAL);
        Vector3d idealUp = new Vector3d(0.0, 1.0, 0.0);
        double angleBetween = shipUp.angle(idealUp);
        if (angleBetween > 0.01) {
            Vector3d stabilizationRotationAxisNormalized = shipUp.cross(idealUp, new Vector3d()).normalize();
            Vector3d stabilizationTorque = physicsCalculations.getPhysMOITensor().transform(stabilizationRotationAxisNormalized.mul(angleBetween, new Vector3d()));
            stabilizationTorque.mul(physicsCalculations.getPhysicsTimeDeltaPerPhysTick());
            stabilizationTorque.mul(7.5);
            resultingTorque.add(stabilizationTorque);
        }
        return resultingTorque;
    }

    @Override
    public void onStopTileUsage() {
        this.targetLinearVelocity = new Vector3d();
        this.targetAngularVelocity = new Vector3d();
    }
}

