/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.ship_world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.network.ShipIndexDataMessage;
import org.valkyrienskies.mod.common.ships.QueryableShipData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.ships.ship_world.WorldServerShipManager;

class WorldShipLoadingController {
    private final WorldServerShipManager shipManager;
    private Map<ShipData, Set<EntityPlayerMP>> shipToWatchingPlayers;

    WorldShipLoadingController(WorldServerShipManager shipManager) {
        this.shipManager = shipManager;
        this.shipToWatchingPlayers = new HashMap<ShipData, Set<EntityPlayerMP>>();
    }

    void determineLoadAndUnload() {
        for (ShipData data : QueryableShipData.get((World)this.shipManager.getWorld())) {
            ShipTransform transform = data.getShipTransform();
            Vec3d shipPos = transform.getShipPositionVec3d();
            if (this.shipManager.getPhysObjectFromUUID(data.getUuid()) == null) {
                if (WorldShipLoadingController.existsPlayerWithinDistanceXZ((World)this.shipManager.getWorld(), shipPos, VSConfig.SHIP_LOADING_SETTINGS.loadDistance)) {
                    this.shipManager.queueShipLoad(data.getUuid());
                    continue;
                }
                if (!VSConfig.SHIP_LOADING_SETTINGS.permanentlyLoaded && !WorldShipLoadingController.existsPlayerWithinDistanceXZ((World)this.shipManager.getWorld(), shipPos, VSConfig.SHIP_LOADING_SETTINGS.loadBackgroundDistance)) continue;
                this.shipManager.queueShipLoadBackground(data.getUuid());
                continue;
            }
            if (VSConfig.SHIP_LOADING_SETTINGS.permanentlyLoaded || WorldShipLoadingController.existsPlayerWithinDistanceXZ((World)this.shipManager.getWorld(), shipPos, VSConfig.SHIP_LOADING_SETTINGS.unloadDistance)) continue;
            this.shipManager.queueShipUnload(data.getUuid());
        }
    }

    void sendUpdatesToPlayers() {
        Map<ShipData, Set<EntityPlayerMP>> newWatching = this.updateWatchingPlayers();
        this.sendUpdatesPackets(this.shipToWatchingPlayers, newWatching);
        this.shipToWatchingPlayers = newWatching;
        for (PhysicsObject ship : this.shipManager.getAllLoadedPhysObj()) {
            ship.getWatchingPlayers().clear();
            ship.getWatchingPlayers().addAll((Collection<EntityPlayerMP>)this.shipToWatchingPlayers.get(ship.getShipData()));
        }
    }

    private Map<ShipData, Set<EntityPlayerMP>> updateWatchingPlayers() {
        HashMap<ShipData, Set<EntityPlayerMP>> newWatching = new HashMap<ShipData, Set<EntityPlayerMP>>();
        for (PhysicsObject ship : this.shipManager.getAllLoadedPhysObj()) {
            ShipData shipData = ship.getShipData();
            if (this.shipToWatchingPlayers.containsKey(shipData)) {
                Set<EntityPlayerMP> oldWatchingPlayers = this.shipToWatchingPlayers.get(shipData);
                HashSet<EntityPlayerMP> newWatchingPlayers = new HashSet<EntityPlayerMP>();
                for (EntityPlayer player : this.shipManager.getWorld().field_73010_i) {
                    if (!oldWatchingPlayers.contains(player)) continue;
                    newWatchingPlayers.add((EntityPlayerMP)player);
                }
                newWatching.put(shipData, newWatchingPlayers);
                continue;
            }
            newWatching.put(shipData, new HashSet());
        }
        for (PhysicsObject ship : this.shipManager.getAllLoadedPhysObj()) {
            Vec3d shipPos = ship.getShipTransform().getShipPositionVec3d();
            ((Set)newWatching.get(ship.getShipData())).removeIf(watcher -> !WorldShipLoadingController.isPlayerWithinDistanceXZ((EntityPlayer)watcher, shipPos, VSConfig.SHIP_LOADING_SETTINGS.unwatchDistance));
            for (EntityPlayer player : this.shipManager.getWorld().field_73010_i) {
                if (!WorldShipLoadingController.isPlayerWithinDistanceXZ(player, shipPos, VSConfig.SHIP_LOADING_SETTINGS.watchDistance)) continue;
                ((Set)newWatching.get(ship.getShipData())).add((EntityPlayerMP)player);
            }
        }
        return newWatching;
    }

    private void sendUpdatesPackets(Map<ShipData, Set<EntityPlayerMP>> oldWatching, Map<ShipData, Set<EntityPlayerMP>> newWatching) {
        HashMap<EntityPlayerMP, List> updatesMap = new HashMap<EntityPlayerMP, List>();
        this.shipManager.getWorld().field_73010_i.forEach(player -> {
            List cfr_ignored_0 = updatesMap.put((EntityPlayerMP)player, new ArrayList());
        });
        for (PhysicsObject ship : this.shipManager.getAllLoadedPhysObj()) {
            ShipData shipData = ship.getShipData();
            Set<EntityPlayerMP> currentWatchers = newWatching.get(shipData);
            currentWatchers.forEach(player -> ((List)updatesMap.get(player)).add(shipData));
        }
        HashMap<EntityPlayerMP, ShipIndexDataMessage> playerPacketMap = new HashMap<EntityPlayerMP, ShipIndexDataMessage>();
        updatesMap.forEach((player, updates) -> {
            ShipIndexDataMessage indexDataMessage = new ShipIndexDataMessage();
            indexDataMessage.setDimensionID(this.shipManager.getWorld().field_73011_w.getDimension());
            if (!updates.isEmpty()) {
                indexDataMessage.addData((Collection<ShipData>)updates);
            }
            playerPacketMap.put((EntityPlayerMP)player, indexDataMessage);
        });
        for (PhysicsObject ship : this.shipManager.getAllLoadedPhysObj()) {
            ShipData shipData = ship.getShipData();
            HashSet newWatchers = new HashSet(newWatching.get(shipData));
            if (oldWatching.containsKey(shipData)) {
                newWatchers.removeAll((Collection)oldWatching.get(shipData));
            }
            if (newWatchers.isEmpty()) continue;
            for (Chunk chunk : ship.getClaimedChunkCache()) {
                SPacketChunkData data = new SPacketChunkData(chunk, 65535);
                for (EntityPlayerMP player2 : newWatchers) {
                    player2.field_71135_a.func_147359_a((Packet)data);
                    this.shipManager.getWorld().func_73039_n().func_85172_a(player2, chunk);
                }
            }
            newWatchers.forEach(player -> ((ShipIndexDataMessage)playerPacketMap.get(player)).addLoadUUID(shipData.getUuid()));
        }
        for (ShipData shipData : oldWatching.keySet()) {
            HashSet removedWatchers = new HashSet(oldWatching.get(shipData));
            if (newWatching.containsKey(shipData)) {
                removedWatchers.removeAll((Collection)newWatching.get(shipData));
            }
            for (EntityPlayerMP player3 : removedWatchers) {
                if (!playerPacketMap.containsKey(player3)) {
                    playerPacketMap.put(player3, new ShipIndexDataMessage());
                    ((ShipIndexDataMessage)playerPacketMap.get(player3)).setDimensionID(this.shipManager.getWorld().field_73011_w.getDimension());
                }
                ((ShipIndexDataMessage)playerPacketMap.get(player3)).addUnloadUUID(shipData.getUuid());
            }
        }
        playerPacketMap.forEach((player, packet) -> {
            if (!player.func_193105_t()) {
                ValkyrienSkiesMod.physWrapperNetwork.sendTo((IMessage)packet, player);
            }
        });
    }

    private static boolean isPlayerWithinDistanceXZ(EntityPlayer player, Vec3d pos, double distance) {
        double xDif = player.field_70165_t - pos.field_72450_a;
        double zDif = player.field_70161_v - pos.field_72449_c;
        return xDif * xDif + zDif * zDif < distance * distance;
    }

    private static boolean existsPlayerWithinDistanceXZ(World world, Vec3d pos, double distance) {
        for (EntityPlayer player : world.field_73010_i) {
            if (!WorldShipLoadingController.isPlayerWithinDistanceXZ(player, pos, distance)) continue;
            return true;
        }
        return false;
    }
}

