/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.entity_interaction;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.entity.EntityShipMovementData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityShipMountData;
import org.valkyrienskies.mod.common.ships.entity_interaction.IDraggable;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.util.VSMath;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

public class EntityDraggable {
    public static void tickAddedVelocityForWorld(World world) {
        try {
            for (int i = 0; i < world.field_72996_f.size(); ++i) {
                Entity e = (Entity)world.field_72996_f.get(i);
                if (e.field_70128_L) continue;
                EntityDraggable.addEntityVelocityFromShipBelow(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addEntityVelocityFromShipBelow(Entity entity) {
        IDraggable draggable = EntityDraggable.getDraggableFromEntity(entity);
        EntityShipMountData mountData = ValkyrienUtils.getMountedShipAndPos(entity);
        EntityShipMovementData oldEntityShipMovementData = draggable.getEntityShipMovementData();
        ShipData lastShipTouchedPlayer = oldEntityShipMovementData.getLastTouchedShip();
        int oldTicksSinceTouchedShip = oldEntityShipMovementData.getTicksSinceTouchedShip();
        Vector3dc oldVelocityAdded = oldEntityShipMovementData.getAddedLinearVelocity();
        double oldYawVelocityAdded = oldEntityShipMovementData.getAddedYawVelocity();
        if (lastShipTouchedPlayer == null || oldTicksSinceTouchedShip >= VSConfig.ticksToStickToShip) {
            if (entity.field_70122_E) {
                draggable.setEntityShipMovementData(oldEntityShipMovementData.withAddedLinearVelocity(new Vector3d()).withAddedYawVelocity(0.0));
            } else if (entity instanceof EntityPlayer) {
                double newYawVelocityAdded;
                Vector3d newVelocityAdded;
                EntityPlayer player = (EntityPlayer)entity;
                if (player.func_184812_l_() && player.field_71075_bZ.field_75100_b) {
                    newVelocityAdded = oldVelocityAdded.mul(0.95, new Vector3d());
                    newYawVelocityAdded = oldYawVelocityAdded * 0.95 * 0.95;
                    EntityShipMovementData newMovementData = oldEntityShipMovementData.withAddedLinearVelocity(newVelocityAdded).withAddedYawVelocity(newYawVelocityAdded);
                    draggable.setEntityShipMovementData(newMovementData);
                } else {
                    newVelocityAdded = oldVelocityAdded.mul(0.99, new Vector3d());
                    newYawVelocityAdded = oldYawVelocityAdded * 0.95;
                    EntityShipMovementData newMovementData = oldEntityShipMovementData.withAddedLinearVelocity(newVelocityAdded).withAddedYawVelocity(newYawVelocityAdded);
                    draggable.setEntityShipMovementData(newMovementData);
                }
            }
        } else {
            float rotYaw = entity.field_70177_z;
            float rotPitch = entity.field_70125_A;
            float prevYaw = entity.field_70126_B;
            float prevPitch = entity.field_70127_C;
            Vector3d oldPos = new Vector3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            Matrix4d betweenTransform = ShipTransform.createTransform(lastShipTouchedPlayer.getPrevTickShipTransform(), lastShipTouchedPlayer.getShipTransform());
            ValkyrienUtils.transformEntity(betweenTransform, entity, false);
            Vector3d newPos = new Vector3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            entity.func_70107_b(oldPos.x(), oldPos.y(), oldPos.z());
            Vector3d addedVel = newPos.sub(oldPos, new Vector3d());
            entity.field_70177_z = rotYaw;
            entity.field_70125_A = rotPitch;
            entity.field_70126_B = prevYaw;
            entity.field_70127_C = prevPitch;
            Vector3d newLookYawVec = entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) ? new Vector3d(-MathHelper.func_76126_a((float)(-entity.func_70079_am() * ((float)Math.PI / 180) - (float)Math.PI)), 0.0, -MathHelper.func_76134_b((float)(-entity.func_70079_am() * ((float)Math.PI / 180) - (float)Math.PI))) : new Vector3d(-MathHelper.func_76126_a((float)(-entity.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI)), 0.0, -MathHelper.func_76134_b((float)(-entity.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI)));
            betweenTransform.transformDirection(newLookYawVec);
            Tuple<Double, Double> newPlayerLookYawOnly = VSMath.getPitchYawFromVector(newLookYawVec);
            double wrappedYaw = MathHelper.func_76138_g((double)((Double)newPlayerLookYawOnly.func_76340_b()));
            double wrappedRotYaw = entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) ? (double)MathHelper.func_76142_g((float)entity.func_70079_am()) : (double)MathHelper.func_76142_g((float)entity.field_70177_z);
            double yawDif = wrappedYaw - wrappedRotYaw;
            if (Math.abs(yawDif) > 180.0) {
                yawDif = yawDif < 0.0 ? (yawDif += 360.0) : (yawDif -= 360.0);
            }
            yawDif %= 360.0;
            double threshold = 0.1;
            if (Math.abs(yawDif) < 0.1) {
                yawDif = 0.0;
            }
            draggable.setEntityShipMovementData(oldEntityShipMovementData.withAddedLinearVelocity(addedVel.mul(1.0, new Vector3d())).withAddedYawVelocity(yawDif));
        }
        EntityShipMovementData newEntityShipMovementData = draggable.getEntityShipMovementData();
        if (newEntityShipMovementData.getAddedLinearVelocity().lengthSquared() > 0.0) {
            boolean originallySneaking = entity.func_70093_af();
            entity.func_70095_a(false);
            Vector3dc addedVelocityNoNoClip = EntityDraggable.applyAddedVelocity(newEntityShipMovementData.getAddedLinearVelocity(), entity);
            draggable.setEntityShipMovementData(oldEntityShipMovementData.withAddedLinearVelocity(addedVelocityNoNoClip));
            entity.func_70095_a(originallySneaking);
        }
        double addedYawVelocity = newEntityShipMovementData.getAddedYawVelocity();
        if (!mountData.isMounted() && addedYawVelocity != 0.0) {
            entity.func_70034_d((float)((double)entity.func_70079_am() + addedYawVelocity));
            entity.field_70177_z = (float)((double)entity.field_70177_z + addedYawVelocity);
        }
    }

    public static IDraggable getDraggableFromEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        return (IDraggable)entity;
    }

    public static Entity getEntityFromDraggable(IDraggable draggable) {
        if (draggable == null) {
            return null;
        }
        return (Entity)draggable;
    }

    public static Vector3dc applyAddedVelocity(Vector3dc addedVelocity, Entity entity) {
        boolean flag;
        double x = addedVelocity.x();
        double y = addedVelocity.y();
        double z = addedVelocity.z();
        if (entity.field_70134_J) {
            entity.field_70134_J = false;
            x *= 0.25;
            y *= (double)0.05f;
            z *= 0.25;
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
        }
        double d2 = x;
        double d3 = y;
        double d4 = z;
        AxisAlignedBB potentialCrashBB = entity.func_174813_aQ().func_72317_d(x, y, z);
        if (potentialCrashBB.func_72320_b() > 999999.0) {
            System.err.println("Entity with ID " + entity.func_145782_y() + " went way too fast! Reseting its position.");
            return new Vector3d();
        }
        List list1 = entity.field_70170_p.func_184144_a(entity, potentialCrashBB);
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        if (y != 0.0) {
            int l = list1.size();
            for (int k = 0; k < l; ++k) {
                y = ((AxisAlignedBB)list1.get(k)).func_72323_b(entity.func_174813_aQ(), y);
            }
            entity.func_174826_a(entity.func_174813_aQ().func_72317_d(0.0, y, 0.0));
        }
        if (x != 0.0) {
            int l5 = list1.size();
            for (int j5 = 0; j5 < l5; ++j5) {
                x = ((AxisAlignedBB)list1.get(j5)).func_72316_a(entity.func_174813_aQ(), x);
            }
            if (x != 0.0) {
                entity.func_174826_a(entity.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
            }
        }
        if (z != 0.0) {
            int i6 = list1.size();
            for (int k5 = 0; k5 < i6; ++k5) {
                z = ((AxisAlignedBB)list1.get(k5)).func_72322_c(entity.func_174813_aQ(), z);
            }
            if (z != 0.0) {
                entity.func_174826_a(entity.func_174813_aQ().func_72317_d(0.0, 0.0, z));
            }
        }
        boolean bl = flag = entity.field_70122_E || d3 != y && d3 < 0.0;
        if (entity.field_70138_W > 0.0f && flag && (d2 != x || d4 != z)) {
            double d14 = x;
            double d6 = y;
            double d7 = z;
            AxisAlignedBB axisalignedbb1 = entity.func_174813_aQ();
            entity.func_174826_a(axisalignedbb);
            y = entity.field_70138_W;
            List list = entity.field_70170_p.func_184144_a(entity, entity.func_174813_aQ().func_72317_d(d2, y, d4));
            AxisAlignedBB axisalignedbb2 = entity.func_174813_aQ();
            AxisAlignedBB axisalignedbb3 = axisalignedbb2.func_72317_d(d2, 0.0, d4);
            double d8 = y;
            int k1 = list.size();
            for (int j1 = 0; j1 < k1; ++j1) {
                d8 = ((AxisAlignedBB)list.get(j1)).func_72323_b(axisalignedbb3, d8);
            }
            axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, d8, 0.0);
            double d18 = d2;
            int i2 = list.size();
            for (int l1 = 0; l1 < i2; ++l1) {
                d18 = ((AxisAlignedBB)list.get(l1)).func_72316_a(axisalignedbb2, d18);
            }
            axisalignedbb2 = axisalignedbb2.func_72317_d(d18, 0.0, 0.0);
            double d19 = d4;
            int k2 = list.size();
            for (int j2 = 0; j2 < k2; ++j2) {
                d19 = ((AxisAlignedBB)list.get(j2)).func_72322_c(axisalignedbb2, d19);
            }
            axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, 0.0, d19);
            AxisAlignedBB axisalignedbb4 = entity.func_174813_aQ();
            double d20 = y;
            int i3 = list.size();
            for (int l2 = 0; l2 < i3; ++l2) {
                d20 = ((AxisAlignedBB)list.get(l2)).func_72323_b(axisalignedbb4, d20);
            }
            axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, d20, 0.0);
            double d21 = d2;
            int k3 = list.size();
            for (int j3 = 0; j3 < k3; ++j3) {
                d21 = ((AxisAlignedBB)list.get(j3)).func_72316_a(axisalignedbb4, d21);
            }
            axisalignedbb4 = axisalignedbb4.func_72317_d(d21, 0.0, 0.0);
            double d22 = d4;
            int i4 = list.size();
            for (int l3 = 0; l3 < i4; ++l3) {
                d22 = ((AxisAlignedBB)list.get(l3)).func_72322_c(axisalignedbb4, d22);
            }
            axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, 0.0, d22);
            double d23 = d18 * d18 + d19 * d19;
            double d9 = d21 * d21 + d22 * d22;
            if (d23 > d9) {
                x = d18;
                z = d19;
                y = -d8;
                entity.func_174826_a(axisalignedbb2);
            } else {
                x = d21;
                z = d22;
                y = -d20;
                entity.func_174826_a(axisalignedbb4);
            }
            int k4 = list.size();
            for (int j4 = 0; j4 < k4; ++j4) {
                y = ((AxisAlignedBB)list.get(j4)).func_72323_b(entity.func_174813_aQ(), y);
            }
            entity.func_174826_a(entity.func_174813_aQ().func_72317_d(0.0, y, 0.0));
            if (d14 * d14 + d7 * d7 >= x * x + z * z) {
                x = d14;
                y = d6;
                z = d7;
                entity.func_174826_a(axisalignedbb1);
            }
        }
        entity.func_174829_m();
        return new Vector3d(x, y, z);
    }
}

