/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.entity_interaction;

import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.collision.Polygon;

public class EntityCollisionObject {
    private final Vector3dc axis;
    private final Polygon movable;
    private final Polygon fixed;
    private double penetrationDistance;
    private boolean separated;
    private final Vector3dc entityVelocity;
    private boolean originallyCollided;
    private double velDot;

    public EntityCollisionObject(Polygon movable_, Polygon stationary, Vector3dc axes, Vector3dc entityVel) {
        this.axis = axes;
        this.movable = movable_;
        this.fixed = stationary;
        this.entityVelocity = entityVel;
        this.originallyCollided = false;
        this.generateCollision();
    }

    public void generateCollision() {
        double dot;
        this.velDot = -this.entityVelocity.dot(this.axis);
        double playerMin = dot = this.axis.dot(this.movable.getVertices()[0]);
        double playerMax = dot;
        for (int i = 1; i < this.movable.getVertices().length; ++i) {
            dot = this.axis.dot(this.movable.getVertices()[i]);
            if (dot < playerMin) {
                playerMin = dot;
            }
            if (!(dot > playerMax)) continue;
            playerMax = dot;
        }
        double blockMin = dot = this.axis.dot(this.fixed.getVertices()[0]);
        double blockMax = dot;
        for (int i = 1; i < this.fixed.getVertices().length; ++i) {
            dot = this.axis.dot(this.fixed.getVertices()[i]);
            if (dot < blockMin) {
                blockMin = dot;
            }
            if (!(dot > blockMax)) continue;
            blockMax = dot;
        }
        double movMaxFixMin = playerMin - blockMax;
        double movMinFixMax = playerMax - blockMin;
        boolean useDefault = true;
        if (movMaxFixMin > 0.0 || movMinFixMax < 0.0) {
            useDefault = false;
        } else {
            this.originallyCollided = true;
        }
        if (this.velDot > 0.0) {
            movMaxFixMin -= this.velDot;
        } else {
            movMinFixMax -= this.velDot;
        }
        if (movMaxFixMin > 0.0 || movMinFixMax < 0.0) {
            this.separated = true;
            this.penetrationDistance = 0.0;
            return;
        }
        this.penetrationDistance = useDefault || this.velDot == 0.0 ? (Math.abs(movMaxFixMin) < Math.abs(movMinFixMax) ? movMaxFixMin : movMinFixMax) : (Math.signum(this.velDot) != Math.signum(movMinFixMax) ? movMinFixMax : movMaxFixMin);
        this.separated = false;
    }

    public Vector3d getResponse() {
        return this.axis.mul(-this.penetrationDistance, new Vector3d());
    }

    public Vector3dc getCollisionNormal() {
        return this.axis;
    }

    public double getCollisionPenetrationDistance() {
        return this.penetrationDistance;
    }

    public boolean arePolygonsSeperated() {
        return this.separated;
    }

    public boolean werePolygonsInitiallyColliding() {
        return this.originallyCollided;
    }

    public double getVelDot() {
        return this.velDot;
    }
}

