/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.entity_interaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.collision.EntityPolygonCollider;
import org.valkyrienskies.mod.common.collision.PhysPolygonCollider;
import org.valkyrienskies.mod.common.collision.Polygon;
import org.valkyrienskies.mod.common.collision.ShipPolygon;
import org.valkyrienskies.mod.common.entity.EntityMountable;
import org.valkyrienskies.mod.common.entity.EntityShipMovementData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityDraggable;
import org.valkyrienskies.mod.common.ships.entity_interaction.IDraggable;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.IHasShipManager;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.VSMath;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

public class EntityCollisionInjector {
    private static final double errorSignificance = 0.001;

    @Nullable
    public static IntermediateMovementVariableStorage alterEntityMovement(Entity entity, MoverType type, double dx, double dy, double dz) {
        Optional<PhysicsObject> physicsObjectOptional;
        EntityMountable entityMountable;
        double origDx = dx;
        double origDy = dy;
        double origDz = dz;
        double origPosX = entity.field_70165_t;
        double origPosY = entity.field_70163_u;
        double origPosZ = entity.field_70161_v;
        boolean isLiving = entity instanceof EntityLivingBase;
        Vec3d velocity = new Vec3d(dx, dy, dz);
        Polygon playerBeforeMove = new Polygon(entity.func_174813_aQ());
        ArrayList<Polygon> colPolys = EntityCollisionInjector.getCollidingPolygonsAndDoBlockCols(entity, velocity);
        PhysicsObject worldBelow = null;
        IDraggable draggable = EntityDraggable.getDraggableFromEntity(entity);
        EntityShipMovementData lastTickEntityShipMovementData = draggable.getEntityShipMovementData();
        Vector3d total = new Vector3d();
        double posOffestX = 0.0;
        double posOffestY = 0.0;
        double posOffestZ = 0.0;
        boolean isPlayerOnLadder = false;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase base = (EntityLivingBase)entity;
            List<PhysicsObject> collidingShips = ((IHasShipManager)entity.func_130014_f_()).getManager().getPhysObjectsInAABB(base.func_174813_aQ());
            Iterable<Triple<PhysicsObject, BlockPos, IBlockState>> ladderCollisions = EntityCollisionInjector.getLadderCollisions(base, collidingShips);
            float forward = ((EntityLivingBase)entity).field_191988_bg;
            float strafe = ((EntityLivingBase)entity).field_70702_br;
            double f1 = Math.sin(Math.toRadians(entity.field_70177_z));
            double f2 = Math.cos(Math.toRadians(entity.field_70177_z));
            double intendedXVel = (double)strafe * f2 - (double)forward * f1;
            double intendedYVel = 0.0;
            double intendedZVel = (double)forward * f2 + (double)strafe * f1;
            Vector3d originalVelocityDirection = new Vector3d(intendedXVel, 0.0, intendedZVel).normalize();
            World world = entity.field_70170_p;
            Polygon playerPolygon = new Polygon(base.func_174813_aQ());
            for (Triple<PhysicsObject, BlockPos, IBlockState> ladderCollision : ladderCollisions) {
                IBlockState ladderState = (IBlockState)ladderCollision.getRight();
                EnumFacing ladderFacing = null;
                if (ladderState.func_177227_a().contains(BlockHorizontal.field_185512_D)) {
                    ladderFacing = (EnumFacing)ladderState.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                }
                if (ladderFacing == null) continue;
                Vector3d ladderNormal = JOML.convertDouble(ladderFacing.func_176730_m());
                ShipTransform shipTransform = ((PhysicsObject)ladderCollision.getLeft()).getShipTransform();
                AxisAlignedBB ladderBB = ((IBlockState)ladderCollision.getRight()).func_185900_c((IBlockAccess)world, (BlockPos)ladderCollision.getMiddle()).func_186670_a((BlockPos)ladderCollision.getMiddle()).func_186662_g(0.4);
                Polygon ladderPoly = new Polygon(ladderBB, shipTransform.getSubspaceToGlobal());
                PhysPolygonCollider collider = new PhysPolygonCollider(playerPolygon, ladderPoly, ((PhysicsObject)ladderCollision.getLeft()).getShipTransformationManager().normals);
                collider.processData();
                shipTransform.transformDirection(ladderNormal, TransformType.SUBSPACE_TO_GLOBAL);
                boolean isLadderFacingDown = ladderNormal.y > 0.8;
                if (isLadderFacingDown) continue;
                boolean isLadderFacingUp = ladderNormal.y < -0.8;
                dx = MathHelper.func_151237_a((double)dx, (double)-0.15, (double)0.15);
                dz = MathHelper.func_151237_a((double)dz, (double)-0.15, (double)0.15);
                base.field_70143_R = 0.0f;
                if (!isLadderFacingUp) {
                    boolean isPlayerSneakingOnLadder;
                    if (dy < -0.15) {
                        dy = -0.15;
                    }
                    boolean isPlayerGoingTowardsLadder = originalVelocityDirection.dot(ladderNormal) < -0.1;
                    boolean bl = isPlayerSneakingOnLadder = base.func_70093_af() && base instanceof EntityPlayer;
                    if (isPlayerSneakingOnLadder && dy < 0.0) {
                        dy = 0.0;
                    }
                    if (!collider.seperated && isPlayerGoingTowardsLadder) {
                        dy = 0.2;
                    }
                } else {
                    dy = 0.2;
                }
                worldBelow = (PhysicsObject)ladderCollision.getLeft();
                isPlayerOnLadder = true;
                break;
            }
        }
        Vector3d velVec = new Vector3d(dx, dy, dz);
        for (Polygon poly : colPolys) {
            if (!(poly instanceof ShipPolygon)) continue;
            ShipPolygon shipPoly = (ShipPolygon)poly;
            try {
                boolean isStep;
                EntityPolygonCollider fast = new EntityPolygonCollider(playerBeforeMove, shipPoly, shipPoly.normals, velVec.add(total, new Vector3d()));
                if (fast.arePolygonsSeparated()) continue;
                worldBelow = shipPoly.shipFrom;
                Vector3d response = fast.getCollisions()[fast.getMinDistanceIndex()].getResponse();
                double stepSquared = entity.field_70138_W * entity.field_70138_W;
                boolean bl = isStep = isLiving && entity.field_70122_E && !isPlayerOnLadder;
                if (response.y >= 0.0 && VSMath.canStandOnNormal(fast.getCollisionAxes()[fast.getMinDistanceIndex()])) {
                    Vector3d slowButStopped;
                    response = slowButStopped = new Vector3d(0.0, -fast.getCollisions()[fast.getMinDistanceIndex()].getCollisionPenetrationDistance() / fast.getCollisionAxes()[fast.getMinDistanceIndex()].y(), 0.0);
                }
                if (isStep) {
                    EntityLivingBase living = (EntityLivingBase)entity;
                    if ((double)Math.abs(living.field_191988_bg) > 0.01 || (double)Math.abs(living.field_70702_br) > 0.01) {
                        for (int i = 3; i < 6; ++i) {
                            Vector3d tempResponse = fast.getCollisions()[i].getResponse();
                            if (!(tempResponse.y > 0.0) || !VSMath.canStandOnNormal(fast.getCollisions()[i].getCollisionNormal()) || !(tempResponse.lengthSquared() < stepSquared)) continue;
                            if (tempResponse.lengthSquared() < 0.1) {
                                response = tempResponse;
                                continue;
                            }
                            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72317_d(tempResponse.x, tempResponse.y, tempResponse.z);
                            boolean collidesWithAnything = false;
                            AxisAlignedBB newEntityBBShrunk = axisalignedbb.func_186664_h(0.15);
                            Polygon newEntityBBShrunkPolygon = new Polygon(newEntityBBShrunk);
                            for (Polygon potentialStepCollision : colPolys) {
                                if (potentialStepCollision == poly || !potentialStepCollision.getEnclosedAABB().func_72326_a(newEntityBBShrunk)) continue;
                                ShipPolygon potentialStepCollisionShipPoly = (ShipPolygon)potentialStepCollision;
                                EntityPolygonCollider checkIfStepCollidesWithBlock = new EntityPolygonCollider(newEntityBBShrunkPolygon, potentialStepCollisionShipPoly, potentialStepCollisionShipPoly.normals, new Vector3d());
                                checkIfStepCollidesWithBlock.processData();
                                if (checkIfStepCollidesWithBlock.arePolygonsSeparated()) continue;
                                collidesWithAnything = true;
                                break;
                            }
                            if (collidesWithAnything) continue;
                            entity.func_174826_a(axisalignedbb);
                            response.zero();
                            entity.func_174829_m();
                        }
                    }
                }
                if (Math.abs(response.x) > 0.01) {
                    total.x += response.x;
                }
                if (Math.abs(response.y) > 0.01) {
                    total.y += response.y;
                }
                if (Math.abs(response.z) > 0.01) {
                    total.z += response.z;
                }
                entity.field_70165_t += response.x;
                entity.field_70163_u += response.y;
                entity.field_70161_v += response.z;
                posOffestX += response.x;
                posOffestY += response.y;
                posOffestZ += response.z;
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72317_d(response.x, response.y, response.z);
                entity.func_174826_a(axisalignedbb);
                entity.func_174829_m();
            }
            catch (Exception fast) {}
        }
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72317_d(-posOffestX, -posOffestY, -posOffestZ);
        entity.func_174826_a(axisalignedbb);
        entity.func_174829_m();
        if (entity.field_184239_as instanceof EntityMountable && (entityMountable = (EntityMountable)entity.field_184239_as).getReferencePosOptional().isPresent() && (physicsObjectOptional = ValkyrienUtils.getPhysoManagingBlock(entity.field_70170_p, entityMountable.getReferencePosOptional().get())).isPresent()) {
            worldBelow = physicsObjectOptional.get();
        }
        if (worldBelow == null) {
            return null;
        }
        boolean alreadyOnGround = entity.field_70122_E && (dy += total.y) == origDy && origDy < 0.0;
        Vector3d original = new Vector3d(origDx, origDy, origDz);
        Vector3d newMov = new Vector3d((dx += total.x) - origDx, dy - origDy, (dz += total.z) - origDz);
        entity.field_70123_F = original.dot(newMov) < 0.0;
        entity.field_70124_G = EntityCollisionInjector.isDifSignificant(dy, origDy);
        entity.field_70122_E = entity.field_70124_G && origDy < 0.0 || alreadyOnGround;
        entity.field_70132_H = entity.field_70123_F || entity.field_70124_G;
        double motionYBefore = entity.field_70181_x;
        float oldFallDistance = entity.field_70143_R;
        Vector3d dxyz = new Vector3d(dx, dy, dz);
        Vector3d origDxyz = new Vector3d(origDx, origDy, origDz);
        Vector3d origPosXyz = new Vector3d(origPosX, origPosY, origPosZ);
        return new IntermediateMovementVariableStorage(dxyz, origDxyz, origPosXyz, alreadyOnGround, motionYBefore, oldFallDistance, worldBelow.getShipData());
    }

    public static void alterEntityMovementPost(Entity entity, IntermediateMovementVariableStorage storage) {
        double dx = storage.dxyz.x();
        double dy = storage.dxyz.y();
        double dz = storage.dxyz.z();
        double origDx = storage.origDxyz.x();
        double origDy = storage.origDxyz.y();
        double origDz = storage.origDxyz.z();
        double origPosX = storage.origPosXyz.x();
        double origPosY = storage.origPosXyz.y();
        double origPosZ = storage.origPosXyz.z();
        boolean alreadyOnGround = storage.alreadyOnGround;
        double motionYBefore = storage.motionYBefore;
        float oldFallDistance = storage.oldFallDistance;
        ShipData worldBelow = ValkyrienUtils.getLastShipTouchedByEntity(entity);
        entity.field_70123_F = EntityCollisionInjector.motionInterfering(dx, origDx) || EntityCollisionInjector.motionInterfering(dz, origDz);
        entity.field_70124_G = EntityCollisionInjector.isDifSignificant(dy, origDy);
        entity.field_70122_E = entity.field_70124_G && origDy < 0.0 || alreadyOnGround || entity.field_70122_E;
        entity.field_70132_H = entity.field_70123_F || entity.field_70124_G;
        Vector3d entityPosInShip = new Vector3d(entity.field_70165_t, entity.field_70163_u - (double)0.2f, entity.field_70161_v);
        worldBelow.getShipTransform().transformPosition(entityPosInShip, TransformType.GLOBAL_TO_SUBSPACE);
        int j4 = MathHelper.func_76128_c((double)entityPosInShip.x);
        int l4 = MathHelper.func_76128_c((double)entityPosInShip.y);
        int i5 = MathHelper.func_76128_c((double)entityPosInShip.z);
        BlockPos blockpos = new BlockPos(j4, l4, i5);
        IBlockState iblockstate = entity.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (block instanceof BlockSlime && !entity.field_70134_J) {
            entity.field_70181_x = motionYBefore;
        }
        entity.field_70143_R = oldFallDistance;
        if (entity instanceof EntityLivingBase && !entity.field_70170_p.field_72995_K && entity.field_70143_R > 3.0f && entity.field_70122_E) {
            float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
            if (!iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)entity.field_70170_p, blockpos)) {
                double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int i = (int)(150.0 * d0);
                if (!iblockstate.func_177230_c().addLandingEffects(iblockstate, (WorldServer)entity.field_70170_p, blockpos, iblockstate, (EntityLivingBase)entity, i)) {
                    ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, i, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
                }
            }
        }
        if (entity.field_70122_E) {
            if (entity.field_70143_R > 0.0f) {
                iblockstate.func_177230_c().func_180658_a(entity.field_70170_p, blockpos, entity, entity.field_70143_R);
            }
            entity.field_70143_R = 0.0f;
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70143_R = (float)((double)entity.field_70143_R - entity.field_70181_x);
        }
        if (entity instanceof EntityPlayer && !entity.func_184218_aH()) {
            if (dy != origDy) {
                block.func_176216_a(entity.field_70170_p, entity);
            }
            if (block != null && entity.field_70122_E) {
                block.func_176199_a(entity.field_70170_p, blockpos, entity);
            }
            if (entity.field_82151_R > (float)entity.field_70150_b && iblockstate.func_185904_a() != Material.field_151579_a) {
                entity.field_70150_b = (int)entity.field_82151_R + 1;
                SoundType soundtype = block.getSoundType(entity.field_70170_p.func_180495_p(blockpos), entity.field_70170_p, blockpos, entity);
                if (entity.field_70170_p.func_180495_p(blockpos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                    soundtype = Blocks.field_150431_aC.func_185467_w();
                    entity.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                } else if (!block.func_176223_P().func_185904_a().func_76224_d()) {
                    entity.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
                }
            }
        }
        if (dx != origDx) {
            entity.field_70159_w = dx;
        }
        if (!(dy == origDy || entity.field_70181_x > 0.0 && dy > 0.0)) {
            entity.field_70181_x = 0.0;
        }
        if (dz != origDz) {
            entity.field_70179_y = dz;
        }
    }

    public static ArrayList<Polygon> getCollidingPolygonsAndDoBlockCols(Entity entity, Vec3d velocity) {
        ArrayList<Polygon> collisions = new ArrayList<Polygon>();
        AxisAlignedBB entityBB = entity.func_174813_aQ().func_72317_d(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c).func_72321_a(1.0, 1.0, 1.0);
        List<PhysicsObject> ships = ((IHasShipManager)entity.func_130014_f_()).getManager().getPhysObjectsInAABB(entityBB);
        for (PhysicsObject wrapper : ships) {
            try {
                Polygon playerInLocal = new Polygon(entityBB, wrapper.getShipTransformationManager().getCurrentTickTransform(), TransformType.GLOBAL_TO_SUBSPACE);
                AxisAlignedBB bb = playerInLocal.getEnclosedAABB();
                if ((bb.field_72336_d - bb.field_72340_a) * (bb.field_72334_f - bb.field_72339_c) > 9898989.0) break;
                List collidingBBs = entity.field_70170_p.func_184144_a(entity, bb);
                if (entity.field_70170_p.field_72995_K || entity instanceof EntityPlayer) {
                    VSMath.mergeAABBList(collidingBBs);
                }
                for (AxisAlignedBB inLocal : collidingBBs) {
                    ShipPolygon poly = new ShipPolygon(inLocal, wrapper.getShipTransformationManager().getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL, wrapper.getShipTransformationManager().normals, wrapper);
                    collisions.add(poly);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (PhysicsObject wrapper : ships) {
            double posX = entity.field_70165_t;
            double posY = entity.field_70163_u;
            double posZ = entity.field_70161_v;
            Vector3d entityPos = new Vector3d(posX, posY, posZ);
            wrapper.getShipTransformationManager().getCurrentTickTransform().transformPosition(entityPos, TransformType.GLOBAL_TO_SUBSPACE);
            EntityCollisionInjector.setEntityPositionAndUpdateBB(entity, entityPos.x, entityPos.y, entityPos.z);
            int entityChunkX = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0));
            int entityChunkZ = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0));
            if (wrapper.getChunkClaim().containsChunk(entityChunkX, entityChunkZ)) {
                Chunk chunkIn = wrapper.getChunkAt(entityChunkX, entityChunkZ);
                int chunkYIndex = MathHelper.func_76128_c((double)(entity.field_70163_u / 16.0));
                if (chunkYIndex < 0) {
                    chunkYIndex = 0;
                }
                if (chunkYIndex >= chunkIn.field_76645_j.length) {
                    chunkYIndex = chunkIn.field_76645_j.length - 1;
                }
                chunkIn.field_76645_j[chunkYIndex].add((Object)entity);
                entity.func_145775_I();
                chunkIn.field_76645_j[chunkYIndex].remove((Object)entity);
            }
            EntityCollisionInjector.setEntityPositionAndUpdateBB(entity, posX, posY, posZ);
        }
        return collisions;
    }

    public static void setEntityPositionAndUpdateBB(Entity entity, double x, double y, double z) {
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        float f = entity.field_70130_N / 2.0f;
        float f1 = entity.field_70131_O;
        entity.field_70121_D = new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f);
    }

    private static boolean isDifSignificant(double dif1, double d2) {
        return !(Math.abs(dif1 - d2) < 0.001);
    }

    private static boolean motionInterfering(double orig, double modded) {
        return Math.signum(orig) != Math.signum(modded);
    }

    public static Iterable<Triple<PhysicsObject, BlockPos, IBlockState>> getLadderCollisions(EntityLivingBase entity, List<PhysicsObject> collidingShips) {
        boolean isSpectator = entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v();
        World world = entity.func_130014_f_();
        ArrayList<Triple<PhysicsObject, BlockPos, IBlockState>> ladderCollisions = new ArrayList<Triple<PhysicsObject, BlockPos, IBlockState>>();
        if (!isSpectator) {
            AxisAlignedBB bb = entity.func_174813_aQ();
            for (PhysicsObject physicsObject : collidingShips) {
                Polygon playerPolyInShip = new Polygon(bb, physicsObject.getShipTransform(), TransformType.GLOBAL_TO_SUBSPACE);
                AxisAlignedBB playerPolyInShipBB = playerPolyInShip.getEnclosedAABB();
                int mX = MathHelper.func_76128_c((double)playerPolyInShipBB.field_72340_a);
                int mY = MathHelper.func_76128_c((double)playerPolyInShipBB.field_72338_b);
                int mZ = MathHelper.func_76128_c((double)playerPolyInShipBB.field_72339_c);
                int y2 = mY;
                while ((double)y2 < playerPolyInShipBB.field_72337_e) {
                    int x2 = mX;
                    while ((double)x2 < playerPolyInShipBB.field_72336_d) {
                        int z2 = mZ;
                        while ((double)z2 < playerPolyInShipBB.field_72334_f) {
                            BlockPos tmp = new BlockPos(x2, y2, z2);
                            IBlockState state = world.func_180495_p(tmp);
                            if (state.func_177230_c().isLadder(state, (IBlockAccess)world, tmp, entity)) {
                                ladderCollisions.add((Triple<PhysicsObject, BlockPos, IBlockState>)Triple.of((Object)physicsObject, (Object)tmp, (Object)state));
                            }
                            ++z2;
                        }
                        ++x2;
                    }
                    ++y2;
                }
            }
        }
        return ladderCollisions;
    }

    public static final class IntermediateMovementVariableStorage {
        @Nonnull
        public final Vector3dc dxyz;
        @Nonnull
        public final Vector3dc origDxyz;
        @Nonnull
        public final Vector3dc origPosXyz;
        public final boolean alreadyOnGround;
        public final double motionYBefore;
        public final float oldFallDistance;
        @Nonnull
        public final ShipData shipTouched;

        public IntermediateMovementVariableStorage(@Nonnull Vector3dc dxyz, @Nonnull Vector3dc origDxyz, @Nonnull Vector3dc origPosXyz, boolean alreadyOnGround, double motionYBefore, float oldFallDistance, @Nonnull ShipData shipTouched) {
            if (dxyz == null) {
                throw new NullPointerException("dxyz is marked non-null but is null");
            }
            if (origDxyz == null) {
                throw new NullPointerException("origDxyz is marked non-null but is null");
            }
            if (origPosXyz == null) {
                throw new NullPointerException("origPosXyz is marked non-null but is null");
            }
            if (shipTouched == null) {
                throw new NullPointerException("shipTouched is marked non-null but is null");
            }
            this.dxyz = dxyz;
            this.origDxyz = origDxyz;
            this.origPosXyz = origPosXyz;
            this.alreadyOnGround = alreadyOnGround;
            this.motionYBefore = motionYBefore;
            this.oldFallDistance = oldFallDistance;
            this.shipTouched = shipTouched;
        }

        @Nonnull
        public Vector3dc getDxyz() {
            return this.dxyz;
        }

        @Nonnull
        public Vector3dc getOrigDxyz() {
            return this.origDxyz;
        }

        @Nonnull
        public Vector3dc getOrigPosXyz() {
            return this.origPosXyz;
        }

        public boolean isAlreadyOnGround() {
            return this.alreadyOnGround;
        }

        public double getMotionYBefore() {
            return this.motionYBefore;
        }

        public float getOldFallDistance() {
            return this.oldFallDistance;
        }

        @Nonnull
        public ShipData getShipTouched() {
            return this.shipTouched;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntermediateMovementVariableStorage)) {
                return false;
            }
            IntermediateMovementVariableStorage other = (IntermediateMovementVariableStorage)o;
            Vector3dc this$dxyz = this.getDxyz();
            Vector3dc other$dxyz = other.getDxyz();
            if (this$dxyz == null ? other$dxyz != null : !this$dxyz.equals(other$dxyz)) {
                return false;
            }
            Vector3dc this$origDxyz = this.getOrigDxyz();
            Vector3dc other$origDxyz = other.getOrigDxyz();
            if (this$origDxyz == null ? other$origDxyz != null : !this$origDxyz.equals(other$origDxyz)) {
                return false;
            }
            Vector3dc this$origPosXyz = this.getOrigPosXyz();
            Vector3dc other$origPosXyz = other.getOrigPosXyz();
            if (this$origPosXyz == null ? other$origPosXyz != null : !this$origPosXyz.equals(other$origPosXyz)) {
                return false;
            }
            if (this.isAlreadyOnGround() != other.isAlreadyOnGround()) {
                return false;
            }
            if (Double.compare(this.getMotionYBefore(), other.getMotionYBefore()) != 0) {
                return false;
            }
            if (Float.compare(this.getOldFallDistance(), other.getOldFallDistance()) != 0) {
                return false;
            }
            ShipData this$shipTouched = this.getShipTouched();
            ShipData other$shipTouched = other.getShipTouched();
            return !(this$shipTouched == null ? other$shipTouched != null : !this$shipTouched.equals(other$shipTouched));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Vector3dc $dxyz = this.getDxyz();
            result = result * 59 + ($dxyz == null ? 43 : $dxyz.hashCode());
            Vector3dc $origDxyz = this.getOrigDxyz();
            result = result * 59 + ($origDxyz == null ? 43 : $origDxyz.hashCode());
            Vector3dc $origPosXyz = this.getOrigPosXyz();
            result = result * 59 + ($origPosXyz == null ? 43 : $origPosXyz.hashCode());
            result = result * 59 + (this.isAlreadyOnGround() ? 79 : 97);
            long $motionYBefore = Double.doubleToLongBits(this.getMotionYBefore());
            result = result * 59 + (int)($motionYBefore >>> 32 ^ $motionYBefore);
            result = result * 59 + Float.floatToIntBits(this.getOldFallDistance());
            ShipData $shipTouched = this.getShipTouched();
            result = result * 59 + ($shipTouched == null ? 43 : $shipTouched.hashCode());
            return result;
        }

        public String toString() {
            return "EntityCollisionInjector.IntermediateMovementVariableStorage(dxyz=" + this.getDxyz() + ", origDxyz=" + this.getOrigDxyz() + ", origPosXyz=" + this.getOrigPosXyz() + ", alreadyOnGround=" + this.isAlreadyOnGround() + ", motionYBefore=" + this.getMotionYBefore() + ", oldFallDistance=" + this.getOldFallDistance() + ", shipTouched=" + this.getShipTouched() + ")";
        }
    }
}

