/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.chunk_claims;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import org.valkyrienskies.deps.com.fasterxml.jackson.annotation.JsonCreator;

@Immutable
public final class VSChunkClaim
implements Iterable<ChunkPos> {
    private final ChunkPos centerPos;
    private final Set<Long> claimedChunks;

    public VSChunkClaim(ChunkPos centerPos) {
        this.centerPos = centerPos;
        this.claimedChunks = new HashSet<Long>();
    }

    @JsonCreator
    @ConstructorProperties(value={"centerPos", "claimedChunks"})
    private VSChunkClaim(ChunkPos centerPos, Set<Long> claimedChunks) {
        this.centerPos = centerPos;
        this.claimedChunks = claimedChunks;
    }

    public void writeToNBT(NBTTagCompound toSave) {
        toSave.func_74772_a("centerPos", VSChunkClaim.getChunkPos(this.centerPos.field_77276_a, this.centerPos.field_77275_b));
        int[] chunkPositions = new int[this.claimedChunks.size() * 2];
        int i = 0;
        for (Long chunkPos : this.claimedChunks) {
            chunkPositions[i] = VSChunkClaim.getChunkX(chunkPos);
            chunkPositions[i + 1] = VSChunkClaim.getChunkZ(chunkPos);
            i += 2;
        }
        toSave.func_74783_a("claimedChunks", chunkPositions);
    }

    public boolean containsChunk(int chunkX, int chunkZ) {
        int radius = 7;
        int relativeChunkX = chunkX - this.centerPos.field_77276_a + 7;
        int relativeChunkZ = chunkZ - this.centerPos.field_77275_b + 7;
        return relativeChunkX >= 0 && relativeChunkX < 15 && relativeChunkZ >= 0 && relativeChunkZ < 15;
    }

    public boolean containsChunk(ChunkPos pos) {
        return this.containsChunk(pos.field_77276_a, pos.field_77275_b);
    }

    public boolean containsBlock(BlockPos pos) {
        return this.containsChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public boolean addChunkClaim(int chunkX, int chunkZ) {
        long chunkPos = VSChunkClaim.getChunkPos(chunkX, chunkZ);
        return this.claimedChunks.add(chunkPos);
    }

    public boolean removeChunkClaim(int chunkX, int chunkZ) {
        long chunkPos = VSChunkClaim.getChunkPos(chunkX, chunkZ);
        return this.claimedChunks.remove(chunkPos);
    }

    public String toString() {
        return this.centerPos + ":claim size " + this.claimedChunks.size();
    }

    public BlockPos getRegionCenter() {
        return new BlockPos(this.centerPos.func_180334_c(), 128, this.centerPos.func_180333_d());
    }

    private ImmutableSet<Long> calculateChunkLongs() {
        return (ImmutableSet)this.claimedChunks.stream().collect(ImmutableSet.toImmutableSet());
    }

    public Stream<ChunkPos> stream() {
        return Streams.stream((Iterable)this);
    }

    public void forEach(BiConsumer<Integer, Integer> consumer) {
        this.forEach((? super T pos) -> consumer.accept(pos.field_77276_a, pos.field_77275_b));
    }

    @Override
    public Iterator<ChunkPos> iterator() {
        return new ChunkPosIterator();
    }

    private static int getChunkX(long chunkPos) {
        return (int)(chunkPos & 0xFFFFFFFFL);
    }

    private static int getChunkZ(long chunkPos) {
        return (int)(chunkPos >> 32 & 0xFFFFFFFFL);
    }

    private static long getChunkPos(int chunkX, int chunkZ) {
        return ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
    }

    public ChunkPos getCenterPos() {
        return this.centerPos;
    }

    public Set<Long> getClaimedChunks() {
        return this.claimedChunks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VSChunkClaim)) {
            return false;
        }
        VSChunkClaim other = (VSChunkClaim)o;
        ChunkPos this$centerPos = this.getCenterPos();
        ChunkPos other$centerPos = other.getCenterPos();
        if (this$centerPos == null ? other$centerPos != null : !this$centerPos.equals(other$centerPos)) {
            return false;
        }
        Set<Long> this$claimedChunks = this.getClaimedChunks();
        Set<Long> other$claimedChunks = other.getClaimedChunks();
        return !(this$claimedChunks == null ? other$claimedChunks != null : !((Object)this$claimedChunks).equals(other$claimedChunks));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChunkPos $centerPos = this.getCenterPos();
        result = result * 59 + ($centerPos == null ? 43 : $centerPos.hashCode());
        Set<Long> $claimedChunks = this.getClaimedChunks();
        result = result * 59 + ($claimedChunks == null ? 43 : ((Object)$claimedChunks).hashCode());
        return result;
    }

    class ChunkPosIterator
    implements Iterator<ChunkPos> {
        Iterator<Long> chunkLongsIterator;

        ChunkPosIterator() {
            this.chunkLongsIterator = VSChunkClaim.this.claimedChunks.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.chunkLongsIterator.hasNext();
        }

        @Override
        public ChunkPos next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long next = this.chunkLongsIterator.next();
            int x = VSChunkClaim.getChunkX(next);
            int z = VSChunkClaim.getChunkZ(next);
            return new ChunkPos(x, z);
        }
    }
}

