/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.chunk_claims;

import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.gen.ChunkProviderServer;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;

public class SurroundingChunkCacheController {
    private ChunkCache cachedChunks;
    private PhysicsObject physicsObject;

    public SurroundingChunkCacheController(PhysicsObject physicsObject) {
        this.physicsObject = physicsObject;
        this.cachedChunks = null;
    }

    public void updateChunkCache() {
        AxisAlignedBB cacheBB = this.physicsObject.getShipBoundingBox();
        BlockPos min = new BlockPos(cacheBB.field_72340_a, Math.max(cacheBB.field_72338_b, 0.0), cacheBB.field_72339_c);
        BlockPos max = new BlockPos(cacheBB.field_72336_d, Math.min(cacheBB.field_72337_e, 255.0), cacheBB.field_72334_f);
        if (!this.physicsObject.getWorld().field_72995_K) {
            ChunkProviderServer serverChunkProvider = (ChunkProviderServer)this.physicsObject.getWorld().func_72863_F();
            int chunkMinX = min.func_177958_n() >> 4;
            int chunkMaxX = max.func_177958_n() >> 4;
            int chunkMinZ = min.func_177952_p() >> 4;
            int chunkMaxZ = max.func_177952_p() >> 4;
            boolean areSurroundingChunksLoaded = true;
            block0: for (int chunkX = chunkMinX; chunkX <= chunkMaxX; ++chunkX) {
                for (int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; ++chunkZ) {
                    areSurroundingChunksLoaded = serverChunkProvider.func_73149_a(chunkX, chunkZ);
                    if (!areSurroundingChunksLoaded) break block0;
                }
            }
            if (areSurroundingChunksLoaded) {
                this.cachedChunks = new ChunkCache(this.physicsObject.getWorld(), min, max, 0);
            }
        } else {
            this.cachedChunks = new ChunkCache(this.physicsObject.getWorld(), min, max, 0);
        }
    }

    public ChunkCache getCachedChunks() {
        return this.cachedChunks;
    }
}

