/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.chunk_claims;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.ships.chunk_claims.ChunkNotInClaimException;
import org.valkyrienskies.mod.common.ships.chunk_claims.VSChunkClaim;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;

public class ClaimedChunkCacheController
implements Iterable<Chunk> {
    private static final Logger log = LogManager.getLogger(ClaimedChunkCacheController.class);
    private final PhysicsObject parent;
    private final World world;
    private final Chunk[][] claimedChunks;
    private final int chunkBottomX;
    private final int chunkBottomZ;
    private final int radius;

    public ClaimedChunkCacheController(PhysicsObject parent) {
        this.world = parent.getWorld();
        this.parent = parent;
        this.radius = 7;
        this.claimedChunks = new Chunk[this.radius * 2 + 1][this.radius * 2 + 1];
        this.chunkBottomX = parent.getChunkClaim().getCenterPos().field_77276_a - this.radius;
        this.chunkBottomZ = parent.getChunkClaim().getCenterPos().field_77275_b - this.radius;
        this.loadChunksIntoCache();
    }

    public Chunk getChunkAt(int chunkX, int chunkZ) {
        this.throwIfOutOfBounds(chunkX, chunkZ);
        return this.claimedChunks[chunkX - this.chunkBottomX][chunkZ - this.chunkBottomZ];
    }

    private void setChunkAt(int chunkX, int chunkZ, Chunk chunk) {
        this.throwIfOutOfBounds(chunkX, chunkZ);
        int relativeChunkX = chunkX - this.chunkBottomX;
        int relativeChunkZ = chunkZ - this.chunkBottomZ;
        this.claimedChunks[relativeChunkX][relativeChunkZ] = chunk;
    }

    private void throwIfOutOfBounds(int chunkX, int chunkZ) {
        int relativeChunkX = chunkX - this.chunkBottomX;
        int relativeChunkZ = chunkZ - this.chunkBottomZ;
        if (relativeChunkX < 0 || relativeChunkX >= this.radius * 2 + 1 || relativeChunkZ < 0 || relativeChunkZ >= this.radius * 2 + 1) {
            throw new ChunkNotInClaimException(chunkX, chunkZ);
        }
    }

    private void loadChunksIntoCache() {
        if (VSConfig.showAnnoyingDebugOutput) {
            System.out.println("Loading chunks for " + this.parent.getShipData());
        }
        VSChunkClaim claim = this.parent.getShipData().getChunkClaim();
        claim.forEach((Integer x, Integer z) -> {
            try {
                Chunk chunk = this.world.func_72964_e(x.intValue(), z.intValue());
                if (chunk.func_76621_g() && VSConfig.showAnnoyingDebugOutput) {
                    System.out.println("Why did we put an empty chunk at (" + x + "," + z + ")?");
                }
                if (!this.world.field_72995_K) {
                    PlayerChunkMap map = ((WorldServer)this.world).func_184164_w();
                    PlayerChunkMapEntry entry = map.func_187302_c(x.intValue(), z.intValue());
                    entry.field_187286_f = chunk;
                    entry.field_187290_j = true;
                    entry.field_187283_c = this.parent.getWatchingPlayers();
                }
                chunk.field_150816_i.forEach(this.parent::onSetTileEntity);
                this.setChunkAt((int)x, (int)z, chunk);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void deleteShipChunksFromWorld() {
        PlayerChunkMap map = ((WorldServer)this.world).func_184164_w();
        for (Chunk chunk : this) {
            ArrayList chunkTilesPos = new ArrayList(chunk.field_150816_i.keySet());
            for (BlockPos tilePos : chunkTilesPos) {
                chunk.field_76637_e.func_175713_t(tilePos);
            }
            for (int i = 0; i < 16; ++i) {
                chunk.field_76652_q[i] = null;
            }
            chunk.func_76630_e();
            PlayerChunkMapEntry entry = map.func_187301_b(chunk.field_76635_g, chunk.field_76647_h);
            if (entry == null) {
                throw new IllegalStateException("How did the entry at " + chunk.field_76635_g + " : " + chunk.field_76647_h + " return as null?");
            }
            map.func_187305_b(entry);
        }
    }

    @Override
    @Nonnull
    public Iterator<Chunk> iterator() {
        ArrayList<Chunk> chunksList = new ArrayList<Chunk>();
        Chunk[][] chunkArray = this.claimedChunks;
        int n = chunkArray.length;
        for (int i = 0; i < n; ++i) {
            Chunk[] chunks;
            for (Chunk chunk : chunks = chunkArray[i]) {
                if (chunk == null) continue;
                chunksList.add(chunk);
            }
        }
        return chunksList.iterator();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateChunk(@Nonnull Chunk chunk) {
        this.setChunkAt(chunk.field_76635_g, chunk.field_76647_h, chunk);
    }
}

