/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.block_relocation;

import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;

public abstract class SpatialDetector {
    public static final int maxRange = 512;
    public static final int maxRangeHalved = 256;
    public static final int maxRangeSquared = 262144;
    public final TIntHashSet foundSet = new TIntHashSet(250);
    public final BlockPos firstBlock;
    public final BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
    public final ChunkCache cache;
    public final World worldObj;
    public final int maxSize;
    public final boolean corners;
    public TIntHashSet nextQueue = new TIntHashSet();
    public boolean cleanHouse = false;

    public SpatialDetector(BlockPos start, World worldIn, int maximum, boolean checkCorners) {
        this.firstBlock = start;
        this.worldObj = worldIn;
        this.maxSize = maximum;
        this.corners = checkCorners;
        BlockPos minPos = new BlockPos(start.func_177958_n() - 128, 0, start.func_177952_p() - 128);
        BlockPos maxPos = new BlockPos(start.func_177958_n() + 128, 255, start.func_177952_p() + 128);
        this.cache = new ChunkCache(worldIn, minPos, maxPos, 0);
    }

    public static int getHashWithRespectTo(int realX, int realY, int realZ, BlockPos start) {
        int x = realX - start.func_177958_n() + 256;
        int z = realZ - start.func_177952_p() + 256;
        return realY + 512 * x + 262144 * z;
    }

    public static BlockPos getPosWithRespectTo(int hash, BlockPos start) {
        int y = hash % 512;
        int x = (hash - y) / 512 % 512;
        int z = (hash - x * 512 - y) / 262144;
        return new BlockPos((x -= 256) + start.func_177958_n(), y, (z -= 256) + start.func_177952_p());
    }

    public static void setPosWithRespectTo(int hash, BlockPos start, BlockPos.MutableBlockPos toSet) {
        int y = hash % 512;
        int x = (hash - y) / 512 % 512;
        int z = (hash - x * 512 - y) / 262144;
        toSet.func_181079_c((x -= 256) + start.func_177958_n(), y, (z -= 256) + start.func_177952_p());
    }

    public final void startDetection() {
        this.calculateSpatialOccupation();
        if (this.cleanHouse) {
            this.foundSet.clear();
        }
    }

    public List<BlockPos> getBlockPosArrayList() {
        ArrayList<BlockPos> detectedBlockPos = new ArrayList<BlockPos>(this.foundSet.size());
        for (int hash : this.foundSet) {
            BlockPos fromHash = SpatialDetector.getPosWithRespectTo(hash, this.firstBlock);
            if (fromHash.func_177956_o() + 128 - this.firstBlock.func_177956_o() < 0) {
                System.err.println("I really hope this doesnt happen");
                return new ArrayList<BlockPos>();
            }
            detectedBlockPos.add(fromHash);
        }
        return detectedBlockPos;
    }

    protected void calculateSpatialOccupation() {
        this.nextQueue.add(this.firstBlock.func_177956_o() + 131072 + 0x4000000);
        BlockPos.MutableBlockPos inRealWorld = new BlockPos.MutableBlockPos();
        while (!this.nextQueue.isEmpty() && !this.cleanHouse) {
            TIntIterator queueIter = this.nextQueue.iterator();
            this.foundSet.addAll((TIntCollection)this.nextQueue);
            this.nextQueue = new TIntHashSet();
            while (queueIter.hasNext()) {
                int hash = queueIter.next();
                SpatialDetector.setPosWithRespectTo(hash, this.firstBlock, inRealWorld);
                if (this.corners) {
                    this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p() - 1, hash - 512 - 1 - 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p(), hash - 512 - 1);
                    this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p() + 1, hash - 512 - 1 + 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p() - 1, hash - 512 - 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p(), hash - 512);
                    this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p() + 1, hash - 512 + 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p() - 1, hash - 512 + 1 - 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p(), hash - 512 + 1);
                    this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p() + 1, hash - 512 + 1 + 262144);
                    this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p() - 1, hash - 1 - 262144);
                    this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p(), hash - 1);
                    this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p() + 1, hash - 1 + 262144);
                    this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o(), inRealWorld.func_177952_p() - 1, hash - 262144);
                    this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o(), inRealWorld.func_177952_p() + 1, hash + 262144);
                    this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p() - 1, hash + 1 - 262144);
                    this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p(), hash + 1);
                    this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p() + 1, hash + 1 + 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p() - 1, hash + 512 - 1 - 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p(), hash + 512 - 1);
                    this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p() + 1, hash + 512 - 1 + 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p() - 1, hash + 512 - 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p(), hash + 512);
                    this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p() + 1, hash + 512 + 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p() - 1, hash + 512 + 1 - 262144);
                    this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p(), hash + 512 + 1);
                    this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p() + 1, hash + 512 + 1 + 262144);
                    continue;
                }
                this.tryExpanding(inRealWorld.func_177958_n() + 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p(), hash + 512);
                this.tryExpanding(inRealWorld.func_177958_n() - 1, inRealWorld.func_177956_o(), inRealWorld.func_177952_p(), hash - 512);
                this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o() + 1, inRealWorld.func_177952_p(), hash + 1);
                this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o() - 1, inRealWorld.func_177952_p(), hash - 1);
                this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o(), inRealWorld.func_177952_p() + 1, hash + 262144);
                this.tryExpanding(inRealWorld.func_177958_n(), inRealWorld.func_177956_o(), inRealWorld.func_177952_p() - 1, hash - 262144);
            }
        }
    }

    protected void tryExpanding(int x, int y, int z, int hash) {
        if (this.isValidExpansion(x, y, z) && !this.foundSet.contains(hash) && this.foundSet.size() + this.nextQueue.size() < this.maxSize) {
            this.nextQueue.add(hash);
        }
    }

    public abstract boolean isValidExpansion(int var1, int var2, int var3);
}

