/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships.block_relocation;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.valkyrienskies.mod.common.physics.BlockPhysicsDetails;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.block_relocation.IRelocationAwareTile;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;

public class MoveBlocks {
    public static void copyBlockToPos(World world, BlockPos oldPos, BlockPos newPos, @Nullable PhysicsObject physicsObject) {
        IBlockState oldState = world.func_180495_p(newPos);
        IBlockState newState = world.func_180495_p(oldPos);
        Chunk chunkToSet = world.func_175726_f(newPos);
        int storageIndex = newPos.func_177956_o() >> 4;
        if (storageIndex < 0 || storageIndex >= chunkToSet.field_76652_q.length) {
            return;
        }
        if (chunkToSet.field_76652_q[storageIndex] == Chunk.field_186036_a) {
            chunkToSet.field_76652_q[storageIndex] = new ExtendedBlockStorage(storageIndex << 4, true);
        }
        chunkToSet.field_76652_q[storageIndex].func_177484_a(newPos.func_177958_n() & 0xF, newPos.func_177956_o() & 0xF, newPos.func_177952_p() & 0xF, newState);
        world.func_184138_a(newPos, oldState, newState, 2);
        if (physicsObject != null && BlockPhysicsDetails.isBlockProvidingForce(newState)) {
            physicsObject.getShipData().activeForcePositions.add(newPos);
        }
        MoveBlocks.copyTileEntityToPos(world, oldPos, newPos, physicsObject);
    }

    public static void copyTileEntityToPos(World world, BlockPos oldPos, BlockPos newPos, PhysicsObject physicsObject) {
        TileEntity worldTile = world.func_175625_s(oldPos);
        if (worldTile != null) {
            TileEntity newInstance;
            NBTTagCompound tileEntNBT = new NBTTagCompound();
            if (worldTile instanceof IRelocationAwareTile) {
                ShipData shipData = null;
                if (physicsObject != null) {
                    shipData = physicsObject.getShipData();
                }
                newInstance = ((IRelocationAwareTile)worldTile).createRelocatedTile(newPos, shipData);
            } else {
                tileEntNBT = worldTile.func_189515_b(tileEntNBT);
                tileEntNBT.func_74768_a("x", newPos.func_177958_n());
                tileEntNBT.func_74768_a("y", newPos.func_177956_o());
                tileEntNBT.func_74768_a("z", newPos.func_177952_p());
                newInstance = TileEntity.func_190200_a((World)world, (NBTTagCompound)tileEntNBT);
            }
            try {
                world.func_175690_a(newPos, newInstance);
                if (physicsObject != null) {
                    physicsObject.onSetTileEntity(newPos, newInstance);
                }
                newInstance.func_70296_d();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

