/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.ships;

import com.google.common.collect.ImmutableList;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.resultset.ResultSet;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.deps.com.fasterxml.jackson.annotation.JsonCreator;
import org.valkyrienskies.deps.com.fasterxml.jackson.annotation.JsonProperty;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import org.valkyrienskies.mod.common.util.cqengine.ConcurrentUpdatableIndexedCollection;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableHashIndex;
import org.valkyrienskies.mod.common.util.cqengine.UpdatableUniqueIndex;

@MethodsReturnNonnullByDefault
public class QueryableShipData
implements Iterable<ShipData> {
    private static final Logger log = LogManager.getLogger(QueryableShipData.class);
    private ConcurrentUpdatableIndexedCollection<ShipData> allShips;

    public QueryableShipData() {
        this(new ConcurrentUpdatableIndexedCollection<ShipData>());
    }

    @JsonCreator
    public QueryableShipData(@JsonProperty(value="allShips") ConcurrentUpdatableIndexedCollection<ShipData> ships) {
        if (ships == null) {
            ships = new ConcurrentUpdatableIndexedCollection();
        }
        this.allShips = ships;
        this.allShips.forEach(data -> {
            try {
                Field owner = ShipData.class.getDeclaredField("owner");
                owner.setAccessible(true);
                owner.set(data, this.allShips);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        this.allShips.addIndex(UpdatableHashIndex.onAttribute(ShipData.NAME));
        this.allShips.addIndex(UpdatableUniqueIndex.onAttribute(ShipData.UUID));
        this.allShips.addIndex(UpdatableUniqueIndex.onAttribute(ShipData.CHUNKS));
    }

    public static QueryableShipData get(World world) {
        return ValkyrienUtils.getQueryableData(world);
    }

    @Deprecated
    public ConcurrentUpdatableIndexedCollection<ShipData> getAllShips() {
        return this.allShips;
    }

    public List<ShipData> getShips() {
        return ImmutableList.copyOf(this.allShips);
    }

    public Optional<ShipData> getShipFromChunk(int chunkX, int chunkZ) {
        return this.getShipFromChunk(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
    }

    public Optional<ShipData> getShipFromBlock(BlockPos pos) {
        return this.getShipFromChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public Optional<ShipData> getShipFromChunk(long chunkLong) {
        Equal<ShipData, Long> query = QueryFactory.equal(ShipData.CHUNKS, chunkLong);
        try (ResultSet<ShipData> resultSet = this.allShips.retrieve(query);){
            if (resultSet.size() > 1) {
                throw new IllegalStateException("How the heck did we get 2 or more ships both managing the chunk at " + chunkLong);
            }
            if (resultSet.isEmpty()) {
                Optional<ShipData> optional = Optional.empty();
                return optional;
            }
            Optional<ShipData> optional = Optional.of(resultSet.uniqueResult());
            return optional;
        }
    }

    public Optional<ShipData> getShip(UUID uuid) {
        Equal<ShipData, UUID> query = QueryFactory.equal(ShipData.UUID, uuid);
        try (ResultSet<ShipData> resultSet = this.allShips.retrieve(query);){
            if (resultSet.isEmpty()) {
                Optional<ShipData> optional = Optional.empty();
                return optional;
            }
            Optional<ShipData> optional = Optional.of(resultSet.uniqueResult());
            return optional;
        }
    }

    public Optional<ShipData> getShipFromName(String name) {
        Equal<ShipData, String> query = QueryFactory.equal(ShipData.NAME, name);
        try (ResultSet<ShipData> shipDataResultSet = this.allShips.retrieve(query);){
            if (shipDataResultSet.isEmpty()) {
                Optional<ShipData> optional = Optional.empty();
                return optional;
            }
            Optional<ShipData> optional = Optional.of(shipDataResultSet.uniqueResult());
            return optional;
        }
    }

    public void removeShip(UUID uuid) {
        this.getShip(uuid).ifPresent(ship -> this.allShips.remove(ship));
    }

    public void removeShip(ShipData data) {
        this.allShips.remove(data);
    }

    public void addShip(ShipData ship) {
        if (VSConfig.showAnnoyingDebugOutput) {
            System.out.println(ship.getName());
        }
        this.allShips.add(ship);
    }

    public ShipData addOrUpdateShipPreservingPhysObj(ShipData ship, World world) {
        Optional<ShipData> old = this.getShip(ship.getUuid());
        if (old.isPresent()) {
            PhysicsObject physicsObject = ValkyrienUtils.getPhysObjWorld(world).getPhysObjectFromUUID(ship.getUuid());
            if (physicsObject == null) {
                old.get().setShipTransform(ship.getShipTransform());
                old.get().setPrevTickShipTransform(ship.getPrevTickShipTransform());
                old.get().setShipBB(ship.getShipBB());
            }
            old.get().setPhysicsEnabled(ship.isPhysicsEnabled());
            old.get().getInertiaData().setGameMoITensor(ship.getInertiaData().getGameMoITensor());
            old.get().getInertiaData().setGameTickMass(ship.getInertiaData().getGameTickMass());
            old.get().getInertiaData().setGameTickCenterOfMass(ship.getInertiaData().getGameTickCenterOfMass());
            return old.get();
        }
        this.allShips.add(ship);
        return ship;
    }

    public void registerUpdateListener(BiConsumer<Iterable<ShipData>, Iterable<ShipData>> updateListener) {
        this.allShips.registerUpdateListener(updateListener);
    }

    public void updateShipData(Iterable<ShipData> oldData, Iterable<ShipData> newData) {
        this.allShips.update(oldData, newData);
    }

    public void updateShipData(ShipData oldData, ShipData newData) {
        this.updateShipData(Collections.singleton(oldData), Collections.singleton(newData));
    }

    @Override
    public Iterator<ShipData> iterator() {
        return this.allShips.iterator();
    }

    public Stream<ShipData> stream() {
        return this.allShips.stream();
    }
}

