/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics;

import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.joml.AxisAngle4d;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.block.IBlockForceProvider;
import org.valkyrienskies.mod.common.block.IBlockTorqueProvider;
import org.valkyrienskies.mod.common.collision.WorldPhysicsCollider;
import org.valkyrienskies.mod.common.collision.WorldWaterCollider;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.physics.BlockPhysicsDetails;
import org.valkyrienskies.mod.common.physics.IPhysicsBlockController;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public class PhysicsCalculations {
    public static final double DRAG_CONSTANT = 0.99;
    public static final double EPSILON = 1.0E-8;
    private final PhysicsObject parent;
    private final WorldPhysicsCollider worldCollision;
    private final WorldWaterCollider worldWaterCollider;
    public boolean actAsArchimedes = false;
    private Vector3dc physCenterOfMass;
    private Vector3d torque;
    private Vector3d force;
    private double physTickMass;
    private double physTickTimeDelta;
    private Matrix3dc physMOITensor;
    private Matrix3dc physInvMOITensor;
    private Quaterniondc physRotation;
    private double physX;
    private double physY;
    private double physZ;
    private final Vector3d linearVelocity;
    private final Vector3d angularVelocity;
    private boolean forceToUseGameTransform;

    public PhysicsCalculations(PhysicsObject parent) {
        this.parent = parent;
        this.worldCollision = new WorldPhysicsCollider(this);
        this.worldWaterCollider = new WorldWaterCollider(this);
        this.physMOITensor = null;
        this.physInvMOITensor = null;
        this.linearVelocity = new Vector3d(parent.getPhysicsData().getLinearVelocity());
        this.angularVelocity = new Vector3d(parent.getPhysicsData().getAngularVelocity());
        this.physCenterOfMass = new Vector3d();
        this.torque = new Vector3d();
        this.force = new Vector3d();
        this.forceToUseGameTransform = false;
        this.generatePhysicsTransform();
    }

    public void generatePhysicsTransform() {
        ShipTransform parentTransform = this.getParent().getShipData().getShipTransform();
        this.physRotation = parentTransform.getSubspaceToGlobal().getNormalizedRotation(new Quaterniond());
        this.physX = parentTransform.getPosX();
        this.physY = parentTransform.getPosY();
        this.physZ = parentTransform.getPosZ();
        this.physCenterOfMass = parentTransform.getCenterCoord();
        ShipTransform physicsTransform = new ShipTransform(this.physX, this.physY, this.physZ, this.physRotation, this.physCenterOfMass);
        this.getParent().getShipTransformationManager().setCurrentPhysicsTransform(physicsTransform);
        this.getParent().getShipTransformationManager().updatePreviousPhysicsTransform();
    }

    public void rawPhysTickPreCol(double physTickTimeDelta) {
        this.updatePhysSpeedAndIters(physTickTimeDelta);
        this.updatePhysCenterOfMass();
        this.calculateFramedMOITensor();
        if (!this.parent.isShipAligningToGrid()) {
            if (!this.actAsArchimedes) {
                this.calculateForces();
            } else {
                this.calculateForcesArchimedes();
            }
        } else {
            this.calculateForcesDeconstruction(physTickTimeDelta);
        }
        this.addForceAndTorqueToVelocity();
    }

    private void addForceAndTorqueToVelocity() {
        this.linearVelocity.add(this.force.x() * this.getInvMass(), this.force.y() * this.getInvMass(), this.force.z() * this.getInvMass());
        this.force.zero();
        this.convertTorqueToVelocity();
    }

    public void rawPhysTickPostCol() {
        if (!this.isPhysicsBroken()) {
            this.integrateAngularVelocity();
            this.integrateLinearVelocity();
        } else {
            this.getParent().getShipData().setPhysicsEnabled(false);
            this.getLinearVelocity().zero();
            this.getAngularVelocity().zero();
        }
        boolean forceToUseGameTransformLocalCopy = this.forceToUseGameTransform;
        this.forceToUseGameTransform = false;
        if (forceToUseGameTransformLocalCopy) {
            this.generatePhysicsTransform();
            this.angularVelocity.zero();
            this.linearVelocity.zero();
        }
        ShipTransform finalPhysTransform = new ShipTransform(this.physX, this.physY, this.physZ, this.physRotation, this.physCenterOfMass);
        this.getParent().getShipTransformationManager().updatePreviousPhysicsTransform();
        this.getParent().getShipTransformationManager().setCurrentPhysicsTransform(finalPhysTransform);
        this.getParent().getShipData().getPhysicsData().setAngularVelocity(new Vector3d(this.angularVelocity));
        this.getParent().getShipData().getPhysicsData().setLinearVelocity(new Vector3d(this.linearVelocity));
    }

    private boolean isPhysicsBroken() {
        if (this.getAngularVelocity().lengthSquared() > 50000.0 || this.getLinearVelocity().lengthSquared() > 50000.0 || !this.getAngularVelocity().isFinite() || !this.getLinearVelocity().isFinite()) {
            System.out.println("Ship tried moving too fast; freezing it and reseting velocities");
            return true;
        }
        return false;
    }

    private void updatePhysCenterOfMass() {
        Vector3dc gameTickCM = this.parent.getInertiaData().getGameTickCenterOfMass();
        if (!this.physCenterOfMass.equals(gameTickCM)) {
            Vector3d CMDif = gameTickCM.sub(this.physCenterOfMass, new Vector3d());
            this.getParent().getShipTransformationManager().getCurrentPhysicsTransform().transformDirection(CMDif, TransformType.SUBSPACE_TO_GLOBAL);
            this.physX += CMDif.x;
            this.physY += CMDif.y;
            this.physZ += CMDif.z;
            this.physCenterOfMass = gameTickCM;
        }
    }

    private void calculateFramedMOITensor() {
        this.physTickMass = this.parent.getInertiaData().getGameTickMass();
        Matrix3dc rotationMatrix = this.getParent().getShipTransformationManager().getCurrentPhysicsTransform().createRotationMatrix(TransformType.SUBSPACE_TO_GLOBAL);
        Matrix3dc inertiaBodyFrame = this.parent.getInertiaData().getGameMoITensor();
        Matrix3d rotationMatrixTranspose = rotationMatrix.transpose(new Matrix3d());
        Matrix3d finalInertia = new Matrix3d(rotationMatrix);
        finalInertia.mul(inertiaBodyFrame);
        finalInertia.mul(rotationMatrixTranspose);
        this.physMOITensor = finalInertia;
        this.physInvMOITensor = this.physMOITensor.invert(new Matrix3d());
    }

    private void calculateForces() {
        this.applyAirDrag();
        this.applyGravity();
        Vector3d blockForce = new Vector3d();
        Vector3d inBodyWO = new Vector3d();
        Vector3d crossVector = new Vector3d();
        World worldObj = this.getParent().getWorld();
        if (VSConfig.doPhysicsBlocks) {
            PriorityQueue<IPhysicsBlockController> nodesPriorityQueue = new PriorityQueue<IPhysicsBlockController>(this.parent.getPhysicsControllersInShip());
            while (nodesPriorityQueue.size() > 0) {
                IPhysicsBlockController controller = (IPhysicsBlockController)nodesPriorityQueue.poll();
                controller.onPhysicsTick(this.parent, this, this.getPhysicsTimeDeltaPerPhysTick());
            }
            TreeMap torqueProviders = new TreeMap();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            this.parent.getShipData().activeForcePositions.forEachUnsafe((x, y, z) -> {
                mutablePos.func_181079_c(x, y, z);
                IBlockState state = this.getParent().getChunkAt(mutablePos.func_177958_n() >> 4, mutablePos.func_177952_p() >> 4).func_177435_g((BlockPos)mutablePos);
                Block blockAt = state.func_177230_c();
                if (blockAt instanceof IBlockForceProvider) {
                    try {
                        BlockPhysicsDetails.getForceFromState(state, (BlockPos)mutablePos, worldObj, this.getPhysicsTimeDeltaPerPhysTick(), this.getParent(), blockForce);
                        Vector3dc otherPosition = ((IBlockForceProvider)blockAt).getCustomBlockForcePosition(worldObj, (BlockPos)mutablePos, state, this.getParent(), this.getPhysicsTimeDeltaPerPhysTick());
                        if (otherPosition != null) {
                            inBodyWO.set(otherPosition);
                            inBodyWO.sub(this.physCenterOfMass);
                            this.getParent().getShipTransformationManager().getCurrentPhysicsTransform().transformDirection(inBodyWO, TransformType.SUBSPACE_TO_GLOBAL);
                        } else {
                            inBodyWO.set((double)mutablePos.func_177958_n() + 0.5, (double)mutablePos.func_177956_o() + 0.5, (double)mutablePos.func_177952_p() + 0.5);
                            inBodyWO.sub(this.physCenterOfMass);
                            this.getParent().getShipTransformationManager().getCurrentPhysicsTransform().transformDirection(inBodyWO, TransformType.SUBSPACE_TO_GLOBAL);
                        }
                        this.addForceAtPoint(inBodyWO, blockForce, crossVector);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (blockAt instanceof IBlockTorqueProvider) {
                    IBlockTorqueProvider torqueProviderBlock = (IBlockTorqueProvider)blockAt;
                    if (!torqueProviders.containsKey(torqueProviderBlock)) {
                        torqueProviders.put(torqueProviderBlock, new LinkedList());
                    }
                    ((List)torqueProviders.get(torqueProviderBlock)).add(new BlockPos(x, y, z));
                }
            });
            for (IBlockTorqueProvider torqueProviderBlock : torqueProviders.keySet()) {
                List blockPositions = (List)torqueProviders.get(torqueProviderBlock);
                for (BlockPos pos : blockPositions) {
                    this.convertTorqueToVelocity();
                    Vector3dc torqueVector = torqueProviderBlock.getTorqueInGlobal(this, pos);
                    if (torqueVector == null) continue;
                    this.torque.add(torqueVector);
                }
            }
        }
        this.convertTorqueToVelocity();
    }

    private void applyGravity() {
        if (VSConfig.doGravity) {
            this.addForceAtPoint(new Vector3d(), VSConfig.gravity().mul(this.physTickMass * this.getPhysicsTimeDeltaPerPhysTick(), new Vector3d()));
        }
    }

    private void calculateForcesArchimedes() {
        this.applyAirDrag();
    }

    private void calculateForcesDeconstruction(double physTickTimeDelta) {
        this.applyAirDrag();
        Quaterniond inverseCurrentRotation = this.parent.getShipTransformationManager().getCurrentPhysicsTransform().rotationQuaternion(TransformType.GLOBAL_TO_SUBSPACE);
        AxisAngle4d idealAxisAngle = new AxisAngle4d(inverseCurrentRotation);
        if (idealAxisAngle.angle < 1.0E-8) {
            return;
        }
        idealAxisAngle.normalize();
        double angleBetweenIdealAndActual = idealAxisAngle.angle;
        if (angleBetweenIdealAndActual > Math.PI) {
            angleBetweenIdealAndActual = Math.PI * 2 - angleBetweenIdealAndActual;
        }
        double timeStep = 1.0;
        double idealAngularVelocityMultiple = angleBetweenIdealAndActual / timeStep;
        Vector3d idealAngularVelocity = new Vector3d(idealAxisAngle.x, idealAxisAngle.y, idealAxisAngle.z);
        idealAngularVelocity.mul(idealAngularVelocityMultiple);
        Vector3d angularVelocityDif = idealAngularVelocity.sub(this.getAngularVelocity(), new Vector3d());
        angularVelocityDif.mul(physTickTimeDelta);
        this.getAngularVelocity().add(angularVelocityDif);
    }

    private void applyAirDrag() {
        double drag = this.getDragForPhysTick();
        this.getLinearVelocity().mul(drag);
        this.getAngularVelocity().mul(drag);
    }

    private void convertTorqueToVelocity() {
        Vector3d torqueTransformed = new Vector3d(this.torque);
        this.getPhysInvMOITensor().transform(torqueTransformed);
        this.getAngularVelocity().add(torqueTransformed.x, torqueTransformed.y, torqueTransformed.z);
        this.torque.zero();
    }

    @Deprecated
    public void addForceAtPoint(Vector3dc inBodyWO, Vector3dc forceToApply) {
        this.addForceAtPoint(inBodyWO, forceToApply, new Vector3d());
    }

    @Deprecated
    public void addForceAtPoint(Vector3dc inBodyWO, Vector3dc forceToApply, Vector3d crossVector) {
        inBodyWO.cross(forceToApply, crossVector);
        this.torque.add(crossVector);
        this.force.add(forceToApply);
    }

    public void addForceAtPointNew(Vector3dc posRelToShipCenter, Vector3dc forceToApply, Vector3d tempStorage) {
        double timeStep = this.getPhysicsTimeDeltaPerPhysTick();
        posRelToShipCenter.cross(forceToApply, tempStorage);
        this.torque.add(tempStorage.x() * timeStep, tempStorage.y() * timeStep, tempStorage.z() * timeStep);
        this.force.add(forceToApply.x() * timeStep, forceToApply.y() * timeStep, forceToApply.z() * timeStep);
    }

    private void updatePhysSpeedAndIters(double newPhysSpeed) {
        this.physTickTimeDelta = newPhysSpeed;
    }

    private void integrateAngularVelocity() {
        Vector3d angularVelocity = this.getAngularVelocity();
        if (angularVelocity.lengthSquared() < 0.001) {
            return;
        }
        Vector3d angularVelInBody = new Vector3d(angularVelocity);
        AxisAngle4d axisAngle4d = new AxisAngle4d(angularVelInBody.length() * this.getPhysicsTimeDeltaPerPhysTick(), angularVelInBody.x(), angularVelInBody.y(), angularVelInBody.z());
        axisAngle4d.normalize();
        Quaterniond rotationQuat = new Quaterniond(axisAngle4d);
        this.physRotation = this.physRotation.premul(rotationQuat, new Quaterniond()).normalize();
    }

    private void integrateLinearVelocity() {
        this.linearVelocity.add(this.force.x() * this.getInvMass(), this.force.y() * this.getInvMass(), this.force.z() * this.getInvMass());
        this.force.zero();
        this.physX += this.getLinearVelocity().x() * this.getPhysicsTimeDeltaPerPhysTick();
        this.physY += this.getLinearVelocity().y() * this.getPhysicsTimeDeltaPerPhysTick();
        this.physZ += this.getLinearVelocity().z() * this.getPhysicsTimeDeltaPerPhysTick();
        this.physY = Math.min(Math.max(this.physY, VSConfig.shipLowerLimit), VSConfig.shipUpperLimit);
    }

    @Deprecated
    public Vector3d getVelocityAtPoint(Vector3dc posRelativeToShipCenter) {
        Vector3d speed = this.getAngularVelocity().cross(posRelativeToShipCenter, new Vector3d());
        speed.x += this.getLinearVelocity().x();
        speed.y += this.getLinearVelocity().y();
        speed.z += this.getLinearVelocity().z();
        return speed;
    }

    public Vector3d getVelocityAtPoint(Vector3dc posRelativeToShipCenter, Vector3d dest) {
        Vector3d velocityAtPoint = this.getAngularVelocity().cross(posRelativeToShipCenter, dest);
        velocityAtPoint.add(this.getLinearVelocity());
        return velocityAtPoint;
    }

    public double getMass() {
        return this.physTickMass;
    }

    public double getInvMass() {
        return 1.0 / this.physTickMass;
    }

    public double getPhysicsTimeDeltaPerPhysTick() {
        return this.physTickTimeDelta;
    }

    public double getDragForPhysTick() {
        return Math.pow(0.99, this.getPhysicsTimeDeltaPerPhysTick() * 20.0);
    }

    public Matrix3dc getPhysInvMOITensor() {
        return this.physInvMOITensor;
    }

    private void setPhysInvMOITensor(Matrix3dc physInvMOITensor) {
        this.physInvMOITensor = physInvMOITensor;
    }

    public Matrix3dc getPhysMOITensor() {
        return this.physMOITensor;
    }

    public PhysicsObject getParent() {
        return this.parent;
    }

    public WorldPhysicsCollider getWorldCollision() {
        return this.worldCollision;
    }

    public double getInertiaAlongRotationAxis() {
        Vector3d rotationAxis = new Vector3d(this.getAngularVelocity());
        rotationAxis.normalize();
        this.getPhysMOITensor().transform(rotationAxis);
        return rotationAxis.length();
    }

    public void addForceAndTorque(Vector3dc addedForce, Vector3dc addedTorque) {
        double timeStep = this.getPhysicsTimeDeltaPerPhysTick();
        this.force.add(addedForce.x() * timeStep, addedForce.y() * timeStep, addedForce.z() * timeStep);
        this.torque.add(addedTorque.x() * timeStep, addedTorque.y() * timeStep, addedTorque.z() * timeStep);
    }

    public Vector3dc getPhysCenterOfMass() {
        return this.physCenterOfMass;
    }

    public WorldWaterCollider getWorldWaterCollider() {
        return this.worldWaterCollider;
    }

    public Vector3d getLinearVelocity() {
        return this.linearVelocity;
    }

    public Vector3d getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setForceToUseGameTransform(boolean forceToUseGameTransform) {
        this.forceToUseGameTransform = forceToUseGameTransform;
    }
}

