/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonProcessingException;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ObjectMapper;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.util.jackson.VSJacksonUtil;

public class ShipTransformUpdateMessage
implements IMessage {
    private static final ObjectMapper serializer = VSJacksonUtil.getPacketMapper();
    final Map<UUID, Tuple<ShipTransform, AxisAlignedBB>> shipTransforms = new HashMap<UUID, Tuple<ShipTransform, AxisAlignedBB>>();
    int dimensionID = -1;

    public void addData(UUID shipUUID, ShipTransform shipTransform, AxisAlignedBB alignedBB) {
        this.shipTransforms.put(shipUUID, (Tuple<ShipTransform, AxisAlignedBB>)new Tuple((Object)shipTransform, (Object)alignedBB));
    }

    public void setDimensionID(int dimensionID) {
        this.dimensionID = dimensionID;
    }

    public int getDimensionID() {
        return this.dimensionID;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        int numberOfShips = packetBuffer.readInt();
        for (int i = 0; i < numberOfShips; ++i) {
            UUID shipID = null;
            ShipTransform shipTransform = null;
            AxisAlignedBB axisAlignedBB = null;
            int bytesSize = packetBuffer.readInt();
            byte[] bytes = new byte[bytesSize];
            packetBuffer.readBytes(bytes);
            try {
                shipID = serializer.readValue(bytes, UUID.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bytesSize = packetBuffer.readInt();
            bytes = new byte[bytesSize];
            packetBuffer.readBytes(bytes);
            try {
                shipTransform = serializer.readValue(bytes, ShipTransform.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bytesSize = packetBuffer.readInt();
            bytes = new byte[bytesSize];
            packetBuffer.readBytes(bytes);
            try {
                axisAlignedBB = serializer.readValue(bytes, AxisAlignedBB.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (shipID == null || shipTransform == null || axisAlignedBB == null) {
                this.shipTransforms.clear();
                return;
            }
            this.shipTransforms.put(shipID, (Tuple<ShipTransform, AxisAlignedBB>)new Tuple((Object)shipTransform, (Object)axisAlignedBB));
        }
        this.dimensionID = packetBuffer.readInt();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.writeInt(this.shipTransforms.size());
        for (Map.Entry<UUID, Tuple<ShipTransform, AxisAlignedBB>> data : this.shipTransforms.entrySet()) {
            try {
                byte[] dataBytes = serializer.writeValueAsBytes(data.getKey());
                int bytesSize = dataBytes.length;
                packetBuffer.writeInt(bytesSize);
                packetBuffer.writeBytes(dataBytes);
                dataBytes = serializer.writeValueAsBytes(data.getValue().func_76341_a());
                bytesSize = dataBytes.length;
                packetBuffer.writeInt(bytesSize);
                packetBuffer.writeBytes(dataBytes);
                dataBytes = serializer.writeValueAsBytes(data.getValue().func_76340_b());
                bytesSize = dataBytes.length;
                packetBuffer.writeInt(bytesSize);
                packetBuffer.writeBytes(dataBytes);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        packetBuffer.writeInt(this.dimensionID);
    }
}

