/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command.framework;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class VSCommandUtil {
    public static String[] toTabCompleteArgs(String[] args) {
        ArrayList<String> properArgs = VSCommandUtil.translateCommandline(String.join((CharSequence)" ", args));
        if (args[args.length - 1].equals("")) {
            properArgs.add("");
        }
        return properArgs.toArray(new String[0]);
    }

    public static String[] toProperArgs(String[] args) {
        return VSCommandUtil.toProperArgs(String.join((CharSequence)" ", args));
    }

    public static String[] toProperArgs(String args) {
        return VSCommandUtil.translateCommandline(args).toArray(new String[0]);
    }

    private static ArrayList<String> translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new ArrayList<String>();
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new RuntimeException("unbalanced quotes in " + toProcess);
        }
        return result;
    }
}

