/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import net.minecraft.command.ICommandSender;
import org.valkyrienskies.mod.common.config.VSConfig;
import picocli.CommandLine;

public class VSCommandFactory
implements CommandLine.IFactory {
    private ICommandSender sender;

    VSCommandFactory(ICommandSender sender) {
        this.sender = sender;
    }

    @Override
    public <K> K create(Class<K> aClass) {
        try {
            K instance;
            if (VSConfig.showAnnoyingDebugOutput) {
                System.out.println("PicoCLI is instantiating " + aClass.getName());
            }
            try {
                Constructor<K> constructor = aClass.getDeclaredConstructor(ICommandSender.class);
                constructor.setAccessible(true);
                instance = constructor.newInstance(this.sender);
            }
            catch (NoSuchMethodException ex) {
                Constructor<K> constructor = aClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                instance = constructor.newInstance(new Object[0]);
            }
            for (Field field : aClass.getDeclaredFields()) {
                if (!ICommandSender.class.isAssignableFrom(field.getType()) || field.getAnnotation(Inject.class) == null) continue;
                field.setAccessible(true);
                field.set(instance, this.sender);
            }
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Unable to initialize %s!", aClass.getCanonicalName()), e);
        }
    }
}

