/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command;

import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.command.autocompleters.ShipNameAutocompleter;
import org.valkyrienskies.mod.common.command.autocompleters.WorldAutocompleter;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import org.valkyrienskies.mod.common.ships.QueryableShipData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.IHasShipManager;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.ships.ship_world.WorldServerShipManager;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import org.valkyrienskies.mod.common.util.multithreaded.VSWorldPhysicsLoop;
import picocli.CommandLine;

@CommandLine.Command(name="valkyrienskies", aliases={"vs"}, synopsisSubcommandLabel="COMMAND", mixinStandardHelpOptions=true, usageHelpWidth=55, subcommands={CommandLine.HelpCommand.class, ListShips.class, DisableShip.class, GC.class, TPS.class, TeleportTo.class, DeconstructShip.class, DeleteShip.class, TeleportShipTo.class, TeleportShipHere.class})
public class MainCommand
implements Runnable {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @Inject
    private ICommandSender sender;

    @Override
    public void run() {
        String usageMessage = this.spec.commandLine().getUsageMessage().replace("\r", "");
        this.sender.func_145747_a((ITextComponent)new TextComponentString(usageMessage));
    }

    private static void deletePhyso(ICommandSender sender, ShipData shipData, PhysicsObject.DeconstructState state) {
        WorldServerShipManager world = ValkyrienUtils.getServerShipManager(sender.func_130014_f_());
        PhysicsObject obj = world.getPhysObjectFromUUID(shipData.getUuid());
        if (obj != null) {
            obj.setDeconstructState(state);
            switch (state) {
                case DECONSTRUCT_NORMAL: {
                    sender.func_145747_a((ITextComponent)new TextComponentString("That ship is being deconstructed"));
                    break;
                }
                case DECONSTRUCT_IMMEDIATE_NO_COPY: {
                    sender.func_145747_a((ITextComponent)new TextComponentString("That ship will be deleted in the next tick."));
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("That ship is not loaded"));
        }
    }

    private static void teleportShipToPosition(ShipData ship, Vec3d position, ICommandSender sender) {
        try {
            World world = sender.func_130014_f_();
            WorldServerShipManager shipManager = ValkyrienUtils.getServerShipManager(world);
            PhysicsObject shipObject = shipManager.getPhysObjectFromUUID(ship.getUuid());
            ShipTransform shipTransform = ship.getShipTransform();
            ShipTransform newTransform = new ShipTransform(JOML.convert(position), shipTransform.getCenterCoord());
            if (shipObject != null) {
                PhysicsCalculations physicsCalculations = shipObject.getPhysicsCalculations();
                physicsCalculations.setForceToUseGameTransform(true);
                shipObject.setForceToUseShipDataTransform(true);
                shipObject.setTicksSinceShipTeleport(0);
            }
            ship.setPhysicsEnabled(false);
            ship.setPrevTickShipTransform(newTransform);
            ship.setShipTransform(newTransform);
            System.out.println(String.format("Teleporting ship %s to %s", ship.getName(), position.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @CommandLine.Command(name="teleport-ship-here", aliases={"tp-ship-here"}, customSynopsis={"/tp-ship-here ship-name"})
    static class TeleportShipHere
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Parameters(paramLabel="name", index="0", completionCandidates=ShipNameAutocompleter.class)
        ShipData shipData;

        TeleportShipHere() {
        }

        @Override
        public void run() {
            Vec3d commandPosition = this.sender.func_174791_d();
            if (commandPosition == Vec3d.field_186680_a) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString("The command sender doesn't have a position, ignoring the command."));
                return;
            }
            MainCommand.teleportShipToPosition(this.shipData, commandPosition, this.sender);
        }
    }

    @CommandLine.Command(name="teleport-ship-to", aliases={"tp-ship-to"}, customSynopsis={"/tp-ship-to ship-name <x,y,z>"})
    static class TeleportShipTo
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Parameters(paramLabel="name", index="0", completionCandidates=ShipNameAutocompleter.class)
        ShipData shipData;
        @CommandLine.Parameters(paramLabel="position", index="1")
        Vec3d position;

        TeleportShipTo() {
        }

        @Override
        public void run() {
            MainCommand.teleportShipToPosition(this.shipData, this.position, this.sender);
        }
    }

    @CommandLine.Command(name="list-ships", aliases={"ls"})
    static class ListShips
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Option(names={"-v", "--verbose"})
        boolean verbose;

        ListShips() {
        }

        @Override
        public void run() {
            World world = this.sender.func_130014_f_();
            QueryableShipData data = ValkyrienUtils.getQueryableData(world);
            if (data.getShips().size() == 0) {
                this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.vs.list-ships.noships", new Object[0]));
                return;
            }
            String listOfShips = this.verbose ? data.getShips().stream().map(shipData -> {
                if (shipData.getShipTransform() == null) {
                    return String.format("%s, Unknown Location", shipData.getName());
                }
                return String.format("%s [%.1f, %.1f, %.1f]", shipData.getName(), shipData.getShipTransform().getPosX(), shipData.getShipTransform().getPosY(), shipData.getShipTransform().getPosZ());
            }).collect(Collectors.joining(",\n")) : data.getShips().stream().map(ShipData::getName).collect(Collectors.joining(",\n"));
            this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.vs.list-ships.ships", new Object[]{listOfShips}));
        }
    }

    @CommandLine.Command(name="ship-physics")
    static class DisableShip
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;
        @CommandLine.Parameters(paramLabel="name", index="0", completionCandidates=ShipNameAutocompleter.class)
        ShipData shipData;
        @CommandLine.Parameters(index="1", arity="0..1")
        boolean enabled;

        DisableShip() {
        }

        @Override
        public void run() {
            String physicsState;
            boolean enabledWasSpecified = this.spec.commandLine().getParseResult().hasMatchedPositional(1);
            boolean isPhysicsEnabled = this.shipData.isPhysicsEnabled();
            String string = physicsState = isPhysicsEnabled ? "enabled" : "disabled";
            if (enabledWasSpecified) {
                this.shipData.setPhysicsEnabled(this.enabled);
                if (isPhysicsEnabled == this.enabled) {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString("That ship's physics were not changed from " + physicsState));
                } else {
                    String newPhysicsState = this.enabled ? "enabled" : "disabled";
                    this.sender.func_145747_a((ITextComponent)new TextComponentString("That ship's physics were changed from " + physicsState + " to " + newPhysicsState));
                }
            } else {
                this.sender.func_145747_a((ITextComponent)new TextComponentString("That ship's physics are: " + physicsState));
            }
        }
    }

    @CommandLine.Command(name="tps")
    static class TPS
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Option(names={"--world", "-w"}, completionCandidates=WorldAutocompleter.class)
        World world;

        TPS() {
        }

        @Override
        public void run() {
            VSWorldPhysicsLoop worldPhysicsThread;
            if (this.world == null) {
                this.world = this.sender.func_130014_f_();
            }
            if ((worldPhysicsThread = ((WorldServerShipManager)((IHasShipManager)this.world).getManager()).getPhysicsLoop()) != null) {
                long averagePhysTickTimeNano = worldPhysicsThread.getAveragePhysicsTickTimeNano();
                double ticksPerSecond = 1.0E9 / (double)averagePhysTickTimeNano;
                double ticksPerSecondTwoDecimals = Math.floor(ticksPerSecond * 100.0) / 100.0;
                this.sender.func_145747_a((ITextComponent)new TextComponentString("Player world: " + ticksPerSecondTwoDecimals + " physics ticks per second"));
            }
        }
    }

    @CommandLine.Command(name="gc")
    static class GC
    implements Runnable {
        @Inject
        ICommandSender sender;

        GC() {
        }

        @Override
        public void run() {
            System.gc();
            this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.vs.gc.success", new Object[0]));
        }
    }

    @CommandLine.Command(name="teleport-to", aliases={"tpto"})
    static class TeleportTo
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Parameters(paramLabel="name", index="0", completionCandidates=ShipNameAutocompleter.class)
        ShipData shipData;

        TeleportTo() {
        }

        @Override
        public void run() {
            if (!(this.sender instanceof EntityPlayer)) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString("You must execute this command as a player!"));
            }
            ShipTransform pos = this.shipData.getShipTransform();
            ((EntityPlayer)this.sender).func_70634_a(pos.getPosX(), pos.getPosY(), pos.getPosZ());
        }
    }

    @CommandLine.Command(name="delete-ship", aliases={"delete"})
    static class DeleteShip
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Parameters(paramLabel="name", index="0", completionCandidates=ShipNameAutocompleter.class)
        ShipData shipData;

        DeleteShip() {
        }

        @Override
        public void run() {
            MainCommand.deletePhyso(this.sender, this.shipData, PhysicsObject.DeconstructState.DECONSTRUCT_IMMEDIATE_NO_COPY);
        }
    }

    @CommandLine.Command(name="deconstruct-ship", aliases={"deconstruct"})
    static class DeconstructShip
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Parameters(paramLabel="name", index="0", completionCandidates=ShipNameAutocompleter.class)
        ShipData shipData;

        DeconstructShip() {
        }

        @Override
        public void run() {
            MainCommand.deletePhyso(this.sender, this.shipData, PhysicsObject.DeconstructState.DECONSTRUCT_NORMAL);
        }
    }
}

