/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.collision;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Consumer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.collision.WaterForcesTask;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import org.valkyrienskies.mod.common.ships.block_relocation.SpatialDetector;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.datastructures.IBitOctree;
import org.valkyrienskies.mod.common.util.datastructures.ITerrainOctreeProvider;
import valkyrienwarfare.api.TransformType;

public class WorldWaterCollider {
    private static final double AABB_EXPANSION = 2.0;
    private static final double RANGE_CHECK = 2.0;
    private static final double CACHE_UPDATE_PERIOD = 0.1;
    private static final int MAX_HITS_PER_TASK = 500;
    private final PhysicsCalculations calculator;
    private final PhysicsObject parent;
    private final TIntList cachedPotentialHits;
    private double secondsSinceCollisionCacheUpdate;
    private BlockPos centerPotentialHit;

    public WorldWaterCollider(PhysicsCalculations calculations) {
        this.calculator = calculations;
        this.parent = calculations.getParent();
        this.cachedPotentialHits = new TIntArrayList();
        this.secondsSinceCollisionCacheUpdate = 2500.0;
        this.centerPotentialHit = null;
    }

    public void tickUpdatingTheCollisionCache() {
        this.secondsSinceCollisionCacheUpdate += this.calculator.getPhysicsTimeDeltaPerPhysTick();
        if (this.secondsSinceCollisionCacheUpdate > 0.1) {
            this.updatePotentialCollisionCache();
        }
    }

    public List<WaterForcesTask> generateWaterForceTasks() {
        ArrayList<WaterForcesTask> waterForcesTasks = new ArrayList<WaterForcesTask>();
        for (int i = 0; i < this.cachedPotentialHits.size(); i += 500) {
            int minHitIndex = i;
            int maxHitIndex = Math.min(minHitIndex + 500, this.cachedPotentialHits.size() - 1);
            WaterForcesTask waterForcesTask = new WaterForcesTask(this.parent, this.centerPotentialHit, this.cachedPotentialHits, minHitIndex, maxHitIndex);
            waterForcesTasks.add(waterForcesTask);
        }
        return waterForcesTasks;
    }

    private void updatePotentialCollisionCache() {
        this.secondsSinceCollisionCacheUpdate = 0.0;
        if (Math.random() > 0.5) {
            this.secondsSinceCollisionCacheUpdate -= 0.01;
        }
        this.cachedPotentialHits.clear();
        AxisAlignedBB shipBBOriginal = this.parent.getPhysicsTransformAABB();
        if (shipBBOriginal == null) {
            return;
        }
        AxisAlignedBB shipBB = shipBBOriginal.func_186662_g(3.0);
        AxisAlignedBB collisionBB = shipBB.func_186662_g(2.0).func_186662_g(2.0 * Math.ceil(2.0));
        if (collisionBB.field_72337_e < 0.0 || collisionBB.field_72338_b > 255.0) {
            return;
        }
        BlockPos min = new BlockPos(collisionBB.field_72340_a, Math.max(collisionBB.field_72338_b - 1.0, 0.0), collisionBB.field_72339_c);
        BlockPos max = new BlockPos(collisionBB.field_72336_d, Math.min(collisionBB.field_72337_e, 255.0), collisionBB.field_72334_f);
        this.centerPotentialHit = new BlockPos((double)(min.func_177958_n() + max.func_177958_n()) / 2.0, (double)(min.func_177956_o() + max.func_177956_o()) / 2.0, (double)(min.func_177952_p() + max.func_177952_p()) / 2.0);
        ChunkCache cache = this.parent.getCachedSurroundingChunks();
        if (cache == null) {
            System.err.println("VS Cached Surrounding Chunks was null! This is going to cause catastophric terrible events!!");
            return;
        }
        int chunkMinX = min.func_177958_n() >> 4;
        int chunkMaxX = (max.func_177958_n() >> 4) + 1;
        int chunkMinZ = min.func_177952_p() >> 4;
        int chunkMaxZ = (max.func_177952_p() >> 4) + 1;
        int minX = min.func_177958_n();
        int minY = min.func_177956_o();
        int minZ = min.func_177952_p();
        int maxX = max.func_177958_n();
        int maxY = max.func_177956_o();
        int maxZ = max.func_177952_p();
        if (VSConfig.MULTITHREADING_SETTINGS.multithreadCollisionCacheUpdate && this.parent.getBlockPositions().size() > 100) {
            ArrayList<ImmutableTriple> tasks = new ArrayList<ImmutableTriple>();
            for (int chunkX = chunkMinX; chunkX < chunkMaxX; ++chunkX) {
                for (int chunkZ = chunkMinZ; chunkZ < chunkMaxZ; ++chunkZ) {
                    tasks.add(new ImmutableTriple((Object)chunkX, (Object)chunkZ, (Object)new TIntArrayList()));
                }
            }
            Consumer<Triple> consumer = i -> this.updateCollisionCacheSequential(cache, (Integer)i.getLeft(), (Integer)i.getMiddle(), minX, minY, minZ, maxX, maxY, maxZ, shipBB, (TIntList)i.getRight());
            ((ForkJoinTask)ValkyrienSkiesMod.getPhysicsThreadPool().submit(() -> tasks.parallelStream().forEach(consumer))).join();
            tasks.forEach(task -> this.cachedPotentialHits.addAll((TIntCollection)task.getRight()));
        } else {
            double size = (double)(chunkMaxX - chunkMinX) * (double)(chunkMaxZ - chunkMinZ);
            if (size > 300000.0) {
                return;
            }
            for (int chunkX = chunkMinX; chunkX < chunkMaxX; ++chunkX) {
                for (int chunkZ = chunkMinZ; chunkZ < chunkMaxZ; ++chunkZ) {
                    this.updateCollisionCacheSequential(cache, chunkX, chunkZ, minX, minY, minZ, maxX, maxY, maxZ, shipBB, this.cachedPotentialHits);
                }
            }
        }
    }

    private void updateCollisionCacheSequential(ChunkCache cache, int chunkX, int chunkZ, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, AxisAlignedBB shipBB, TIntList output) {
        int arrayChunkX = chunkX - cache.field_72818_a;
        int arrayChunkZ = chunkZ - cache.field_72816_b;
        if (arrayChunkX >= 0 && arrayChunkZ >= 0 && arrayChunkX <= cache.field_72817_c.length - 1 && arrayChunkZ <= cache.field_72817_c[0].length - 1 && cache.field_72817_c[arrayChunkX][arrayChunkZ] != null) {
            Vector3d temp1 = new Vector3d();
            Vector3d temp2 = new Vector3d();
            Chunk chunk = cache.field_72817_c[arrayChunkX][arrayChunkZ];
            for (int storageY = minY >> 4; storageY <= maxY >> 4; ++storageY) {
                ExtendedBlockStorage extendedblockstorage = chunk.field_76652_q[storageY];
                if (extendedblockstorage == null) continue;
                int minStorageX = chunkX << 4;
                int minStorageY = storageY << 4;
                int minStorageZ = chunkZ << 4;
                int maxStorageX = minStorageX + 15;
                int maxStorageY = Math.min(maxY, minStorageY + 15);
                int maxStorageZ = minStorageZ + 15;
                ITerrainOctreeProvider provider = (ITerrainOctreeProvider)extendedblockstorage.field_177488_d;
                IBitOctree octree = provider.getLiquidOctree();
                for (int x = minStorageX; x <= maxStorageX; ++x) {
                    for (int y = minStorageY; y <= maxStorageY; ++y) {
                        for (int z = minStorageZ; z <= maxStorageZ; ++z) {
                            this.checkIfCollidesWithinRangeCheckRadius(x, y, z, octree, temp1, temp2, shipBB, output);
                        }
                    }
                }
            }
        }
    }

    private void checkIfCollidesWithinRangeCheckRadius(int x, int y, int z, IBitOctree octree, Vector3d inLocal, Vector3d inBody, AxisAlignedBB shipBB, TIntList output) {
        if (octree.get(x & 0xF, y & 0xF, z & 0xF)) {
            inLocal.x = (double)x + 0.5;
            inLocal.y = (double)y + 0.5;
            inLocal.z = (double)z + 0.5;
            if (inLocal.x > shipBB.field_72340_a && inLocal.x < shipBB.field_72336_d && inLocal.y > shipBB.field_72338_b && inLocal.y < shipBB.field_72337_e && inLocal.z > shipBB.field_72339_c && inLocal.z < shipBB.field_72334_f) {
                this.parent.getShipTransformationManager().getCurrentPhysicsTransform().transformPosition(inLocal, TransformType.GLOBAL_TO_SUBSPACE);
                inLocal.sub(this.parent.getCenterCoord(), inBody);
                int minX = MathHelper.func_76128_c((double)(inLocal.x - 2.0));
                int maxX = MathHelper.func_76128_c((double)(inLocal.x + 2.0));
                int minY = MathHelper.func_76128_c((double)(inLocal.y - 2.0));
                int maxY = MathHelper.func_76128_c((double)(inLocal.y + 2.0));
                int minZ = MathHelper.func_76128_c((double)(inLocal.z - 2.0));
                int maxZ = MathHelper.func_76128_c((double)(inLocal.z + 2.0));
                minY = Math.min(255, Math.max(minY, 0));
                maxY = Math.min(255, Math.max(maxY, 0));
                Chunk chunkIn00 = this.parent.getChunkClaim().containsChunk(minX >> 4, minZ >> 4) ? this.parent.getChunkAt(minX >> 4, minZ >> 4) : null;
                Chunk chunkIn01 = this.parent.getChunkClaim().containsChunk(minX >> 4, maxZ >> 4) ? this.parent.getChunkAt(minX >> 4, maxZ >> 4) : null;
                Chunk chunkIn10 = this.parent.getChunkClaim().containsChunk(maxX >> 4, minZ >> 4) ? this.parent.getChunkAt(maxX >> 4, minZ >> 4) : null;
                Chunk chunkIn11 = this.parent.getChunkClaim().containsChunk(maxX >> 4, maxZ >> 4) ? this.parent.getChunkAt(maxX >> 4, maxZ >> 4) : null;
                block0: for (int localX = minX; localX < maxX; ++localX) {
                    for (int localZ = minZ; localZ < maxZ; ++localZ) {
                        Chunk theChunk = localX >> 4 == minX >> 4 ? (localZ >> 4 == minZ >> 4 ? chunkIn00 : chunkIn01) : (localZ >> 4 == minZ >> 4 ? chunkIn10 : chunkIn11);
                        if (theChunk == null) continue;
                        for (int localY = minY; localY < maxY; ++localY) {
                            boolean result = this.checkForCollisionFast(theChunk, localX, localY, localZ, x, y, z, output);
                            if (result) break block0;
                        }
                    }
                }
            }
        }
    }

    private boolean checkForCollisionFast(Chunk chunk, int localX, int localY, int localZ, int x, int y, int z, TIntList output) {
        ITerrainOctreeProvider provider;
        IBitOctree octreeInLocal;
        if (chunk.field_76652_q[localY >> 4] != null && (octreeInLocal = (provider = (ITerrainOctreeProvider)chunk.field_76652_q[localY >> 4].func_186049_g()).getSolidOctree()).get(localX & 0xF, localY & 0xF, localZ & 0xF)) {
            int hash = SpatialDetector.getHashWithRespectTo(x, y, z, this.centerPotentialHit);
            output.add(hash);
            return true;
        }
        return false;
    }
}

