/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.collision;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.AxisAlignedBB;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import valkyrienwarfare.api.TransformType;

public class Polygon {
    private final Vector3dc[] vertices;
    private AxisAlignedBB enclosedBBCache;

    public Polygon(@Nonnull AxisAlignedBB bb, @Nullable ShipTransform transformation, @Nullable TransformType transformType) {
        Vector3d[] verticesMutable = Polygon.getCornersForAABB(bb);
        if (transformation != null && transformType != null) {
            Polygon.transform(verticesMutable, transformation, transformType);
        }
        this.vertices = verticesMutable;
        this.enclosedBBCache = null;
    }

    public Polygon(@Nonnull AxisAlignedBB bb) {
        this(bb, null, null);
    }

    public Polygon(@Nonnull AxisAlignedBB aabb, @Nonnull Matrix4dc transform) {
        Vector3d[] verticesMutable = Polygon.getCornersForAABB(aabb);
        Polygon.transform(verticesMutable, transform);
        this.vertices = verticesMutable;
    }

    public static Vector3d[] generateAxisAlignedNorms() {
        return new Vector3d[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, 1.0)};
    }

    private static Vector3d[] getCornersForAABB(AxisAlignedBB bb) {
        return new Vector3d[]{new Vector3d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), new Vector3d(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c), new Vector3d(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f), new Vector3d(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f), new Vector3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), new Vector3d(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c), new Vector3d(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f), new Vector3d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f)};
    }

    public double[] getProjectionOnVector(Vector3dc axis) {
        double[] distances = new double[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            distances[i] = axis.dot(this.vertices[i]);
        }
        return distances;
    }

    public Vector3d getCenter() {
        Vector3d center = new Vector3d();
        for (Vector3dc v : this.vertices) {
            center.add(v);
        }
        center.mul(1.0 / (double)this.vertices.length);
        return center;
    }

    private static void transform(Vector3d[] vertices, ShipTransform transformation, TransformType transformType) {
        for (Vector3d vertex : vertices) {
            transformation.transformPosition(vertex, transformType);
        }
    }

    private static void transform(Vector3d[] vertices, Matrix4dc transform) {
        for (Vector3d vertex : vertices) {
            transform.transformPosition(vertex);
        }
    }

    public AxisAlignedBB getEnclosedAABB() {
        if (this.enclosedBBCache == null) {
            Vector3dc firstVertex = this.vertices[0];
            double mnX = firstVertex.x();
            double mnY = firstVertex.y();
            double mnZ = firstVertex.z();
            double mxX = firstVertex.x();
            double mxY = firstVertex.y();
            double mxZ = firstVertex.z();
            for (int i = 1; i < this.vertices.length; ++i) {
                Vector3dc vertex = this.vertices[i];
                mnX = Math.min(mnX, vertex.x());
                mnY = Math.min(mnY, vertex.y());
                mnZ = Math.min(mnZ, vertex.z());
                mxX = Math.max(mxX, vertex.x());
                mxY = Math.max(mxY, vertex.y());
                mxZ = Math.max(mxZ, vertex.z());
            }
            this.enclosedBBCache = new AxisAlignedBB(mnX, mnY, mnZ, mxX, mxY, mxZ);
        }
        return this.enclosedBBCache;
    }

    public Vector3dc[] getVertices() {
        return this.vertices;
    }
}

