/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.collision;

import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.collision.PhysCollisionObject;
import org.valkyrienskies.mod.common.collision.Polygon;

public class PhysPolygonCollider {
    public final Vector3dc[] potentialSeperatingAxes;
    public boolean seperated = false;
    public PhysCollisionObject[] collisions = null;
    public int minDistanceIndex;
    public double minDistance;
    public Polygon entity;
    public Polygon block;

    public PhysPolygonCollider(Polygon movable, Polygon stationary, Vector3dc[] axes) {
        this.potentialSeperatingAxes = axes;
        this.entity = movable;
        this.block = stationary;
        this.processData();
    }

    public void processData() {
        int i;
        this.collisions = new PhysCollisionObject[this.potentialSeperatingAxes.length];
        for (i = 0; i < this.potentialSeperatingAxes.length && !this.seperated; ++i) {
            this.collisions[i] = new PhysCollisionObject(this.entity, this.block, this.potentialSeperatingAxes[i]);
            this.seperated = this.collisions[i].seperated;
        }
        if (!this.seperated) {
            this.minDistance = 420.0;
            for (i = 0; i < this.potentialSeperatingAxes.length; ++i) {
                if (!(Math.abs(this.collisions[i].penetrationDistance) < this.minDistance)) continue;
                this.minDistanceIndex = i;
                this.minDistance = Math.abs(this.collisions[i].penetrationDistance);
            }
        }
    }
}

