/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.collision;

import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.mod.common.collision.Polygon;
import org.valkyrienskies.mod.common.util.VSMath;

public class PhysCollisionObject {
    public final Vector3dc collision_normal;
    public final Polygon movable;
    public final Polygon fixed;
    public double penetrationDistance;
    public boolean seperated;
    private double[] playerMinMax;
    private double[] blockMinMax;
    private double movMaxFixMin;
    private double movMinFixMax;
    private Vector3dc firstContactPoint;

    public PhysCollisionObject(Polygon movable_, Polygon stationary, Vector3dc axes) {
        this.collision_normal = axes;
        this.movable = movable_;
        this.fixed = stationary;
        this.generateCollision();
    }

    public void generateCollision() {
        this.playerMinMax = VSMath.getMinMaxOfArray(this.movable.getProjectionOnVector(this.collision_normal));
        this.blockMinMax = VSMath.getMinMaxOfArray(this.fixed.getProjectionOnVector(this.collision_normal));
        this.movMaxFixMin = this.playerMinMax[0] - this.blockMinMax[1];
        this.movMinFixMax = this.playerMinMax[1] - this.blockMinMax[0];
        if (this.movMaxFixMin > 0.0 || this.movMinFixMax < 0.0) {
            this.seperated = true;
            this.penetrationDistance = 0.0;
            return;
        }
        if (Math.abs(this.movMaxFixMin) > Math.abs(this.movMinFixMax)) {
            this.penetrationDistance = this.movMinFixMax;
            for (Vector3dc v : this.movable.getVertices()) {
                if (v.dot(this.collision_normal) != this.playerMinMax[1]) continue;
                this.firstContactPoint = v;
            }
        } else {
            this.penetrationDistance = this.movMaxFixMin;
            for (Vector3dc v : this.movable.getVertices()) {
                if (v.dot(this.collision_normal) != this.playerMinMax[0]) continue;
                this.firstContactPoint = v;
            }
        }
        this.seperated = false;
    }

    public Vector3d getResponse() {
        return this.collision_normal.mul(this.penetrationDistance, new Vector3d());
    }
}

