/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.mod.client.BaseModel;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.entity.EntityMountable;
import org.valkyrienskies.mod.common.entity.EntityMountableChair;

@Mod.EventBusSubscriber(modid="valkyrienskies")
public class RegisterEvents {
    private static final Logger logger = LogManager.getLogger(RegisterEvents.class);

    @SubscribeEvent
    public static void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        logger.debug("Registering blocks");
        Block[] blockArray = ValkyrienSkiesMod.BLOCKS.toArray(new Block[0]);
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
    }

    @SubscribeEvent
    public static void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        logger.debug("Registering items");
        event.getRegistry().registerAll((IForgeRegistryEntry[])ValkyrienSkiesMod.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void registerRecipes(@Nonnull RegistryEvent.Register<IRecipe> event) {
        ValkyrienSkiesMod.INSTANCE.registerRecipes(event);
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ValkyrienSkiesMod.ITEMS) {
            if (!(item instanceof BaseModel)) continue;
            ((BaseModel)item).registerModels();
        }
        for (Block block : ValkyrienSkiesMod.BLOCKS) {
            if (!(block instanceof BaseModel)) continue;
            ((BaseModel)block).registerModels();
        }
    }

    @SubscribeEvent
    public static void onRegisterEntitiesEvent(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        ResourceLocation physicsWrapperEntity = new ResourceLocation("valkyrienskies", "PhysWrapper");
        ResourceLocation entityMountable = new ResourceLocation("valkyrienskies", "entity_mountable");
        ResourceLocation entityMountableChair = new ResourceLocation("valkyrienskies", "entity_mountable_chair");
        int entityId = 0;
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{EntityEntryBuilder.create().entity(EntityMountable.class).id(entityMountable, entityId++).name(entityMountable.func_110623_a()).tracker(128, 1, false).build(), EntityEntryBuilder.create().entity(EntityMountableChair.class).id(entityMountableChair, entityId++).name(entityMountableChair.func_110623_a()).tracker(128, 1, false).build()});
    }
}

