/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.client.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import org.valkyrienskies.mod.client.render.FastBlockModelRenderer;
import org.valkyrienskies.mod.common.collision.Polygon;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public class PhysRenderChunk {
    public IVSRenderChunk[] renderChunks = new IVSRenderChunk[16];
    public PhysicsObject toRender;
    public Chunk chunk;
    private List<TileEntity> tileEntitiesToRender;

    public PhysRenderChunk(PhysicsObject toRender, Chunk chunk) {
        this.toRender = toRender;
        this.chunk = chunk;
        for (int i = 0; i < 16; ++i) {
            ExtendedBlockStorage storage = this.chunk.field_76652_q[i];
            if (storage == null) continue;
            IVSRenderChunk renderChunk = OpenGlHelper.func_176075_f() ? new RenderLayerVBO(this.chunk, i * 16, i * 16 + 15, this) : new RenderLayerDisplayList(this.chunk, i * 16, i * 16 + 15, this);
            this.renderChunks[i] = renderChunk;
        }
        this.tileEntitiesToRender = new ArrayList(chunk.func_177434_r().values());
        Minecraft.func_71410_x().field_71438_f.func_181023_a(new ArrayList(), this.tileEntitiesToRender);
    }

    public void renderBlockLayer(BlockRenderLayer layerToRender, double partialTicks, int pass, ICamera iCamera) {
        for (int i = 0; i < 16; ++i) {
            AxisAlignedBB renderChunkBB;
            Polygon polygon;
            AxisAlignedBB inWorldBB;
            IVSRenderChunk renderChunk = this.renderChunks[i];
            if (renderChunk == null || !iCamera.func_78546_a(inWorldBB = (polygon = new Polygon(renderChunkBB = new AxisAlignedBB((double)(this.chunk.field_76635_g << 4), (double)renderChunk.minY(), (double)(this.chunk.field_76647_h << 4), (double)((this.chunk.field_76635_g << 4) + 16), (double)(renderChunk.minY() + 16), (double)((this.chunk.field_76647_h << 4) + 16)), this.toRender.getShipTransformationManager().getRenderTransform(), TransformType.SUBSPACE_TO_GLOBAL)).getEnclosedAABB())) continue;
            renderChunk.renderBlockLayer(layerToRender, partialTicks, pass);
        }
    }

    public void updateLayers(int minLayer, int maxLayer) {
        ArrayList newTilesToRender = new ArrayList(this.chunk.field_150816_i.values());
        Minecraft.func_71410_x().field_71438_f.func_181023_a(this.tileEntitiesToRender, newTilesToRender);
        this.tileEntitiesToRender = newTilesToRender;
        for (int layerY = minLayer; layerY <= maxLayer; ++layerY) {
            IVSRenderChunk renderChunk = this.renderChunks[layerY];
            if (renderChunk != null) {
                renderChunk.markDirty();
                continue;
            }
            IVSRenderChunk renderLayer = OpenGlHelper.func_176075_f() ? new RenderLayerVBO(this.chunk, layerY * 16, layerY * 16 + 15, this) : new RenderLayerDisplayList(this.chunk, layerY * 16, layerY * 16 + 15, this);
            this.renderChunks[layerY] = renderLayer;
        }
    }

    void killRenderChunk() {
        for (int i = 0; i < 16; ++i) {
            IVSRenderChunk renderChunk = this.renderChunks[i];
            if (renderChunk == null) continue;
            renderChunk.deleteRenderChunk();
        }
    }

    public static class RenderLayerDisplayList
    implements IVSRenderChunk {
        Chunk chunkToRender;
        int yMin;
        int yMax;
        int glCallListCutout;
        int glCallListCutoutMipped;
        int glCallListSolid;
        int glCallListTranslucent;
        PhysRenderChunk parent;
        boolean needsCutoutUpdate;
        boolean needsCutoutMippedUpdate;
        boolean needsSolidUpdate;
        boolean needsTranslucentUpdate;

        RenderLayerDisplayList(Chunk chunk, int yMin, int yMax, PhysRenderChunk parent) {
            this.chunkToRender = chunk;
            this.yMin = yMin;
            this.yMax = yMax;
            this.parent = parent;
            this.markDirty();
            this.glCallListCutout = GLAllocation.func_74526_a((int)4);
            this.glCallListCutoutMipped = this.glCallListCutout + 1;
            this.glCallListSolid = this.glCallListCutout + 2;
            this.glCallListTranslucent = this.glCallListCutout + 3;
        }

        @Override
        public int minY() {
            return this.yMin;
        }

        @Override
        public int maxY() {
            return this.yMax;
        }

        @Override
        public void markDirty() {
            this.needsCutoutUpdate = true;
            this.needsCutoutMippedUpdate = true;
            this.needsSolidUpdate = true;
            this.needsTranslucentUpdate = true;
        }

        @Override
        public void deleteRenderChunk() {
            this.clearRenderLists();
        }

        private void clearRenderLists() {
            GLAllocation.func_74523_b((int)this.glCallListCutout);
            GLAllocation.func_74523_b((int)this.glCallListCutoutMipped);
            GLAllocation.func_74523_b((int)this.glCallListSolid);
            GLAllocation.func_74523_b((int)this.glCallListTranslucent);
        }

        @Override
        public void renderBlockLayer(BlockRenderLayer layerToRender, double partialTicks, int pass) {
            switch (layerToRender) {
                case CUTOUT: {
                    if (this.needsCutoutUpdate) {
                        this.updateList(layerToRender);
                    }
                    GL11.glCallList((int)this.glCallListCutout);
                    break;
                }
                case CUTOUT_MIPPED: {
                    if (this.needsCutoutMippedUpdate) {
                        this.updateList(layerToRender);
                    }
                    GL11.glCallList((int)this.glCallListCutoutMipped);
                    break;
                }
                case SOLID: {
                    if (this.needsSolidUpdate) {
                        this.updateList(layerToRender);
                    }
                    GL11.glCallList((int)this.glCallListSolid);
                    break;
                }
                case TRANSLUCENT: {
                    if (this.needsTranslucentUpdate) {
                        this.updateList(layerToRender);
                    }
                    GL11.glCallList((int)this.glCallListTranslucent);
                    break;
                }
            }
        }

        private void updateList(BlockRenderLayer layerToUpdate) {
            if (this.parent.toRender.getShipRenderer() == null) {
                return;
            }
            BlockPos offsetPos = this.parent.toRender.getShipRenderer().offsetPos;
            if (offsetPos == null) {
                return;
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            worldrenderer.func_178969_c((double)(-offsetPos.func_177958_n()), (double)(-offsetPos.func_177956_o()), (double)(-offsetPos.func_177952_p()));
            GL11.glPushMatrix();
            switch (layerToUpdate) {
                case CUTOUT: {
                    GLAllocation.func_74523_b((int)this.glCallListCutout);
                    GL11.glNewList((int)this.glCallListCutout, (int)4864);
                    break;
                }
                case CUTOUT_MIPPED: {
                    GLAllocation.func_74523_b((int)this.glCallListCutoutMipped);
                    GL11.glNewList((int)this.glCallListCutoutMipped, (int)4864);
                    break;
                }
                case SOLID: {
                    GLAllocation.func_74523_b((int)this.glCallListSolid);
                    GL11.glNewList((int)this.glCallListSolid, (int)4864);
                    break;
                }
                case TRANSLUCENT: {
                    GLAllocation.func_74523_b((int)this.glCallListTranslucent);
                    GL11.glNewList((int)this.glCallListTranslucent, (int)4864);
                    break;
                }
            }
            GlStateManager.func_179094_E();
            BlockRenderLayer oldLayer = MinecraftForgeClient.getRenderLayer();
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layerToUpdate);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = this.chunkToRender.field_76635_g * 16; x < this.chunkToRender.field_76635_g * 16 + 16; ++x) {
                for (int z = this.chunkToRender.field_76647_h * 16; z < this.chunkToRender.field_76647_h * 16 + 16; ++z) {
                    for (int y = this.yMin; y <= this.yMax; ++y) {
                        pos.func_181079_c(x, y, z);
                        IBlockState iblockstate = this.chunkToRender.func_177435_g((BlockPos)pos);
                        try {
                            if (!iblockstate.func_177230_c().canRenderInLayer(iblockstate, layerToUpdate)) continue;
                            Minecraft.func_71410_x().func_175602_ab().func_175018_a(iblockstate, (BlockPos)pos, (IBlockAccess)this.chunkToRender.field_76637_e, worldrenderer);
                            continue;
                        }
                        catch (NullPointerException e) {
                            System.out.println("Something was null! LValkyrienSkiesBase/render/PhysRenderChunk#updateList");
                        }
                    }
                }
            }
            tessellator.func_78381_a();
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldLayer);
            GlStateManager.func_179121_F();
            GL11.glEndList();
            GL11.glPopMatrix();
            worldrenderer.func_178969_c(0.0, 0.0, 0.0);
            switch (layerToUpdate) {
                case CUTOUT: {
                    this.needsCutoutUpdate = false;
                    break;
                }
                case CUTOUT_MIPPED: {
                    this.needsCutoutMippedUpdate = false;
                    break;
                }
                case SOLID: {
                    this.needsSolidUpdate = false;
                    break;
                }
                case TRANSLUCENT: {
                    this.needsTranslucentUpdate = false;
                    break;
                }
            }
        }
    }

    private class RenderLayerVBO
    implements IVSRenderChunk {
        Chunk chunkToRender;
        int yMin;
        int yMax;
        VertexBuffer cutoutBuffer;
        VertexBuffer cutoutMippedBuffer;
        VertexBuffer solidBuffer;
        VertexBuffer translucentBuffer;
        PhysRenderChunk parent;
        boolean needsCutoutUpdate;
        boolean needsCutoutMippedUpdate;
        boolean needsSolidUpdate;
        boolean needsTranslucentUpdate;

        RenderLayerVBO(Chunk chunk, int yMin, int yMax, PhysRenderChunk parent) {
            this.chunkToRender = chunk;
            this.yMin = yMin;
            this.yMax = yMax;
            this.parent = parent;
            this.markDirty();
            this.cutoutBuffer = null;
            this.cutoutMippedBuffer = null;
            this.solidBuffer = null;
            this.translucentBuffer = null;
        }

        @Override
        public int minY() {
            return this.yMin;
        }

        @Override
        public int maxY() {
            return this.yMax;
        }

        @Override
        public void markDirty() {
            this.needsCutoutUpdate = true;
            this.needsCutoutMippedUpdate = true;
            this.needsSolidUpdate = true;
            this.needsTranslucentUpdate = true;
        }

        @Override
        public void deleteRenderChunk() {
            this.clearRenderLists();
        }

        private void clearRenderLists() {
            if (this.cutoutBuffer != null) {
                this.cutoutBuffer.func_177362_c();
            }
            if (this.cutoutMippedBuffer != null) {
                this.cutoutMippedBuffer.func_177362_c();
            }
            if (this.solidBuffer != null) {
                this.solidBuffer.func_177362_c();
            }
            if (this.translucentBuffer != null) {
                this.translucentBuffer.func_177362_c();
            }
        }

        @Override
        public void renderBlockLayer(BlockRenderLayer layerToRender, double partialTicks, int pass) {
            switch (layerToRender) {
                case CUTOUT: {
                    if (this.needsCutoutUpdate) {
                        this.updateList(layerToRender);
                    }
                    FastBlockModelRenderer.renderVertexBuffer(this.cutoutBuffer);
                    break;
                }
                case CUTOUT_MIPPED: {
                    if (this.needsCutoutMippedUpdate) {
                        this.updateList(layerToRender);
                    }
                    FastBlockModelRenderer.renderVertexBuffer(this.cutoutMippedBuffer);
                    break;
                }
                case SOLID: {
                    if (this.needsSolidUpdate) {
                        this.updateList(layerToRender);
                    }
                    FastBlockModelRenderer.renderVertexBuffer(this.solidBuffer);
                    break;
                }
                case TRANSLUCENT: {
                    if (this.needsTranslucentUpdate) {
                        this.updateList(layerToRender);
                    }
                    FastBlockModelRenderer.renderVertexBuffer(this.translucentBuffer);
                    break;
                }
            }
        }

        private void updateList(BlockRenderLayer layerToUpdate) {
            VertexBuffer renderBuffer;
            if (this.parent.toRender.getShipRenderer() == null) {
                return;
            }
            BlockPos offsetPos = this.parent.toRender.getShipRenderer().offsetPos;
            if (offsetPos == null) {
                return;
            }
            BufferBuilder vsChunkBuilder = FastBlockModelRenderer.VERTEX_BUILDER;
            vsChunkBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            vsChunkBuilder.func_178969_c((double)(-offsetPos.func_177958_n()), (double)(-offsetPos.func_177956_o()), (double)(-offsetPos.func_177952_p()));
            switch (layerToUpdate) {
                case CUTOUT: {
                    if (this.cutoutBuffer != null) {
                        this.cutoutBuffer.func_177362_c();
                    }
                    renderBuffer = this.cutoutBuffer = new VertexBuffer(DefaultVertexFormats.field_176600_a);
                    break;
                }
                case CUTOUT_MIPPED: {
                    if (this.cutoutMippedBuffer != null) {
                        this.cutoutMippedBuffer.func_177362_c();
                    }
                    renderBuffer = this.cutoutMippedBuffer = new VertexBuffer(DefaultVertexFormats.field_176600_a);
                    break;
                }
                case SOLID: {
                    if (this.solidBuffer != null) {
                        this.solidBuffer.func_177362_c();
                    }
                    renderBuffer = this.solidBuffer = new VertexBuffer(DefaultVertexFormats.field_176600_a);
                    break;
                }
                case TRANSLUCENT: {
                    if (this.translucentBuffer != null) {
                        this.translucentBuffer.func_177362_c();
                    }
                    renderBuffer = this.translucentBuffer = new VertexBuffer(DefaultVertexFormats.field_176600_a);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + layerToUpdate);
                }
            }
            BlockRenderLayer oldLayer = MinecraftForgeClient.getRenderLayer();
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layerToUpdate);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = this.chunkToRender.field_76635_g * 16; x < this.chunkToRender.field_76635_g * 16 + 16; ++x) {
                for (int z = this.chunkToRender.field_76647_h * 16; z < this.chunkToRender.field_76647_h * 16 + 16; ++z) {
                    for (int y = this.yMin; y <= this.yMax; ++y) {
                        pos.func_181079_c(x, y, z);
                        IBlockState iblockstate = this.chunkToRender.func_177435_g((BlockPos)pos);
                        try {
                            if (!iblockstate.func_177230_c().canRenderInLayer(iblockstate, layerToUpdate)) continue;
                            Minecraft.func_71410_x().func_175602_ab().func_175018_a(iblockstate, (BlockPos)pos, (IBlockAccess)this.chunkToRender.field_76637_e, vsChunkBuilder);
                            continue;
                        }
                        catch (NullPointerException e) {
                            System.out.println("Something was null!");
                        }
                    }
                }
            }
            vsChunkBuilder.func_178977_d();
            renderBuffer.func_181722_a(vsChunkBuilder.func_178966_f());
            vsChunkBuilder.func_178965_a();
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldLayer);
            vsChunkBuilder.func_178969_c(0.0, 0.0, 0.0);
            switch (layerToUpdate) {
                case CUTOUT: {
                    this.needsCutoutUpdate = false;
                    break;
                }
                case CUTOUT_MIPPED: {
                    this.needsCutoutMippedUpdate = false;
                    break;
                }
                case SOLID: {
                    this.needsSolidUpdate = false;
                    break;
                }
                case TRANSLUCENT: {
                    this.needsTranslucentUpdate = false;
                    break;
                }
            }
        }
    }

    private static interface IVSRenderChunk {
        public void renderBlockLayer(BlockRenderLayer var1, double var2, int var4);

        public void markDirty();

        public void deleteRenderChunk();

        public int minY();

        public int maxY();
    }
}

