/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.client.render;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.chunk.Chunk;
import org.joml.AxisAngle4d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.lwjgl.opengl.GL11;
import org.valkyrienskies.mod.client.render.PhysRenderChunk;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;
import valkyrienwarfare.api.TransformType;

@ParametersAreNonnullByDefault
public class PhysObjectRenderManager {
    public final BlockPos offsetPos;
    private final PhysicsObject parent;
    private final Map<ChunkPos, PhysRenderChunk> renderChunks;

    public PhysObjectRenderManager(PhysicsObject toRender, BlockPos offsetPos) {
        this.parent = toRender;
        this.offsetPos = offsetPos;
        this.renderChunks = new HashMap<ChunkPos, PhysRenderChunk>();
        for (Chunk chunk : this.parent.getClaimedChunkCache()) {
            this.renderChunks.put(new ChunkPos(chunk.field_76635_g, chunk.field_76647_h), new PhysRenderChunk(this.parent, chunk));
        }
    }

    public void renderBlockLayer(BlockRenderLayer layerToRender, double partialTicks, int pass, ICamera camera) {
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        this.applyRenderTransform(partialTicks);
        for (PhysRenderChunk renderChunk : this.renderChunks.values()) {
            renderChunk.renderBlockLayer(layerToRender, partialTicks, pass, camera);
        }
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GL11.glPopMatrix();
    }

    public void killRenderers() {
        if (this.renderChunks != null) {
            for (PhysRenderChunk renderChunk : this.renderChunks.values()) {
                renderChunk.killRenderChunk();
            }
        }
    }

    public void updateRange(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean updateImmediately) {
        if (this.renderChunks == null || this.parent == null || this.parent.getChunkClaim() == null) {
            return;
        }
        int size = (maxX + 1 - minX) * (maxZ + 1 - minZ) * (maxY + 1 - minY);
        if (size > 65535) {
            return;
        }
        int minChunkX = minX >> 4;
        int maxChunkX = maxX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkZ = maxZ >> 4;
        int minBlockArrayY = Math.max(0, minY >> 4);
        int maxBlockArrayY = Math.min(15, maxY >> 4);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                if (!this.renderChunks.containsKey(pos)) continue;
                this.renderChunks.get(pos).updateLayers(minBlockArrayY, maxBlockArrayY);
            }
        }
    }

    public boolean shouldRender(ICamera camera) {
        return camera == null || camera.func_78546_a(this.parent.getShipBoundingBox());
    }

    public void applyRenderTransform(double partialTicks) {
        this.applyRenderTransform(partialTicks, false);
    }

    public void applyInverseTransform(double partialTicks) {
        this.applyRenderTransform(partialTicks, true);
    }

    private void applyRenderTransform(double partialTicks, boolean inverse) {
        Vector3dc centerOfRotation = this.parent.getCenterCoord();
        Entity player = Objects.requireNonNull(Minecraft.func_71410_x().func_175606_aa());
        double p0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double p1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double p2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        ShipTransform renderTransform = this.parent.getShipTransformationManager().getRenderTransform();
        Vector3d renderPos = renderTransform.getSubspaceToGlobal().transformPosition(centerOfRotation, new Vector3d());
        double offsetX = (double)this.offsetPos.func_177958_n() - centerOfRotation.x();
        double offsetY = (double)this.offsetPos.func_177956_o() - centerOfRotation.y();
        double offsetZ = (double)this.offsetPos.func_177952_p() - centerOfRotation.z();
        if (inverse) {
            AxisAngle4d rotation = new AxisAngle4d().set(renderTransform.getGlobalToSubspace());
            GL11.glTranslated((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
            GL11.glRotated((double)Math.toDegrees(rotation.angle), (double)rotation.x, (double)rotation.y, (double)rotation.z);
            GL11.glTranslated((double)(p0 - renderPos.x), (double)(p1 - renderPos.y), (double)(p2 - renderPos.z));
        } else {
            AxisAngle4d rotation = new AxisAngle4d().set(renderTransform.getSubspaceToGlobal());
            GL11.glTranslated((double)(-p0 + renderPos.x), (double)(-p1 + renderPos.y), (double)(-p2 + renderPos.z));
            GL11.glRotated((double)Math.toDegrees(rotation.angle), (double)rotation.x, (double)rotation.y, (double)rotation.z);
            GL11.glTranslated((double)offsetX, (double)offsetY, (double)offsetZ);
        }
    }

    public void renderDebugInfo(Vector3dc offset) {
        this.renderDebugInfo(offset.x(), offset.y(), offset.z());
    }

    public void renderDebugInfo(double offsetX, double offsetY, double offsetZ) {
        GlStateManager.func_179094_E();
        AxisAlignedBB shipBB = this.parent.getShipBB().func_72317_d(offsetX, offsetY, offsetZ);
        ShipTransform renderTransform = this.parent.getShipTransformationManager().getRenderTransform();
        Vector3dc centerOfMass = this.parent.getShipData().getInertiaData().getGameTickCenterOfMass();
        Vector3d centerOfMassPos = new Vector3d(centerOfMass);
        this.parent.getShipTransformationManager().getRenderTransform().transformPosition(centerOfMassPos, TransformType.SUBSPACE_TO_GLOBAL);
        AxisAlignedBB centerOfMassBB = new AxisAlignedBB(JOML.toMinecraft(centerOfMassPos), JOML.toMinecraft(centerOfMassPos)).func_186662_g(0.1).func_72317_d(offsetX, offsetY, offsetZ);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        RenderGlobal.func_189697_a((AxisAlignedBB)shipBB, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (VSConfig.renderShipChunkClaimsInDebug) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)((float)renderTransform.getPosX()) + offsetX), (double)((double)((float)renderTransform.getPosY()) + offsetY), (double)((double)((float)renderTransform.getPosZ()) + offsetZ));
            Vector3d angles = renderTransform.getSubspaceToGlobal().getEulerAnglesZYX(new Vector3d());
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(angles.z())), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(angles.y())), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(angles.x())), (float)1.0f, (float)0.0f, (float)0.0f);
            for (ChunkPos claimedChunk : this.parent.getChunkClaim()) {
                AxisAlignedBB claimBB = new AxisAlignedBB((double)claimedChunk.func_180334_c() + 0.1, renderTransform.getCenterCoord().y() - 8.0 + 0.1, (double)claimedChunk.func_180333_d() + 0.1, (double)claimedChunk.func_180332_e() + 0.9, renderTransform.getCenterCoord().y() + 8.0 - 0.1, (double)claimedChunk.func_180330_f() + 0.9);
                claimBB = claimBB.func_72317_d(-renderTransform.getCenterCoord().x(), -renderTransform.getCenterCoord().y(), -renderTransform.getCenterCoord().z());
                RenderGlobal.func_189697_a((AxisAlignedBB)claimBB, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179097_i();
        RenderGlobal.func_189697_a((AxisAlignedBB)centerOfMassBB, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        String centerOfMassStr = "Center of Mass: " + new Vector3d(centerOfMass).toString(new DecimalFormat("############.##"));
        this.renderTextBox(centerOfMassStr, renderTransform.getPosX(), renderTransform.getPosY() + 0.5, renderTransform.getPosZ(), offsetX, offsetY, offsetZ);
        String massStr = String.format("Mass: %.2f", this.parent.getShipData().getInertiaData().getGameTickMass());
        this.renderTextBox(massStr, renderTransform.getPosX(), renderTransform.getPosY() + 1.0, renderTransform.getPosZ(), offsetX, offsetY, offsetZ);
        GlStateManager.func_179121_F();
    }

    private void renderTextBox(String str, double posX, double posY, double posZ, double offsetX, double offsetY, double offsetZ) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderViewEntity = mc.func_175606_aa();
        if (renderViewEntity == null) {
            return;
        }
        double maxDistance = 64.0;
        double d0 = new Vec3d(posX, posY, posZ).func_72436_e(renderViewEntity.func_174791_d());
        if (d0 <= 4096.0) {
            float playerYaw = mc.func_175598_ae().field_78735_i;
            float playerPitch = mc.func_175598_ae().field_78732_j;
            boolean isThirdPersonFrontal = mc.func_175598_ae().field_78733_k.field_74320_O == 2;
            EntityRenderer.func_189692_a((FontRenderer)mc.func_175598_ae().func_78716_a(), (String)str, (float)((float)(posX + offsetX)), (float)((float)(posY + offsetY)), (float)((float)(posZ + offsetZ)), (int)0, (float)playerYaw, (float)playerPitch, (boolean)isThirdPersonFrontal, (boolean)false);
        }
    }

    public void updateChunk(@Nonnull Chunk chunk) {
        ChunkPos chunkPos = new ChunkPos(chunk.field_76635_g, chunk.field_76647_h);
        PhysRenderChunk oldRenderer = this.renderChunks.get(chunkPos);
        if (oldRenderer != null) {
            oldRenderer.killRenderChunk();
        }
        this.renderChunks.put(chunkPos, new PhysRenderChunk(this.parent, chunk));
    }
}

