/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.client.render;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.valkyrienskies.mod.client.render.FastBlockModelRenderer;

public class GibsModelRegistry {
    private static final List<ResourceLocation> MODEL_TEXTURES_INTERNAL;
    public static final List<ResourceLocation> MODEL_TEXTURES_IMMUTABLE;
    private static final Map<String, ResourceLocation> NAMES_TO_RESOURCE_LOCATION;
    private static final Map<String, IBakedModel> NAMES_TO_BAKED_MODELS;
    private static final Map<String, BufferBuilder.State> NAMES_TO_BUFFER_STATES;
    private static final Map<String, Map<Integer, VertexBuffer>> NAMES_AND_BRIGHTNESS_TO_VERTEX_BUFFER;
    private static final boolean OPTIFINE_INSTALLED;
    private static final ImmutableMap<String, String> FLIP_UV_CUSTOM_DATA;
    private static final BlockPos offsetPos;
    private static Optional<Boolean> OPTIFINE_SHADERS_ENABLED;

    public static void renderGibsModel(String name, int brightness) {
        if (!NAMES_TO_RESOURCE_LOCATION.containsKey(name)) {
            throw new IllegalArgumentException("No registed gibs model with the name " + name + "!");
        }
        if (!NAMES_TO_BAKED_MODELS.containsKey(name)) {
            ResourceLocation location = NAMES_TO_RESOURCE_LOCATION.get(name);
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)location).process(FLIP_UV_CUSTOM_DATA);
                IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                NAMES_TO_BAKED_MODELS.put(name, bakedModel);
            }
            catch (Exception e) {
                System.err.println("No model found for: " + name);
                e.printStackTrace();
                throw new IllegalStateException();
            }
        }
        if (!NAMES_TO_BUFFER_STATES.containsKey(name)) {
            FastBlockModelRenderer.VERTEX_BUILDER.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            IBakedModel modelFromState = NAMES_TO_BAKED_MODELS.get(name);
            blockrendererdispatcher.func_175019_b().func_187493_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, modelFromState, Blocks.field_150350_a.func_176223_P(), offsetPos, FastBlockModelRenderer.VERTEX_BUILDER, false, 0L);
            BufferBuilder.State bufferState = FastBlockModelRenderer.VERTEX_BUILDER.func_181672_a();
            FastBlockModelRenderer.VERTEX_BUILDER.func_178977_d();
            FastBlockModelRenderer.VERTEX_BUILDER.func_178965_a();
            NAMES_TO_BUFFER_STATES.put(name, bufferState);
        }
        if (!NAMES_AND_BRIGHTNESS_TO_VERTEX_BUFFER.containsKey(name)) {
            NAMES_AND_BRIGHTNESS_TO_VERTEX_BUFFER.put(name, new HashMap());
        }
        if (!NAMES_AND_BRIGHTNESS_TO_VERTEX_BUFFER.get(name).containsKey(brightness)) {
            BufferBuilder.State bufferState = NAMES_TO_BUFFER_STATES.get(name);
            FastBlockModelRenderer.VERTEX_BUILDER.func_178969_c(0.0, 0.0, 0.0);
            FastBlockModelRenderer.VERTEX_BUILDER.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            FastBlockModelRenderer.VERTEX_BUILDER.func_178993_a(bufferState);
            int j = FastBlockModelRenderer.VERTEX_BUILDER.field_179011_q.func_177338_f() >> 2;
            int cont = FastBlockModelRenderer.VERTEX_BUILDER.func_178989_h();
            int offsetUV = FastBlockModelRenderer.VERTEX_BUILDER.field_179011_q.func_177344_b(1) / 4;
            int bufferNextSize = FastBlockModelRenderer.VERTEX_BUILDER.field_179011_q.func_181719_f();
            for (int contont = 0; contont < cont; contont += 4) {
                try {
                    int i = contont * bufferNextSize + offsetUV;
                    FastBlockModelRenderer.VERTEX_BUILDER.field_178999_b.put(i, brightness);
                    FastBlockModelRenderer.VERTEX_BUILDER.field_178999_b.put(i + j, brightness);
                    FastBlockModelRenderer.VERTEX_BUILDER.field_178999_b.put(i + j * 2, brightness);
                    FastBlockModelRenderer.VERTEX_BUILDER.field_178999_b.put(i + j * 3, brightness);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            VertexBuffer gibVertexBuffer = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            FastBlockModelRenderer.VERTEX_BUILDER.func_178977_d();
            FastBlockModelRenderer.VERTEX_BUILDER.func_178965_a();
            gibVertexBuffer.func_181722_a(FastBlockModelRenderer.VERTEX_BUILDER.func_178966_f());
            NAMES_AND_BRIGHTNESS_TO_VERTEX_BUFFER.get(name).put(brightness, gibVertexBuffer);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-offsetPos.func_177958_n()), (float)(-offsetPos.func_177956_o()), (float)(-offsetPos.func_177952_p()));
        FastBlockModelRenderer.renderVertexBuffer(NAMES_AND_BRIGHTNESS_TO_VERTEX_BUFFER.get(name).get(brightness));
        GlStateManager.func_179121_F();
    }

    public static void registerGibsModel(String name, ResourceLocation modelLocation) {
        NAMES_TO_RESOURCE_LOCATION.put(name, modelLocation);
    }

    public static void onResourceManagerReload(IResourceManager resourceManager) {
        System.out.println("Valkyrien Skies got a resource reload event! " + NAMES_TO_RESOURCE_LOCATION.size());
        System.out.println(NAMES_TO_RESOURCE_LOCATION.toString());
        NAMES_TO_BAKED_MODELS.clear();
        NAMES_TO_BUFFER_STATES.clear();
        NAMES_AND_BRIGHTNESS_TO_VERTEX_BUFFER.clear();
        OPTIFINE_SHADERS_ENABLED = Optional.empty();
        FastBlockModelRenderer.blockstateToVertexData.clear();
        FastBlockModelRenderer.blockstateBrightnessToVertexBuffer.clear();
    }

    public static boolean isOptifineShadersEnabled() {
        if (!OPTIFINE_SHADERS_ENABLED.isPresent()) {
            if (OPTIFINE_INSTALLED) {
                try {
                    OPTIFINE_SHADERS_ENABLED = Optional.of((Boolean)Class.forName("Config").getMethod("isShaders", new Class[0]).invoke(null, new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            } else {
                OPTIFINE_SHADERS_ENABLED = Optional.of(false);
            }
        }
        return OPTIFINE_SHADERS_ENABLED.get();
    }

    public static void registerTextures(TextureStitchEvent event) {
        System.out.println("Valkyrien Skies got a register textures pre event! " + NAMES_TO_RESOURCE_LOCATION.size());
        for (ResourceLocation location : NAMES_TO_RESOURCE_LOCATION.values()) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)location);
                Collection resourceLocations = model.getTextures();
                for (ResourceLocation texture : resourceLocations) {
                    event.getMap().func_174942_a(texture);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void onModelBakeEvent(ModelBakeEvent event) {
        System.out.println("Valkyrien Skies got a model bake event! " + NAMES_TO_RESOURCE_LOCATION.size());
    }

    static {
        boolean optifineInstalled;
        MODEL_TEXTURES_INTERNAL = new ArrayList<ResourceLocation>();
        MODEL_TEXTURES_IMMUTABLE = Collections.unmodifiableList(MODEL_TEXTURES_INTERNAL);
        NAMES_TO_RESOURCE_LOCATION = new HashMap<String, ResourceLocation>();
        NAMES_TO_BAKED_MODELS = new HashMap<String, IBakedModel>();
        NAMES_TO_BUFFER_STATES = new HashMap<String, BufferBuilder.State>();
        NAMES_AND_BRIGHTNESS_TO_VERTEX_BUFFER = new HashMap<String, Map<Integer, VertexBuffer>>();
        FLIP_UV_CUSTOM_DATA = ImmutableMap.of((Object)"flip-v", (Object)"true", (Object)"ambient", (Object)"true");
        offsetPos = new BlockPos(0, 512, 0);
        OPTIFINE_SHADERS_ENABLED = Optional.empty();
        try {
            Class.forName("Config", false, GibsModelRegistry.class.getClassLoader());
            optifineInstalled = true;
        }
        catch (ClassNotFoundException e) {
            optifineInstalled = false;
        }
        OPTIFINE_INSTALLED = optifineInstalled;
    }
}

