/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.world.chunk;

import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.ships.QueryableShipData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.ShipDataMethods;
import org.valkyrienskies.mod.common.ships.chunk_claims.ShipChunkAllocator;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

@Mixin(value={Chunk.class}, priority=1001)
public abstract class MixinChunk {
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    public World field_76637_e;

    @Shadow
    public abstract IBlockState func_177435_g(BlockPos var1);

    @Inject(method={"addTileEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at={@At(value="TAIL")})
    private void post_addTileEntity(BlockPos pos, TileEntity tileEntityIn, CallbackInfo callbackInfo) {
        ValkyrienUtils.getPhysoManagingBlock(this.field_76637_e, pos).ifPresent(physo -> physo.onSetTileEntity(pos, tileEntityIn));
    }

    @Inject(method={"removeTileEntity(Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="TAIL")})
    private void post_removeTileEntity(BlockPos pos, CallbackInfo callbackInfo) {
        ValkyrienUtils.getPhysoManagingBlock(this.field_76637_e, pos).ifPresent(physo -> physo.onRemoveTileEntity(pos));
    }

    @Inject(method={"setBlockState"}, at={@At(value="HEAD")})
    private void pre_setBlockState(BlockPos pos, IBlockState state, CallbackInfoReturnable<IBlockState> cir) {
        if (!this.field_76637_e.field_72995_K) {
            IBlockState oldState = this.func_177435_g(pos);
            QueryableShipData queryableShipData = QueryableShipData.get(this.field_76637_e);
            Optional<ShipData> shipDataOptional = queryableShipData.getShipFromChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            shipDataOptional.ifPresent(shipData -> ShipDataMethods.onSetBlockState(shipData, pos, oldState, state));
        }
    }

    @Inject(method={"populate(Lnet/minecraft/world/chunk/IChunkProvider;Lnet/minecraft/world/gen/IChunkGenerator;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void prePopulateChunk(IChunkProvider provider, IChunkGenerator generator, CallbackInfo callbackInfo) {
        if (ShipChunkAllocator.isChunkInShipyard(this.field_76635_g, this.field_76647_h)) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"addEntity(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void preAddEntity(Entity entityIn, CallbackInfo callbackInfo) {
        Chunk realChunkFor;
        World world = this.field_76637_e;
        int i = MathHelper.func_76128_c((double)(entityIn.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.field_70161_v / 16.0));
        if ((i != this.field_76635_g || j != this.field_76647_h) && !(realChunkFor = world.func_72964_e(i, j)).func_76621_g() && realChunkFor.field_76636_d) {
            realChunkFor.func_76612_a(entityIn);
            callbackInfo.cancel();
        }
    }
}

