/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.collision.EntityPolygonCollider;
import org.valkyrienskies.mod.common.collision.Polygon;
import org.valkyrienskies.mod.common.collision.ShipPolygon;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.IHasShipManager;
import org.valkyrienskies.mod.common.ships.ship_world.IPhysObjectWorld;
import org.valkyrienskies.mod.common.ships.ship_world.IWorldVS;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.VSMath;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import org.valkyrienskies.mod.fixes.MixinWorldIntrinsicMethods;
import valkyrienwarfare.api.TransformType;

@Mixin(value={World.class}, priority=2018)
@Implements(value={@Interface(iface=MixinWorldIntrinsicMethods.class, prefix="vs$", remap=Interface.Remap.NONE)})
public abstract class MixinWorld
implements IWorldVS,
IHasShipManager {
    private static final double MAX_ENTITY_RADIUS_ALT = 2.0;
    private static final double BOUNDING_BOX_EDGE_LIMIT = 1.2E8;
    private static final double BOUNDING_BOX_SIZE_LIMIT = 1.2E8;
    private boolean shouldInterceptRayTrace = true;
    private PhysicsObject dontInterceptShip = null;
    private IPhysObjectWorld manager = null;
    @Shadow
    protected List<IWorldEventListener> field_73021_x;
    private static final RayTraceResult DUMMY_RAYTRACE_RESULT = new RayTraceResult(Vec3d.field_186680_a, EnumFacing.DOWN);

    private static boolean isBoundingBoxTooLarge(AxisAlignedBB alignedBB) {
        if ((alignedBB.field_72336_d - alignedBB.field_72340_a) * (alignedBB.field_72337_e - alignedBB.field_72338_b) * (alignedBB.field_72334_f - alignedBB.field_72339_c) > 1.2E8) {
            return true;
        }
        if (alignedBB.field_72336_d - alignedBB.field_72340_a > 1.2E8 || alignedBB.field_72337_e - alignedBB.field_72338_b > 1.2E8 || alignedBB.field_72334_f - alignedBB.field_72339_c > 1.2E8) {
            return true;
        }
        return alignedBB.field_72336_d > 2.147483647E9 || alignedBB.field_72336_d < -2.147483648E9 || alignedBB.field_72340_a > 2.147483647E9 || alignedBB.field_72340_a < -2.147483648E9 || alignedBB.field_72337_e > 2.147483647E9 || alignedBB.field_72337_e < -2.147483648E9 || alignedBB.field_72338_b > 2.147483647E9 || alignedBB.field_72338_b < -2.147483648E9 || alignedBB.field_72334_f > 2.147483647E9 || alignedBB.field_72334_f < -2.147483648E9 || alignedBB.field_72339_c > 2.147483647E9 || alignedBB.field_72339_c < -2.147483648E9;
    }

    @Overwrite
    public void func_175720_a(int particleID, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        BlockPos pos = new BlockPos(x, y, z);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)World.class.cast(this), pos);
        if (physicsObject.isPresent()) {
            Vector3d newPosVec = new Vector3d(x, y, z);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transformPosition(newPosVec, TransformType.SUBSPACE_TO_GLOBAL);
            x = newPosVec.x;
            y = newPosVec.y;
            z = newPosVec.z;
        }
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_180442_a(particleID, ignoreRange, x, y, z, xSpeed, ySpeed, zSpeed, parameters);
        }
    }

    @Shadow
    public IBlockState func_180495_p(BlockPos pos) {
        return null;
    }

    @Shadow
    protected abstract boolean func_175680_a(int var1, int var2, boolean var3);

    @Shadow
    public abstract Chunk func_72964_e(int var1, int var2);

    @Shadow
    public abstract List<AxisAlignedBB> func_184144_a(@Nullable Entity var1, AxisAlignedBB var2);

    @Inject(method={"getCollisionBoxes(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;ZLjava/util/List;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetCollisionBoxes(@Nullable Entity entityIn, AxisAlignedBB aabb, boolean p_191504_3_, @Nullable List<AxisAlignedBB> outList, CallbackInfoReturnable<Boolean> callbackInfo) {
        double deltaZ;
        double deltaY;
        double deltaX = Math.abs(aabb.field_72336_d - aabb.field_72340_a);
        if (Math.max(deltaX, Math.max(deltaY = Math.abs(aabb.field_72337_e - aabb.field_72338_b), deltaZ = Math.abs(aabb.field_72334_f - aabb.field_72339_c))) > 99999.0) {
            System.err.println(entityIn + "\ntried going extremely fast during the collision step");
            new Exception().printStackTrace();
            callbackInfo.setReturnValue(Boolean.FALSE);
            callbackInfo.cancel();
        }
        if (entityIn instanceof EntityPlayer && entityIn.func_70093_af()) {
            List<PhysicsObject> ships = this.getManager().getPhysObjectsInAABB(aabb);
            for (PhysicsObject wrapper : ships) {
                Polygon playerInLocal = new Polygon(aabb, wrapper.getShipTransformationManager().getCurrentTickTransform(), TransformType.GLOBAL_TO_SUBSPACE);
                AxisAlignedBB bb = playerInLocal.getEnclosedAABB();
                if ((bb.field_72336_d - bb.field_72340_a) * (bb.field_72334_f - bb.field_72339_c) > 9898989.0) {
                    System.err.println("Why did transforming a players bounding box result in a giant bounding box?");
                    System.err.println(bb + "\n" + wrapper.getShipData() + "\n" + entityIn.toString());
                    new Exception().printStackTrace();
                    return;
                }
                List<AxisAlignedBB> collidingBBs = this.func_184144_a(null, bb);
                Polygon entityPoly = new Polygon(aabb.func_72314_b(-0.2, 0.0, -0.2));
                for (AxisAlignedBB inLocal : collidingBBs) {
                    ShipPolygon poly = new ShipPolygon(inLocal, wrapper.getShipTransformationManager().getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL, wrapper.getShipTransformationManager().normals, wrapper);
                    EntityPolygonCollider collider = new EntityPolygonCollider(entityPoly, poly, poly.normals, new Vector3d());
                    collider.processData();
                    if (collider.arePolygonsSeparated()) continue;
                    outList.add(inLocal);
                    return;
                }
            }
        }
    }

    private <T extends Entity> List<T> getEntitiesWithinAABBOriginal(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable com.google.common.base.Predicate<? super T> filter) {
        int i = MathHelper.func_76128_c((double)((aabb.field_72340_a - 2.0) / 16.0));
        int j = MathHelper.func_76143_f((double)((aabb.field_72336_d + 2.0) / 16.0));
        int k = MathHelper.func_76128_c((double)((aabb.field_72339_c - 2.0) / 16.0));
        int l = MathHelper.func_76143_f((double)((aabb.field_72334_f + 2.0) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int i1 = i; i1 < j; ++i1) {
            for (int j1 = k; j1 < l; ++j1) {
                if (!this.func_175680_a(i1, j1, true)) continue;
                this.func_72964_e(i1, j1).func_177430_a(clazz, aabb, (List)list, filter);
            }
        }
        return list;
    }

    private List<Entity> getEntitiesInAABBexcludingOriginal(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable com.google.common.base.Predicate<? super Entity> predicate) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)((boundingBox.field_72340_a - 2.0) / 16.0));
        int j = MathHelper.func_76128_c((double)((boundingBox.field_72336_d + 2.0) / 16.0));
        int k = MathHelper.func_76128_c((double)((boundingBox.field_72339_c - 2.0) / 16.0));
        int l = MathHelper.func_76128_c((double)((boundingBox.field_72334_f + 2.0) / 16.0));
        if (MixinWorld.isBoundingBoxTooLarge(boundingBox)) {
            new Exception("Tried getting entities from giant bounding box of " + boundingBox).printStackTrace();
            return list;
        }
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.func_175680_a(i1, j1, true)) continue;
                this.func_72964_e(i1, j1).func_177414_a(entityIn, boundingBox, (List)list, predicate);
            }
        }
        return list;
    }

    @Overwrite
    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable com.google.common.base.Predicate<? super T> filter) {
        List<T> toReturn = this.getEntitiesWithinAABBOriginal(clazz, aabb, filter);
        BlockPos pos = new BlockPos((aabb.field_72340_a + aabb.field_72336_d) / 2.0, (aabb.field_72338_b + aabb.field_72337_e) / 2.0, (aabb.field_72339_c + aabb.field_72334_f) / 2.0);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)World.class.cast(this), pos);
        if (physicsObject.isPresent()) {
            Polygon poly = new Polygon(aabb, physicsObject.get().getShipTransformationManager().getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL);
            aabb = poly.getEnclosedAABB();
            toReturn.addAll(this.getEntitiesWithinAABBOriginal(clazz, aabb, filter));
        }
        return toReturn;
    }

    @Overwrite
    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable com.google.common.base.Predicate<? super Entity> predicate) {
        if (MixinWorld.isBoundingBoxTooLarge(boundingBox)) {
            new Exception("Tried getting entities from giant bounding box of " + boundingBox).printStackTrace();
            return new ArrayList<Entity>();
        }
        List<Entity> toReturn = this.getEntitiesInAABBexcludingOriginal(entityIn, boundingBox, predicate);
        BlockPos pos = new BlockPos((boundingBox.field_72340_a + boundingBox.field_72336_d) / 2.0, (boundingBox.field_72338_b + boundingBox.field_72337_e) / 2.0, (boundingBox.field_72339_c + boundingBox.field_72334_f) / 2.0);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)World.class.cast(this), pos);
        if (physicsObject.isPresent()) {
            Polygon poly = new Polygon(boundingBox, physicsObject.get().getShipTransformationManager().getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL);
            if (MixinWorld.isBoundingBoxTooLarge(boundingBox = poly.getEnclosedAABB().func_186664_h(0.3))) {
                new Exception("Tried getting entities from giant bounding box of " + boundingBox).printStackTrace();
                return new ArrayList<Entity>();
            }
            toReturn.addAll(this.getEntitiesInAABBexcludingOriginal(entityIn, boundingBox, predicate));
        }
        return toReturn;
    }

    @Shadow(remap=false)
    public abstract Iterator<Chunk> getPersistentChunkIterable(Iterator<Chunk> var1);

    @Intrinsic(displace=true)
    public Iterator<Chunk> vs$getPersistentChunkIterable(Iterator<Chunk> chunkIterator) {
        ArrayList<Chunk> persistentChunks = new ArrayList<Chunk>();
        while (chunkIterator.hasNext()) {
            Chunk chunk = chunkIterator.next();
            persistentChunks.add(chunk);
        }
        Iterator<Chunk> replacementIterator = persistentChunks.iterator();
        return this.getPersistentChunkIterable(replacementIterator);
    }

    @Override
    public void excludeShipFromRayTracer(PhysicsObject entity) {
        if (this.dontInterceptShip != null) {
            throw new IllegalStateException("excluded ship is already set!");
        }
        this.dontInterceptShip = entity;
    }

    @Override
    public void unexcludeShipFromRayTracer(PhysicsObject entity) {
        if (this.dontInterceptShip != entity) {
            throw new IllegalStateException("must exclude the same ship!");
        }
        this.dontInterceptShip = null;
    }

    @Inject(method={"rayTraceBlocks(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preRayTraceBlocks(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, CallbackInfoReturnable<RayTraceResult> callbackInfo) {
        if (this.shouldInterceptRayTrace) {
            callbackInfo.setReturnValue(this.rayTraceBlocksIgnoreShip(vec31, vec32, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, this.dontInterceptShip));
        }
    }

    @Override
    public RayTraceResult rayTraceBlocksIgnoreShip(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, PhysicsObject toIgnore) {
        this.shouldInterceptRayTrace = false;
        RayTraceResult vanillaTrace = ((World)World.class.cast(this)).func_147447_a(vec31, vec32, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
        IPhysObjectWorld physObjectWorld = this.getManager();
        if (physObjectWorld == null) {
            return vanillaTrace;
        }
        Vec3d playerReachVector = vec32.func_178788_d(vec31);
        AxisAlignedBB playerRangeBB = new AxisAlignedBB(vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c, vec32.field_72450_a, vec32.field_72448_b, vec32.field_72449_c);
        List<PhysicsObject> nearbyShips = physObjectWorld.getPhysObjectsInAABB(playerRangeBB);
        nearbyShips.remove(toIgnore);
        double reachDistance = playerReachVector.func_72433_c();
        double worldResultDistFromPlayer = 4.2E8;
        if (vanillaTrace != null && vanillaTrace.field_72307_f != null) {
            worldResultDistFromPlayer = vanillaTrace.field_72307_f.func_72438_d(vec31);
        }
        for (PhysicsObject wrapper : nearbyShips) {
            double shipResultDistFromPlayer;
            Vec3d playerEyesPos = vec31;
            playerReachVector = vec32.func_178788_d(vec31);
            ShipTransform shipTransform = wrapper.getShipTransformationManager().getRenderTransform();
            playerEyesPos = shipTransform.transform(playerEyesPos, TransformType.GLOBAL_TO_SUBSPACE);
            playerReachVector = shipTransform.rotate(playerReachVector, TransformType.GLOBAL_TO_SUBSPACE);
            Vec3d playerEyesReachAdded = playerEyesPos.func_72441_c(playerReachVector.field_72450_a * reachDistance, playerReachVector.field_72448_b * reachDistance, playerReachVector.field_72449_c * reachDistance);
            RayTraceResult resultInShip = ((World)World.class.cast(this)).func_147447_a(playerEyesPos, playerEyesReachAdded, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
            if (resultInShip == null || resultInShip.field_72307_f == null || resultInShip.field_72313_a != RayTraceResult.Type.BLOCK || !((shipResultDistFromPlayer = resultInShip.field_72307_f.func_72438_d(playerEyesPos)) < worldResultDistFromPlayer)) continue;
            worldResultDistFromPlayer = shipResultDistFromPlayer;
            resultInShip.field_72307_f = shipTransform.transform(resultInShip.field_72307_f, TransformType.SUBSPACE_TO_GLOBAL);
            vanillaTrace = resultInShip;
        }
        this.shouldInterceptRayTrace = true;
        return vanillaTrace;
    }

    @Override
    public RayTraceResult rayTraceBlocksInShip(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, PhysicsObject toUse) {
        this.shouldInterceptRayTrace = false;
        ShipTransform shipTransform = toUse.getShipTransformationManager().getRenderTransform();
        Vec3d traceStart = shipTransform.transform(vec31, TransformType.GLOBAL_TO_SUBSPACE);
        Vec3d traceEnd = shipTransform.transform(vec32, TransformType.GLOBAL_TO_SUBSPACE);
        RayTraceResult resultInShip = ((World)World.class.cast(this)).func_147447_a(traceStart, traceEnd, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
        if (resultInShip != null && resultInShip.field_72307_f != null && resultInShip.field_72313_a == RayTraceResult.Type.BLOCK) {
            resultInShip.field_72307_f = shipTransform.transform(resultInShip.field_72307_f, TransformType.SUBSPACE_TO_GLOBAL);
            this.shouldInterceptRayTrace = true;
            return resultInShip;
        }
        this.shouldInterceptRayTrace = true;
        return null;
    }

    @Override
    public IPhysObjectWorld getManager() {
        if (this.manager == null) {
            throw new IllegalStateException("We can't be accessing this manager since WorldEvent.load() was never called!");
        }
        return this.manager;
    }

    @Override
    public void setManager(Function<World, IPhysObjectWorld> managerSupplier) {
        this.manager = managerSupplier.apply((World)World.class.cast(this));
    }

    @Redirect(method={"getBlockDensity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;rayTraceBlocks(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/RayTraceResult;"))
    private RayTraceResult rayTraceBlocksForGetBlockDensity(World world, Vec3d start, Vec3d end) {
        if (VSConfig.explosionMode == VSConfig.ExplosionMode.VANILLA) {
            this.shouldInterceptRayTrace = false;
            RayTraceResult result = this.func_72933_a(start, end);
            this.shouldInterceptRayTrace = true;
            return result;
        }
        if (VSConfig.explosionMode == VSConfig.ExplosionMode.SLOW_VANILLA) {
            return this.func_72933_a(start, end);
        }
        Predicate<BlockPos> canCollide = pos -> {
            IBlockState blockState = world.func_180495_p(pos);
            return blockState.func_177230_c().func_176209_a(blockState, false);
        };
        List<BlockPos> blocks = VSMath.generateLineBetween(start, end, BlockPos::new);
        boolean collided = blocks.stream().anyMatch(canCollide);
        IPhysObjectWorld physObjectWorld = this.getManager();
        if (physObjectWorld != null) {
            List<PhysicsObject> nearbyShips = physObjectWorld.getPhysObjectsInAABB(new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c));
            for (PhysicsObject obj : nearbyShips) {
                Vec3d transformedStart = obj.transformVector(start, TransformType.GLOBAL_TO_SUBSPACE);
                Vec3d transformedEnd = obj.transformVector(end, TransformType.GLOBAL_TO_SUBSPACE);
                List<BlockPos> physoBlocks = VSMath.generateLineBetween(transformedStart, transformedEnd, BlockPos::new);
                collided |= physoBlocks.stream().anyMatch(canCollide);
            }
        }
        return collided ? DUMMY_RAYTRACE_RESULT : null;
    }

    @Shadow
    public abstract RayTraceResult func_72933_a(Vec3d var1, Vec3d var2);

    @Shadow
    public abstract boolean func_72829_c(AxisAlignedBB var1);

    @Inject(method={"checkBlockCollision"}, at={@At(value="HEAD")}, cancellable=true)
    public void postCheckBlockCollision(AxisAlignedBB axisAlignedBB, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        List<PhysicsObject> physObjectsInAABB = this.getManager().getPhysObjectsInAABB(axisAlignedBB);
        for (PhysicsObject physicsObject : physObjectsInAABB) {
            ShipTransform shipTransform = physicsObject.getShipTransform();
            AxisAlignedBB aabbInShipSpace = new Polygon(axisAlignedBB, shipTransform.getGlobalToSubspace()).getEnclosedAABB();
            boolean collisionInShip = this.func_72829_c(aabbInShipSpace);
            if (!collisionInShip) continue;
            callbackInfoReturnable.setReturnValue(true);
            return;
        }
    }
}

