/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.world;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import org.valkyrienskies.mod.fixes.FixAccurateRain;
import valkyrienwarfare.api.TransformType;

@Mixin(value={World.class})
public class MixinClientWorld {
    private final World thisAsWorld = (World)World.class.cast(this);
    private final Map<BlockPos, BlockPos> precipitationHeightCache = new HashMap<BlockPos, BlockPos>();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onPreTick(CallbackInfo ci) {
        this.precipitationHeightCache.clear();
    }

    @SideOnly(value=Side.CLIENT)
    @Overwrite
    public BlockPos func_175725_q(BlockPos input) {
        World thisAsWorld = (World)World.class.cast(this);
        BlockPos originalHeight = thisAsWorld.func_175726_f(input).func_177440_h(input);
        if (thisAsWorld.field_72995_K) {
            BlockPos cached;
            if (this.precipitationHeightCache.containsKey(input) && (cached = this.precipitationHeightCache.get(input)) != null) {
                return cached;
            }
            BlockPos rainPosWithShips = FixAccurateRain.getRainPosFromShips(thisAsWorld, originalHeight);
            this.precipitationHeightCache.put(input, rainPosWithShips);
            return rainPosWithShips;
        }
        this.precipitationHeightCache.put(input, originalHeight);
        return originalHeight;
    }

    @SideOnly(value=Side.CLIENT)
    @Inject(method={"getCombinedLight(Lnet/minecraft/util/math/BlockPos;I)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetCombinedLight(BlockPos pos, int lightValue, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        World world = this.thisAsWorld;
        try {
            int i = world.func_175705_a(EnumSkyBlock.SKY, pos);
            int j = world.func_175705_a(EnumSkyBlock.BLOCK, pos);
            AxisAlignedBB lightBB = new AxisAlignedBB((double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - 2), (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 2));
            List physicsObjectList = ValkyrienUtils.getPhysObjWorld(world).getAllLoadedThreadSafe().stream().filter(physicsObject -> lightBB.func_72326_a(physicsObject.getShipBB())).collect(Collectors.toList());
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (PhysicsObject physicsObject2 : physicsObjectList) {
                Vector3d posInLocal = physicsObject2.getShipTransformationManager().getRenderTransform().transformPositionNew(JOML.convertTo3d((Vec3i)pos).add(0.5, 0.5, 0.5), TransformType.GLOBAL_TO_SUBSPACE);
                int minX = (int)Math.floor(posInLocal.x());
                int minY = (int)Math.floor(posInLocal.y());
                int minZ = (int)Math.floor(posInLocal.z());
                int shipSkyLight = 0;
                for (int x = minX; x <= minX + 1; ++x) {
                    for (int y = minY; y <= minY + 1; ++y) {
                        for (int z = minZ; z <= minZ + 1; ++z) {
                            mutableBlockPos.func_181079_c(x, y, z);
                            IBlockState blockState = world.func_180495_p((BlockPos)mutableBlockPos);
                            if (blockState.func_185913_b()) continue;
                            int localBlockLight = world.func_175705_a(EnumSkyBlock.BLOCK, (BlockPos)mutableBlockPos);
                            int localSkyLight = world.func_175705_a(EnumSkyBlock.SKY, (BlockPos)mutableBlockPos);
                            j = Math.max(j, localBlockLight);
                            shipSkyLight = Math.max(shipSkyLight, localSkyLight);
                        }
                    }
                }
                if (i <= shipSkyLight) continue;
                i = shipSkyLight;
            }
            if (j < lightValue) {
                j = lightValue;
            }
            callbackInfoReturnable.setReturnValue(i << 20 | j << 4);
        }
        catch (Exception e) {
            System.err.println("Something just went wrong here, getting default light value instead!");
            e.printStackTrace();
        }
    }
}

