/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.network;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.network.IHasPlayerMovementData;
import org.valkyrienskies.mod.common.network.PlayerMovementData;
import org.valkyrienskies.mod.common.ships.QueryableShipData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.chunk_claims.ShipChunkAllocator;
import org.valkyrienskies.mod.common.ships.entity_interaction.IDraggable;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.VSMath;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mixin(value={NetHandlerPlayServer.class})
public abstract class MixinNetHandlerPlayServer {
    private final NetHandlerPlayServer thisAsNetHandler = (NetHandlerPlayServer)NetHandlerPlayServer.class.cast(this);
    private boolean redirectingSetPlayerLocation = false;
    @Shadow
    public EntityPlayerMP field_147369_b;
    @Shadow
    public double field_184349_l;
    @Shadow
    public double field_184350_m;
    @Shadow
    public double field_184351_n;
    @Shadow
    public double field_184352_o;
    @Shadow
    public double field_184353_p;
    @Shadow
    public double field_184354_q;

    @Inject(method={"setPlayerLocation(DDDFFLjava/util/Set;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onSetPlayerLocation(double x, double y, double z, float yaw, float pitch, Set<SPacketPlayerPosLook.EnumFlags> relativeSet, CallbackInfo callbackInfo) {
        BlockPos pos;
        if (!this.redirectingSetPlayerLocation && ShipChunkAllocator.isBlockInShipyard(pos = new BlockPos(x, y, z))) {
            callbackInfo.cancel();
            this.redirectingSetPlayerLocation = true;
            World world = this.field_147369_b.func_130014_f_();
            Optional<ShipData> ship = ValkyrienUtils.getShipManagingBlock(world, pos);
            if (ship.isPresent()) {
                Vector3d tpPos = new Vector3d(x, y, z);
                ship.get().getShipTransform().transformPosition(tpPos, TransformType.SUBSPACE_TO_GLOBAL);
                this.thisAsNetHandler.func_175089_a(tpPos.x, tpPos.y, tpPos.z, yaw, pitch, relativeSet);
                if (VSConfig.showAnnoyingDebugOutput) {
                    System.out.printf("Player was teleported to %.1f, %.1f, %.1f, redirected to %.1f, %.1f, %.1f\n", x, y, z, tpPos.x, tpPos.y, tpPos.z);
                }
            } else {
                if (VSConfig.showAnnoyingDebugOutput) {
                    System.out.printf("Player was teleported to %.1f, %.1f, %.1f, cancelling because no ship found\n", x, y, z);
                }
                this.field_147369_b.func_145747_a((ITextComponent)new TextComponentString("Tried teleporting you to shipyard but there was no ship; teleportation canceled."));
            }
            this.redirectingSetPlayerLocation = false;
        }
    }

    @Redirect(method={"processPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;getCollisionBoxes(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/util/List;"))
    private List<AxisAlignedBB> removeStuckInBlockMovementCheck(WorldServer worldServer, Entity entityIn, AxisAlignedBB aabb) {
        return ImmutableList.of();
    }

    @ModifyConstant(method={"processPlayer"}, constant={@Constant(doubleValue=0.0625, ordinal=1)})
    private double allowMovementToBeVeryWrong(double originalConstant) {
        return 10.0;
    }

    @Inject(method={"processPlayer"}, at={@At(value="HEAD")})
    private void preProcessPlayer(CPacketPlayer packetPlayer, CallbackInfo info) {
        if (this.field_147369_b.func_71121_q().func_152345_ab()) {
            if (this.field_147369_b.func_184850_K()) {
                return;
            }
            PlayerMovementData addedPlayerMovementData = ((IHasPlayerMovementData)IHasPlayerMovementData.class.cast(packetPlayer)).getPlayerMovementData();
            World world = this.field_147369_b.field_70170_p;
            UUID lastTouchedShipId = addedPlayerMovementData.getLastTouchedShipId();
            int ticksSinceTouchedLastShip = addedPlayerMovementData.getTicksSinceTouchedLastShip();
            if (ticksSinceTouchedLastShip > 40) {
                IDraggable playerAsDraggable = (IDraggable)IDraggable.class.cast(this.field_147369_b);
                playerAsDraggable.setEntityShipMovementData(playerAsDraggable.getEntityShipMovementData().withLastTouchedShip(null).withAddedLinearVelocity(new Vector3d()).withAddedYawVelocity(0.0).withTicksPartOfGround(addedPlayerMovementData.getTicksPartOfGround()).withTicksSinceTouchedShip(ticksSinceTouchedLastShip));
                return;
            }
            int ticksPartOfGround = addedPlayerMovementData.getTicksPartOfGround();
            Vector3d playerPosInShip = new Vector3d(addedPlayerMovementData.getPlayerPosInShip());
            Vector3d playerLookInShip = new Vector3d(addedPlayerMovementData.getPlayerLookInShip());
            ShipData lastTouchedShip = null;
            if (lastTouchedShipId != null) {
                QueryableShipData queryableShipData = QueryableShipData.get(world);
                Optional<ShipData> shipDataOptional = queryableShipData.getShip(lastTouchedShipId);
                if (shipDataOptional.isPresent()) {
                    lastTouchedShip = shipDataOptional.get();
                    PhysicsObject shipObject = ValkyrienUtils.getServerShipManager(world).getPhysObjectFromUUID(lastTouchedShip.getUuid());
                    if (shipObject != null) {
                        if (shipObject.getTicksSinceShipTeleport() > PhysicsObject.TICKS_SINCE_TELEPORT_TO_START_DRAGGING) {
                            ShipTransform shipTransform = lastTouchedShip.getShipTransform();
                            shipTransform.transformPosition(playerPosInShip, TransformType.SUBSPACE_TO_GLOBAL);
                            shipTransform.transformDirection(playerLookInShip, TransformType.SUBSPACE_TO_GLOBAL);
                        } else {
                            playerPosInShip.set(this.field_147369_b.field_70165_t, this.field_147369_b.field_70163_u, this.field_147369_b.field_70161_v);
                        }
                    }
                } else {
                    return;
                }
            }
            Tuple<Double, Double> pitchYawTuple = VSMath.getPitchYawFromVector(playerLookInShip);
            double playerPitchInGlobal = (Double)pitchYawTuple.func_76341_a();
            double playerYawInGlobal = (Double)pitchYawTuple.func_76340_b();
            packetPlayer.field_149480_h = true;
            packetPlayer.field_149479_a = playerPosInShip.x();
            packetPlayer.field_149477_b = playerPosInShip.y();
            packetPlayer.field_149478_c = playerPosInShip.z();
            packetPlayer.field_149476_e = (float)playerYawInGlobal;
            packetPlayer.field_149473_f = (float)playerPitchInGlobal;
            this.field_147369_b.field_70159_w = packetPlayer.field_149479_a - this.field_184349_l;
            this.field_147369_b.field_70181_x = packetPlayer.field_149477_b - this.field_184350_m;
            this.field_147369_b.field_70179_y = packetPlayer.field_149478_c - this.field_184351_n;
            IDraggable playerAsDraggable = (IDraggable)IDraggable.class.cast(this.field_147369_b);
            playerAsDraggable.setEntityShipMovementData(playerAsDraggable.getEntityShipMovementData().withLastTouchedShip(lastTouchedShip).withAddedLinearVelocity(new Vector3d()).withAddedYawVelocity(0.0).withTicksPartOfGround(ticksPartOfGround).withTicksSinceTouchedShip(ticksSinceTouchedLastShip));
        }
    }
}

