/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.entity.EntityShipMovementData;
import org.valkyrienskies.mod.common.ships.ShipData;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityShipMountData;
import org.valkyrienskies.mod.common.ships.entity_interaction.IDraggable;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IDraggable {
    private final Entity thisAsEntity = (Entity)Entity.class.cast(this);
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    public float field_70126_B;
    @Shadow
    public float field_70127_C;
    @Shadow
    public World field_70170_p;
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public double field_70161_v;
    private Vector3d searchVector = null;
    private EntityShipMovementData entityShipMovementData = new EntityShipMovementData(null, 0, 0, new Vector3d(), 0.0);
    private int ticksInAirPocket = 0;
    @Shadow
    public boolean field_70171_ac;

    @Overwrite
    public Vec3d func_70676_i(float partialTicks) {
        Vec3d original;
        if (partialTicks == 1.0f) {
            original = this.func_174806_f(this.field_70125_A, this.field_70177_z);
        } else {
            float f = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * partialTicks;
            float f1 = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * partialTicks;
            original = this.func_174806_f(f, f1);
        }
        EntityShipMountData mountData = ValkyrienUtils.getMountedShipAndPos((Entity)Entity.class.cast(this));
        if (mountData.isMounted()) {
            return mountData.getMountedShip().getShipTransformationManager().getRenderTransform().rotate(original, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return original;
    }

    @Overwrite
    public final Vec3d func_174806_f(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        Vec3d vanilla = new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
        EntityShipMountData mountData = ValkyrienUtils.getMountedShipAndPos((Entity)Entity.class.cast(this));
        if (mountData.isMounted()) {
            return mountData.getMountedShip().getShipTransformationManager().getRenderTransform().rotate(vanilla, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return vanilla;
    }

    @Shadow
    public abstract void func_70091_d(MoverType var1, double var2, double var4, double var6);

    @Overwrite
    public double func_70092_e(double x, double y, double z) {
        double d0 = this.field_70165_t - x;
        double d1 = this.field_70163_u - y;
        double d2 = this.field_70161_v - z;
        double vanilla = d0 * d0 + d1 * d1 + d2 * d2;
        if (vanilla < 64.0) {
            return vanilla;
        }
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(this.field_70170_p, new BlockPos(x, y, z));
        if (physicsObject.isPresent()) {
            Vector3d posVec = new Vector3d(x, y, z);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transformPosition(posVec, TransformType.SUBSPACE_TO_GLOBAL);
            posVec.x -= this.field_70165_t;
            posVec.y -= this.field_70163_u;
            posVec.z -= this.field_70161_v;
            if (vanilla > posVec.lengthSquared()) {
                return posVec.lengthSquared();
            }
        }
        return vanilla;
    }

    @Overwrite
    public double func_174818_b(BlockPos pos) {
        double vanilla = pos.func_185332_f((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        if (vanilla < 64.0) {
            return vanilla;
        }
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(this.field_70170_p, pos);
        if (physicsObject.isPresent()) {
            Vector3d posVec = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transformPosition(posVec, TransformType.SUBSPACE_TO_GLOBAL);
            posVec.x -= this.field_70165_t;
            posVec.y -= this.field_70163_u;
            posVec.z -= this.field_70161_v;
            if (vanilla > posVec.lengthSquared()) {
                return posVec.lengthSquared();
            }
        }
        return vanilla;
    }

    @Redirect(method={"createRunningParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;floor(D)I", ordinal=0))
    private int runningParticlesFirstFloor(double d) {
        ShipData lastTouchedShip = ValkyrienUtils.getLastShipTouchedByEntity(this.thisAsEntity);
        if (lastTouchedShip == null) {
            this.searchVector = null;
            return MathHelper.func_76128_c((double)d);
        }
        this.searchVector = new Vector3d(this.field_70165_t, this.field_70163_u - (double)0.2f, this.field_70161_v);
        lastTouchedShip.getShipTransform().transformPosition(this.searchVector, TransformType.GLOBAL_TO_SUBSPACE);
        return MathHelper.func_76128_c((double)this.searchVector.x);
    }

    @Redirect(method={"createRunningParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;floor(D)I", ordinal=1))
    private int runningParticlesSecondFloor(double d) {
        if (this.searchVector == null) {
            return MathHelper.func_76128_c((double)d);
        }
        return MathHelper.func_76128_c((double)this.searchVector.y);
    }

    @Redirect(method={"createRunningParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;floor(D)I", ordinal=2))
    public int runningParticlesThirdFloor(double d) {
        if (this.searchVector == null) {
            return MathHelper.func_76128_c((double)d);
        }
        return MathHelper.func_76128_c((double)this.searchVector.z);
    }

    @Shadow
    public float func_70047_e() {
        return 0.0f;
    }

    @Shadow
    public abstract World func_130014_f_();

    @Shadow
    public abstract boolean func_70090_H();

    @Inject(method={"getPositionEyes(F)Lnet/minecraft/util/math/Vec3d;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getPositionEyesInject(float partialTicks, CallbackInfoReturnable<Vec3d> callbackInfo) {
        EntityShipMountData mountData = ValkyrienUtils.getMountedShipAndPos((Entity)Entity.class.cast(this));
        if (mountData.isMounted()) {
            Vector3d playerPosition = JOML.convert(mountData.getMountPos());
            mountData.getMountedShip().getShipTransformationManager().getRenderTransform().transformPosition(playerPosition, TransformType.SUBSPACE_TO_GLOBAL);
            Vector3d playerEyes = new Vector3d(0.0, this.func_70047_e(), 0.0);
            mountData.getMountedShip().getShipTransformationManager().getCurrentTickTransform().transformDirection(playerEyes, TransformType.SUBSPACE_TO_GLOBAL);
            playerPosition.add(playerEyes);
            callbackInfo.setReturnValue(JOML.toMinecraft(playerPosition));
            callbackInfo.cancel();
        }
    }

    @Override
    @Nonnull
    public EntityShipMovementData getEntityShipMovementData() {
        return this.entityShipMovementData;
    }

    @Override
    public void setEntityShipMovementData(EntityShipMovementData entityShipMovementData) {
        this.entityShipMovementData = entityShipMovementData;
    }

    @Override
    public boolean getInAirPocket() {
        return this.ticksInAirPocket > 0;
    }

    @Override
    public void setTicksAirPocket(int ticksInAirPocket) {
        this.ticksInAirPocket = ticksInAirPocket;
    }

    @Override
    public void decrementTicksAirPocket() {
        --this.ticksInAirPocket;
    }

    @Inject(method={"handleWaterMovement"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleWaterMovement(CallbackInfoReturnable<Boolean> cir) {
        if (this.getInAirPocket()) {
            this.field_70171_ac = false;
            cir.setReturnValue(false);
        }
    }

    @Inject(method={"isInsideOfMaterial"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPreIsInsideOfMaterial(Material materialIn, CallbackInfoReturnable<Boolean> cir) {
        if (materialIn == Material.field_151586_h && this.getInAirPocket()) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method={"isInLava"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPreIsInLava(CallbackInfoReturnable<Boolean> cir) {
        if (this.getInAirPocket()) {
            cir.setReturnValue(false);
        }
    }
}

