/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.client.renderer;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

@Mixin(value={RenderGlobal.class})
public abstract class MixinRenderGlobal {
    @Shadow
    @Final
    public Map<Integer, DestroyBlockProgress> field_72738_E;
    @Shadow
    @Final
    public TextureManager field_72770_i;
    @Shadow
    @Final
    public TextureAtlasSprite[] field_94141_F;
    @Shadow
    @Final
    public Minecraft field_72777_q;
    @Shadow
    public WorldClient field_72769_h;

    @Shadow
    public static void func_189697_a(AxisAlignedBB box, float red, float green, float blue, float alpha) {
    }

    @Shadow
    public abstract void func_180443_s();

    @Shadow
    public abstract void func_174969_t();

    @Overwrite
    public void func_174981_a(Tessellator tessellatorIn, BufferBuilder worldRendererIn, Entity entityIn, float partialTicks) {
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        if (!this.field_72738_E.isEmpty()) {
            this.field_72770_i.func_110577_a(TextureMap.field_110575_b);
            this.func_180443_s();
            worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            worldRendererIn.func_178969_c(-d0, -d1, -d2);
            worldRendererIn.func_78914_f();
            Iterator<DestroyBlockProgress> iterator = this.field_72738_E.values().iterator();
            while (iterator.hasNext()) {
                boolean hasBreak;
                DestroyBlockProgress destroyblockprogress = iterator.next();
                BlockPos blockpos = destroyblockprogress.func_180246_b();
                double d3 = (double)blockpos.func_177958_n() - d0;
                double d4 = (double)blockpos.func_177956_o() - d1;
                double d5 = (double)blockpos.func_177952_p() - d2;
                Block block = this.field_72769_h.func_180495_p(blockpos).func_177230_c();
                TileEntity te = this.field_72769_h.func_175625_s(blockpos);
                boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
                if (!hasBreak) {
                    boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
                }
                if (hasBreak) continue;
                Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)this.field_72769_h, blockpos);
                if (!physicsObject.isPresent() && d3 * d3 + d4 * d4 + d5 * d5 > 1024.0) {
                    iterator.remove();
                    continue;
                }
                IBlockState iblockstate = this.field_72769_h.func_180495_p(blockpos);
                if (physicsObject.isPresent()) {
                    physicsObject.get().getShipRenderer().applyRenderTransform(partialTicks);
                    worldRendererIn.func_178969_c((double)(-physicsObject.get().getShipRenderer().offsetPos.func_177958_n()), (double)(-physicsObject.get().getShipRenderer().offsetPos.func_177956_o()), (double)(-physicsObject.get().getShipRenderer().offsetPos.func_177952_p()));
                }
                if (iblockstate.func_185904_a() != Material.field_151579_a) {
                    int i = destroyblockprogress.func_73106_e();
                    TextureAtlasSprite textureatlassprite = this.field_94141_F[i];
                    BlockRendererDispatcher blockrendererdispatcher = this.field_72777_q.func_175602_ab();
                    try {
                        blockrendererdispatcher.func_175020_a(iblockstate, blockpos, textureatlassprite, (IBlockAccess)this.field_72769_h);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                worldRendererIn.func_178969_c(-d0, -d1, -d2);
                if (!physicsObject.isPresent()) continue;
                tessellatorIn.func_78381_a();
                worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                physicsObject.get().getShipRenderer().applyInverseTransform(partialTicks);
            }
            tessellatorIn.func_78381_a();
            worldRendererIn.func_178969_c(0.0, 0.0, 0.0);
            this.func_174969_t();
        }
    }

    @Overwrite
    public void func_72731_b(EntityPlayer player, RayTraceResult movingObjectPositionIn, int execute, float partialTicks) {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(player.field_70170_p, movingObjectPositionIn.func_178782_a());
        if (physicsObject.isPresent()) {
            physicsObject.get().getShipRenderer().applyRenderTransform(partialTicks);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder BufferBuilder2 = tessellator.func_178180_c();
            double xOff = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks - (double)physicsObject.get().getShipRenderer().offsetPos.func_177958_n();
            double yOff = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks - (double)physicsObject.get().getShipRenderer().offsetPos.func_177956_o();
            double zOff = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks - (double)physicsObject.get().getShipRenderer().offsetPos.func_177952_p();
            BufferBuilder2.field_179004_l += xOff;
            BufferBuilder2.field_179005_m += yOff;
            BufferBuilder2.field_179002_n += zOff;
            this.drawSelectionBoxOriginal(player, movingObjectPositionIn, execute, partialTicks);
            BufferBuilder2.field_179004_l -= xOff;
            BufferBuilder2.field_179005_m -= yOff;
            BufferBuilder2.field_179002_n -= zOff;
            physicsObject.get().getShipRenderer().applyInverseTransform(partialTicks);
        } else {
            this.drawSelectionBoxOriginal(player, movingObjectPositionIn, execute, partialTicks);
        }
    }

    private void drawSelectionBoxOriginal(EntityPlayer player, RayTraceResult movingObjectPositionIn, int execute, float partialTicks) {
        if (execute == 0 && movingObjectPositionIn.field_72313_a == RayTraceResult.Type.BLOCK) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            BlockPos blockpos = movingObjectPositionIn.func_178782_a();
            IBlockState iblockstate = this.field_72769_h.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() != Material.field_151579_a && this.field_72769_h.func_175723_af().func_177746_a(blockpos)) {
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                MixinRenderGlobal.func_189697_a(iblockstate.func_185918_c((World)this.field_72769_h, blockpos).func_186662_g((double)0.002f).func_72317_d(-d0, -d1, -d2), 0.0f, 0.0f, 0.0f, 0.4f);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    @Inject(method={"renderEntities(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V"}, at={@At(value="HEAD")})
    private void preRenderEntities(Entity renderViewEntity, ICamera camera, float partialTicks, CallbackInfo callbackInfo) {
    }

    @Inject(method={"renderBlockLayer(Lnet/minecraft/util/BlockRenderLayer;DILnet/minecraft/entity/Entity;)I"}, at={@At(value="HEAD")})
    private void preRenderBlockLayer(BlockRenderLayer blockLayerIn, double partialTicks, int pass, Entity entityIn, CallbackInfoReturnable callbackInfo) {
        RenderHelper.func_74518_a();
        Frustum icamera = new Frustum();
        Entity entity = this.field_72777_q.func_175606_aa();
        double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * partialTicks;
        double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * partialTicks;
        double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * partialTicks;
        icamera.func_78547_a(d0, d1, d2);
        for (PhysicsObject physicsObject : ValkyrienUtils.getPhysObjWorld((World)this.field_72769_h).getAllLoadedPhysObj()) {
            GL11.glPushMatrix();
            if (physicsObject.getShipRenderer().shouldRender((ICamera)icamera)) {
                physicsObject.getShipRenderer().renderBlockLayer(blockLayerIn, partialTicks, pass, (ICamera)icamera);
            }
            GL11.glPopMatrix();
        }
        GlStateManager.func_179117_G();
    }

    @Inject(method={"markBlocksForUpdate"}, at={@At(value="HEAD")})
    private void preMarkBlocksForUpdate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean updateImmediately, CallbackInfo ci) {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)this.field_72769_h, new BlockPos(minX, minY, minZ));
        if (!physicsObject.isPresent()) {
            physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)this.field_72769_h, new BlockPos(minX, maxY, maxZ));
        }
        if (!physicsObject.isPresent()) {
            physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)this.field_72769_h, new BlockPos(maxX, maxY, minZ));
        }
        if (!physicsObject.isPresent()) {
            physicsObject = ValkyrienUtils.getPhysoManagingBlock((World)this.field_72769_h, new BlockPos(maxX, maxY, maxZ));
        }
        physicsObject.ifPresent(p -> p.getShipRenderer().updateRange(minX, minY, minZ, maxX, maxY, maxZ, updateImmediately));
    }
}

