/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.client.renderer;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.piloting.IShipPilot;
import org.valkyrienskies.mod.common.ships.entity_interaction.EntityShipMountData;
import org.valkyrienskies.mod.common.ships.ship_transform.ShipTransform;
import org.valkyrienskies.mod.common.ships.ship_world.IWorldVS;
import org.valkyrienskies.mod.common.util.JOML;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mixin(value={EntityRenderer.class})
public abstract class MixinEntityRenderer {
    @Shadow
    @Final
    public Minecraft field_78531_r;
    @Shadow
    public float field_78491_C;
    @Shadow
    public boolean field_78500_U;

    @Inject(method={"orientCamera"}, at={@At(value="HEAD")}, cancellable=true)
    private void orientCamera(float partialTicks, CallbackInfo ci) {
        EntityShipMountData mountData = ValkyrienUtils.getMountedShipAndPos(this.field_78531_r.func_175606_aa());
        if (mountData.getMountedShip() == null) {
            return;
        }
        ci.cancel();
        Entity entity = this.field_78531_r.func_175606_aa();
        Vector3d eyeVector = new Vector3d(0.0, entity.func_70047_e(), 0.0);
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70608_bn()) {
            eyeVector.y += 0.7;
        }
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        if (mountData.isMounted() && mountData.getMountedShip().getShipRenderer().offsetPos != null) {
            ShipTransform renderTransform = mountData.getMountedShip().getShipTransformationManager().getRenderTransform();
            renderTransform.transformDirection(eyeVector, TransformType.SUBSPACE_TO_GLOBAL);
            Vector3d playerPosition = JOML.convert(mountData.getMountPos());
            renderTransform.transformPosition(playerPosition, TransformType.SUBSPACE_TO_GLOBAL);
            d0 = playerPosition.x;
            d1 = playerPosition.y;
            d2 = playerPosition.z;
        }
        d0 += eyeVector.x;
        d1 += eyeVector.y;
        d2 += eyeVector.z;
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70608_bn()) {
            if (!this.field_78531_r.field_71474_y.field_74325_U) {
                if (mountData.isMounted()) {
                    Vector3d playerPosInLocal = JOML.convert(mountData.getMountPos());
                    playerPosInLocal.sub(0.5, 0.6875, 0.5);
                    playerPosInLocal.round();
                    BlockPos bedPos = new BlockPos(playerPosInLocal.x, playerPosInLocal.y, playerPosInLocal.z);
                    IBlockState state = this.field_78531_r.field_71441_e.func_180495_p(bedPos);
                    Block block = state.func_177230_c();
                    float angleYaw = 0.0f;
                    if (block != null && block.isBed(state, (IBlockAccess)entity.field_70170_p, bedPos, entity)) {
                        angleYaw = block.getBedDirection(state, (IBlockAccess)entity.field_70170_p, bedPos).func_176736_b() * 90;
                        angleYaw += 180.0f;
                    }
                    entity.field_70177_z = entity.field_70126_B = angleYaw;
                    entity.field_70127_C = 0.0f;
                    entity.field_70125_A = 0.0f;
                } else {
                    BlockPos blockpos = new BlockPos(entity);
                    IBlockState iblockstate = this.field_78531_r.field_71441_e.func_180495_p(blockpos);
                    ForgeHooksClient.orientBedCamera((IBlockAccess)this.field_78531_r.field_71441_e, (BlockPos)blockpos, (IBlockState)iblockstate, (Entity)entity);
                    GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks + 180.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)-1.0f, (float)0.0f, (float)0.0f);
                }
            }
        } else if (this.field_78531_r.field_71474_y.field_74320_O > 0) {
            double d3 = this.field_78491_C + (4.0f - this.field_78491_C) * partialTicks;
            IShipPilot shipPilot = (IShipPilot)Minecraft.func_71410_x().field_71439_g;
            if (shipPilot.isPilotingShip()) {
                d3 = 15.0;
            }
            if (this.field_78531_r.field_71474_y.field_74325_U) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((float)(-d3)));
            } else {
                float f1 = entity.field_70177_z;
                float f2 = entity.field_70125_A;
                if (this.field_78531_r.field_71474_y.field_74320_O == 2) {
                    f2 += 180.0f;
                }
                double d4 = (double)(-MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
                double d5 = (double)(MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
                double d6 = (double)(-MathHelper.func_76126_a((float)(f2 * ((float)Math.PI / 180)))) * d3;
                for (int i = 0; i < 8; ++i) {
                    double d7;
                    float f3 = (i & 1) * 2 - 1;
                    float f4 = (i >> 1 & 1) * 2 - 1;
                    float f5 = (i >> 2 & 1) * 2 - 1;
                    IShipPilot pilot = (IShipPilot)Minecraft.func_71410_x().field_71439_g;
                    ((IWorldVS)this.field_78531_r.field_71441_e).excludeShipFromRayTracer(((IShipPilot)this.field_78531_r.field_71439_g).getPilotedShip());
                    RayTraceResult raytraceresult = this.field_78531_r.field_71441_e.func_72933_a(new Vec3d(d0 + (double)(f3 *= 0.1f), d1 + (double)(f4 *= 0.1f), d2 + (double)(f5 *= 0.1f)), new Vec3d(d0 - d4 + (double)f3 + (double)f5, d1 - d6 + (double)f4, d2 - d5 + (double)f5));
                    ((IWorldVS)this.field_78531_r.field_71441_e).unexcludeShipFromRayTracer(((IShipPilot)this.field_78531_r.field_71439_g).getPilotedShip());
                    if (raytraceresult == null || !((d7 = raytraceresult.field_72307_f.func_72438_d(new Vec3d(d0, d1, d2))) < d3)) continue;
                    d3 = d7;
                }
                if (this.field_78531_r.field_71474_y.field_74320_O == 2) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GlStateManager.func_179114_b((float)(entity.field_70125_A - f2), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70177_z - f1), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((float)(-d3)));
                GlStateManager.func_179114_b((float)(f1 - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(f2 - entity.field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.05f);
        }
        if (!this.field_78531_r.field_71474_y.field_74325_U) {
            float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks + 180.0f;
            float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            float roll = 0.0f;
            if (entity instanceof EntityAnimal) {
                EntityAnimal entityanimal = (EntityAnimal)entity;
                yaw = entityanimal.field_70758_at + (entityanimal.field_70759_as - entityanimal.field_70758_at) * partialTicks + 180.0f;
            }
            IBlockState state = ActiveRenderInfo.func_186703_a((World)this.field_78531_r.field_71441_e, (Entity)entity, (float)partialTicks);
            EntityViewRenderEvent.CameraSetup event = new EntityViewRenderEvent.CameraSetup((EntityRenderer)EntityRenderer.class.cast(this), entity, state, (double)partialTicks, yaw, pitch, roll);
            MinecraftForge.EVENT_BUS.post((Event)event);
            GlStateManager.func_179114_b((float)event.getRoll(), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)event.getPitch(), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)event.getYaw(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (mountData.isMounted() && mountData.getMountedShip().getShipRenderer().offsetPos != null) {
            ShipTransform renderTransform = mountData.getMountedShip().getShipTransformationManager().getRenderTransform();
            Quaterniond orientationQuat = renderTransform.rotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
            Vector3d radians = orientationQuat.getEulerAnglesXYZ(new Vector3d());
            float moddedPitch = (float)Math.toDegrees(radians.x());
            float moddedYaw = (float)Math.toDegrees(radians.y());
            float moddedRoll = (float)Math.toDegrees(radians.z());
            GlStateManager.func_179114_b((float)(-moddedRoll), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-moddedYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-moddedPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)(-eyeVector.x), (double)(-eyeVector.y), (double)(-eyeVector.z));
        d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks + eyeVector.x;
        d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + eyeVector.y;
        d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks + eyeVector.z;
        this.field_78500_U = this.field_78531_r.field_71438_f.func_72721_a(d0, d1, d2, partialTicks);
    }
}

