/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.client.particle;

import java.util.Optional;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.math.BlockPos;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mixin(value={ParticleManager.class})
public abstract class MixinParticleManager {
    @Inject(method={"addEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void preAddEffect(Particle effect, CallbackInfo callbackInfoReturnable) {
        if (effect == null) {
            callbackInfoReturnable.cancel();
            return;
        }
        BlockPos pos = new BlockPos(effect.field_187126_f, effect.field_187127_g, effect.field_187128_h);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysoManagingBlock(effect.field_187122_b, pos);
        if (physicsObject.isPresent()) {
            Vector3d posVec = new Vector3d(effect.field_187126_f, effect.field_187127_g, effect.field_187128_h);
            Vector3d velocity = new Vector3d(effect.field_187129_i, effect.field_187130_j, effect.field_187131_k);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transformPosition(posVec, TransformType.SUBSPACE_TO_GLOBAL);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transformDirection(velocity, TransformType.SUBSPACE_TO_GLOBAL);
            effect.func_187109_b(posVec.x, posVec.y, posVec.z);
            effect.field_187129_i = velocity.x;
            effect.field_187130_j = velocity.y;
            effect.field_187131_k = velocity.z;
        }
    }
}

