/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.client.multiplayer;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.valkyrienskies.mod.common.ships.ship_world.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mixin(value={WorldClient.class})
public class MixinWorldClient {
    @Shadow
    @Final
    private Minecraft field_73037_M;
    private final WorldClient thisAsWorldClient = (WorldClient)WorldClient.class.cast(this);

    @Overwrite
    public void func_73029_E(int posX, int posY, int posZ) {
        int i = 32;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ItemStack itemstack = this.field_73037_M.field_71439_g.func_184614_ca();
        boolean flag = this.field_73037_M.field_71442_b.func_178889_l() == GameType.CREATIVE && !itemstack.func_190926_b() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        AxisAlignedBB shipDetectionBB = new AxisAlignedBB((double)(posX - 32), (double)(posY - 32), (double)(posZ - 32), (double)(posX + 32), (double)(posY + 32), (double)(posZ + 32));
        List<PhysicsObject> nearbyShipObjects = ValkyrienUtils.getPhysObjWorld((World)this.thisAsWorldClient).getPhysObjectsInAABB(shipDetectionBB);
        Vector3d temp0 = new Vector3d();
        for (int j = 0; j < 667; ++j) {
            this.vs_showBarrierParticles(posX, posY, posZ, 16, random, flag, blockpos$mutableblockpos, nearbyShipObjects, temp0);
            this.vs_showBarrierParticles(posX, posY, posZ, 32, random, flag, blockpos$mutableblockpos, nearbyShipObjects, temp0);
        }
    }

    private void vs_showBarrierParticles(int x, int y, int z, int offset, Random random, boolean holdingBarrier, BlockPos.MutableBlockPos pos, List<PhysicsObject> nearbyShipObjects, Vector3d temp0) {
        int i = x + random.nextInt(offset) - random.nextInt(offset);
        int j = y + random.nextInt(offset) - random.nextInt(offset);
        int k = z + random.nextInt(offset) - random.nextInt(offset);
        pos.func_181079_c(i, j, k);
        this.vs_displayTickPos((BlockPos)pos, holdingBarrier, random);
        for (PhysicsObject physicsObject : nearbyShipObjects) {
            if (!MixinWorldClient.aabbContains(physicsObject.getShipBB(), i, j, k)) continue;
            Vector3d posInShip = physicsObject.getShipTransformationManager().getRenderTransform().transformPositionNew(temp0.set((double)i + 0.5, (double)j + 0.5, (double)k + 0.5), TransformType.GLOBAL_TO_SUBSPACE);
            double randomXOffset = random.nextDouble();
            double randomYOffset = random.nextDouble();
            double randomZOffset = random.nextDouble();
            pos.func_189532_c(posInShip.x() + randomXOffset, posInShip.y() + randomYOffset, posInShip.z() + randomZOffset);
            this.vs_displayTickPos((BlockPos)pos, holdingBarrier, random);
        }
    }

    private void vs_displayTickPos(BlockPos pos, boolean holdingBarrier, Random random) {
        IBlockState iblockstate = this.thisAsWorldClient.func_180495_p(pos);
        iblockstate.func_177230_c().func_180655_c(iblockstate, (World)this.thisAsWorldClient, pos, random);
        if (holdingBarrier && iblockstate.func_177230_c() == Blocks.field_180401_cv) {
            this.thisAsWorldClient.func_175688_a(EnumParticleTypes.BARRIER, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private static boolean aabbContains(AxisAlignedBB alignedBB, int x, int y, int z) {
        if ((double)x > alignedBB.field_72340_a && (double)x < alignedBB.field_72336_d) {
            if ((double)y > alignedBB.field_72338_b && (double)y < alignedBB.field_72337_e) {
                return (double)z > alignedBB.field_72339_c && (double)z < alignedBB.field_72334_f;
            }
            return false;
        }
        return false;
    }
}

