/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.deps.com.fasterxml.jackson.datatype.jdk8;

import java.io.IOException;
import java.util.OptionalDouble;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonParser;
import org.valkyrienskies.deps.com.fasterxml.jackson.core.JsonToken;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.DeserializationContext;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.DeserializationFeature;
import org.valkyrienskies.deps.com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;

class OptionalDoubleDeserializer
extends BaseScalarOptionalDeserializer<OptionalDouble> {
    private static final long serialVersionUID = 1L;
    static final OptionalDoubleDeserializer INSTANCE = new OptionalDoubleDeserializer();

    public OptionalDoubleDeserializer() {
        super(OptionalDouble.class, OptionalDouble.empty());
    }

    @Override
    public OptionalDouble deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return OptionalDouble.of(p.getDoubleValue());
        }
        switch (p.getCurrentTokenId()) {
            case 6: {
                String text = p.getText().trim();
                if (text.length() == 0) {
                    this._coerceEmptyString(ctxt, false);
                    return (OptionalDouble)this._empty;
                }
                if (this._hasTextualNull(text)) {
                    this._coerceTextualNull(ctxt, false);
                    return (OptionalDouble)this._empty;
                }
                return OptionalDouble.of(this._parseDoublePrimitive(ctxt, text));
            }
            case 7: {
                return OptionalDouble.of(p.getDoubleValue());
            }
            case 11: {
                return (OptionalDouble)this._empty;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                OptionalDouble parsed = this.deserialize(p, ctxt);
                this._verifyEndArrayForSingle(p, ctxt);
                return parsed;
            }
        }
        return (OptionalDouble)ctxt.handleUnexpectedToken(this._valueClass, p);
    }
}

