/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.deps.com.fasterxml.jackson.datatype.jdk8;

import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.BeanDescription;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.JavaType;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.SerializationConfig;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import org.valkyrienskies.deps.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import org.valkyrienskies.deps.com.fasterxml.jackson.datatype.jdk8.Jdk8OptionalBeanPropertyWriter;

public class Jdk8BeanSerializerModifier
extends BeanSerializerModifier {
    @Override
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        for (int i = 0; i < beanProperties.size(); ++i) {
            Object empty;
            BeanPropertyWriter writer = beanProperties.get(i);
            JavaType type = writer.getType();
            if (type.isTypeOrSubTypeOf(Optional.class)) {
                empty = Optional.empty();
            } else if (type.hasRawClass(OptionalLong.class)) {
                empty = OptionalLong.empty();
            } else if (type.hasRawClass(OptionalInt.class)) {
                empty = OptionalInt.empty();
            } else {
                if (!type.hasRawClass(OptionalDouble.class)) continue;
                empty = OptionalDouble.empty();
            }
            beanProperties.set(i, new Jdk8OptionalBeanPropertyWriter(writer, empty));
        }
        return beanProperties;
    }
}

