/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.compound.support;

import com.googlecode.cqengine.index.compound.support.CompoundAttribute;
import com.googlecode.cqengine.index.compound.support.CompoundValueTuple;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import java.util.ArrayList;

public class CompoundQuery<O>
implements Query<O> {
    private final And<O> andQuery;
    private final CompoundAttribute<O> compoundAttribute;

    public CompoundQuery(And<O> andQuery, CompoundAttribute<O> compoundAttribute) {
        this.andQuery = andQuery;
        this.compoundAttribute = compoundAttribute;
    }

    @Override
    public boolean matches(O object, QueryOptions queryOptions) {
        for (SimpleQuery simpleQuery : this.andQuery.getSimpleQueries()) {
            Equal equal = (Equal)simpleQuery;
            if (equal.matches(object, queryOptions)) continue;
            return false;
        }
        return true;
    }

    public And<O> getAndQuery() {
        return this.andQuery;
    }

    public CompoundAttribute<O> getCompoundAttribute() {
        return this.compoundAttribute;
    }

    public CompoundValueTuple<O> getCompoundValueTuple() {
        ArrayList attributeValues = new ArrayList(this.andQuery.getSimpleQueries().size());
        for (SimpleQuery simpleQuery : this.andQuery.getSimpleQueries()) {
            Equal equal = (Equal)simpleQuery;
            attributeValues.add(equal.getValue());
        }
        return new CompoundValueTuple(attributeValues);
    }

    public static <O> CompoundQuery<O> fromAndQueryIfSuitable(And<O> andQuery) {
        if (andQuery.hasLogicalQueries()) {
            return null;
        }
        ArrayList attributeList = new ArrayList(andQuery.getSimpleQueries().size());
        for (SimpleQuery simpleQuery : andQuery.getSimpleQueries()) {
            if (!(simpleQuery instanceof Equal)) {
                return null;
            }
            attributeList.add(simpleQuery.getAttribute());
        }
        CompoundAttribute compoundAttribute = new CompoundAttribute(attributeList);
        return new CompoundQuery<O>(andQuery, compoundAttribute);
    }
}

